package com.els.base.quality.concession.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="让步接收申请单")
public class ConcessionApply implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("让步接收申请单号")
    private String billNo;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料描述")
    private String materialSpecification;

    @ApiModelProperty("产品图号")
    private String mapNo;

    @ApiModelProperty("单据日期/产生日期")
    private Date billDate;

    @ApiModelProperty(" 让步性质 暂时 永久")
    private String concessionNatur;

    @ApiModelProperty("对产品影响 外观/性能/安全")
    private String productImpact;

    @ApiModelProperty("不合格发生过程 进货/过程/出场/客退不合格")
    private String concessionProcess;

    @ApiModelProperty("让步原因")
    private String concessionReason;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("技术评估")
    private String technicalEvaluation;

    @ApiModelProperty("工艺意见")
    private String processOpinion;

    @ApiModelProperty("项目质量工程师意见")
    private String projectComments;

    @ApiModelProperty("批准意见")
    private String approveComments;

    @ApiModelProperty("采购回复")
    private String purchasingReply;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @ApiModelProperty("备注")
    private String memo;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty(" 单据状态 1新增 2发布 3 审批中 4 确认 5 拒绝 ")
    private Integer billStatus;

    @ApiModelProperty("不合格处置单单据ID")
    private String unqualifiedBillId;

    @ApiModelProperty("不合格处置单据单据号")
    private String unqualifiedBillNo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialSpecification() {
        return materialSpecification;
    }

    public void setMaterialSpecification(String materialSpecification) {
        this.materialSpecification = materialSpecification == null ? null : materialSpecification.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getConcessionNatur() {
        return concessionNatur;
    }

    public void setConcessionNatur(String concessionNatur) {
        this.concessionNatur = concessionNatur == null ? null : concessionNatur.trim();
    }

    public String getProductImpact() {
        return productImpact;
    }

    public void setProductImpact(String productImpact) {
        this.productImpact = productImpact == null ? null : productImpact.trim();
    }

    public String getConcessionProcess() {
        return concessionProcess;
    }

    public void setConcessionProcess(String concessionProcess) {
        this.concessionProcess = concessionProcess == null ? null : concessionProcess.trim();
    }

    public String getConcessionReason() {
        return concessionReason;
    }

    public void setConcessionReason(String concessionReason) {
        this.concessionReason = concessionReason == null ? null : concessionReason.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getTechnicalEvaluation() {
        return technicalEvaluation;
    }

    public void setTechnicalEvaluation(String technicalEvaluation) {
        this.technicalEvaluation = technicalEvaluation == null ? null : technicalEvaluation.trim();
    }

    public String getProcessOpinion() {
        return processOpinion;
    }

    public void setProcessOpinion(String processOpinion) {
        this.processOpinion = processOpinion == null ? null : processOpinion.trim();
    }

    public String getProjectComments() {
        return projectComments;
    }

    public void setProjectComments(String projectComments) {
        this.projectComments = projectComments == null ? null : projectComments.trim();
    }

    public String getApproveComments() {
        return approveComments;
    }

    public void setApproveComments(String approveComments) {
        this.approveComments = approveComments == null ? null : approveComments.trim();
    }

    public String getPurchasingReply() {
        return purchasingReply;
    }

    public void setPurchasingReply(String purchasingReply) {
        this.purchasingReply = purchasingReply == null ? null : purchasingReply.trim();
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public String getUnqualifiedBillId() {
        return unqualifiedBillId;
    }

    public void setUnqualifiedBillId(String unqualifiedBillId) {
        this.unqualifiedBillId = unqualifiedBillId == null ? null : unqualifiedBillId.trim();
    }

    public String getUnqualifiedBillNo() {
        return unqualifiedBillNo;
    }

    public void setUnqualifiedBillNo(String unqualifiedBillNo) {
        this.unqualifiedBillNo = unqualifiedBillNo == null ? null : unqualifiedBillNo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}
