package com.els.base.quality.concession.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.concession.dao.ConcessionApplyMapper;
import com.els.base.quality.concession.entity.ConcessionApply;
import com.els.base.quality.concession.entity.ConcessionApplyExample;
import com.els.base.quality.concession.service.ConcessionApplyService;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.els.base.quality.concession.utils.UnApplyStatusEnum;
import com.els.base.quality.utils.UnQualifiedBillSourceType;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultConcessionApplyService")
public class ConcessionApplyServiceImpl implements ConcessionApplyService ,ITaskListener {
    @Resource
    protected ConcessionApplyMapper concessionApplyMapper;
    @Resource
    protected CompanyService companyService;

    @Resource
    protected WorkFlowService workFlowService;

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void addObj(ConcessionApply t) {
        this.concessionApplyMapper.insertSelective(t);
    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.concessionApplyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void modifyObj(ConcessionApply t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.concessionApplyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "concessionApply", keyGenerator = "redisKeyGenerator")
    @Override
    public ConcessionApply queryObjById(String id) {
        return this.concessionApplyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "concessionApply", keyGenerator = "redisKeyGenerator")
    @Override
    public List<ConcessionApply> queryAllObjByExample(ConcessionApplyExample example) {
        return this.concessionApplyMapper.selectByExample(example);
    }

    @Cacheable(value = "concessionApply", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<ConcessionApply> queryObjByPage(ConcessionApplyExample example) {
        PageView<ConcessionApply> pageView = example.getPageView();
        pageView.setQueryResult(this.concessionApplyMapper.selectByExampleByPage(example));
        return pageView;
    }

    /**
     * 创建让步接收申请单
     **/
    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void initiateConcession(List<UnQualifiedBill> list) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        ConcessionApply applyEntity = new ConcessionApply();
        for (UnQualifiedBill entity : list) {

            GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
            String billNo = generateCodeService.getNextCode("CONCESSION_APPLY_NO");

            applyEntity.setProjectId(projectId);
            applyEntity.setCompanyId(companyId);
            applyEntity.setIsEnable(Constant.YES_INT);
            applyEntity.setBillNo(billNo);
            applyEntity.setBillStatus(UnApplyStatusEnum.STATUS_NEW.getValue());
            //物料代码
            applyEntity.setMaterialCode(entity.getMaterialCode());
            applyEntity.setMaterialName(entity.getMaterialName());
            applyEntity.setMaterialSpecification(entity.getMaterialSpecification());
            //供应商代码
            applyEntity.setSupCompanyCode(entity.getSupCompanyCode());
            applyEntity.setSupCompanyName(entity.getSupCompanyName());
            applyEntity.setSupCompanySapCode(entity.getSupCompanySapCode());
            applyEntity.setMapNo(entity.getMapNo());
            //
            applyEntity.setBillDate(new Date());
            applyEntity.setQuantity(entity.getQuantity());
            //
            applyEntity.setConcessionReason(entity.getDisqualification());
            applyEntity.setConcessionProcess("进货");
            //
            applyEntity.setQuantity(entity.getQuantity());
            //不合格处置单单据
            applyEntity.setUnqualifiedBillId(entity.getId());
            //不合格处置单单据号
            applyEntity.setUnqualifiedBillNo(entity.getBillNo());

            Date nowDate = new Date();
            applyEntity.setUpdateTime(nowDate);
            applyEntity.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            applyEntity.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            applyEntity.setCreateTime(nowDate);
            applyEntity.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            applyEntity.setCreateUserName(SpringSecurityUtils.getLoginUserName());


            this.addObj(applyEntity);
        }

    }

    /**
     * 发送让步接收申请到采购员
     **/
    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void pushToBuyer(List<ConcessionApply> list) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        for (ConcessionApply item : list) {
            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(item.getId()).andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId);
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("让步接收申请单不存在，请核实!");
            }
            ConcessionApply concessionApply = ConcessionApplyArray.get(0);
            concessionApply.setBillStatus(UnApplyStatusEnum.STATUS_PUBLIC.getValue());
            Date nowDate = new Date();
            concessionApply.setUpdateTime(nowDate);
            concessionApply.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            concessionApply.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(concessionApply);
        }
    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void sendToSign(List<ConcessionApply> list) {

        for (ConcessionApply applyBill : list) {

            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("让步接收申请单不存在，请核实!");
            }
            ConcessionApply applyBillSign=ConcessionApplyArray.get(0);
            ProcessStartVO vo= ProcessStartVO.newInstance("hjd", applyBillSign.getBillNo(), applyBillSign.getId(),"pricing?id="+applyBillSign.getId());
            vo.setListenerClass(this.getClass());
             ProcessInstance startProcess=this.workFlowService.startProcess(vo);
            if(startProcess!=null) {
                applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVING.getValue());
                concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
             }
        }
    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void listen(TaskOperateEvent event) {
        if(event==null){
            return;
        }
        //获取业务ID
        String businessId = event.getBusinessId();
        if(StringUtils.isBlank(businessId)){
            return;
        }
        ConcessionApply bill = this.concessionApplyMapper.selectByPrimaryKey(businessId);
        String assignee = StringUtils.defaultIfBlank(event.getAssignee(),"");
        String fullMessage = StringUtils.defaultIfBlank(event.getApproveDesc(),"");
        String result="审批人："+assignee+"，审批意见："+fullMessage+" ; ";

        //1、审批流完成而且通过
        if (event.isFinished() && event.isPass()) {
            //做修改业务操作
            bill.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_SUCCESS.getValue());
            bill.setApproveComments(result);
            this.concessionApplyMapper.updateByPrimaryKeySelective(bill);
            //
            //
            //2、审批流完成但被驳回
        }else if(event.isFinished() && !event.isPass()){
            bill.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_REFUSED.getValue());
            bill.setApproveComments(result);
            this.concessionApplyMapper.updateByPrimaryKeySelective(bill);
            //部分审核的时候
        }else{

        }

    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void acceptToSuppler(List<ConcessionApply> list) {
        for (ConcessionApply applyBill : list) {

            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("让步接收申请单不存在，请核实!");
            }
            ConcessionApply applyBillSign=ConcessionApplyArray.get(0);
            applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_SUCCESS.getValue());
            this.concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
        }
    }
    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void refuseToSuppler(List<ConcessionApply> list) {
        for (ConcessionApply applyBill : list) {

            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("让步接收申请单不存在，请核实!");
            }
            ConcessionApply applyBillSign=ConcessionApplyArray.get(0);
            applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_REFUSED.getValue());
            this.concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
        }
    }

    @Transactional
    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void addAll(List<ConcessionApply> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.concessionApplyMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value = {"concessionApply"}, allEntries = true)
    @Override
    public void deleteByExample(ConcessionApplyExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.concessionApplyMapper.deleteByExample(arg0);
        
    }
}