package com.els.base.quality.concession.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.concession.entity.ConcessionApply;
import com.els.base.quality.concession.entity.ConcessionApplyExample;
import com.els.base.quality.concession.service.ConcessionApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "让步接收申请单")
@Controller
@RequestMapping("concessionApply")
public class ConcessionApplyController {
    @Resource
    protected ConcessionApplyService concessionApplyService;

    @ApiOperation(httpMethod = "POST", value = "创建让步接收申请单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ConcessionApply concessionApply) {
        this.concessionApplyService.addObj(concessionApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑让步接收申请单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ConcessionApply concessionApply) {
        Assert.isNotBlank(concessionApply.getId(), "id 为空，保存失败");
        this.concessionApplyService.modifyObj(concessionApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除让步接收申请单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.concessionApplyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询让步接收申请单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 ConcessionApply", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ConcessionApply>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        ConcessionApplyExample example = new ConcessionApplyExample();
        example.setPageView(new PageView<ConcessionApply>(pageNo, pageSize));

        ConcessionApplyExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<ConcessionApply> pageData = this.concessionApplyService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "查询让步接收申请单--供应商")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 ConcessionApply", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findSupplerByPage")
    @ResponseBody
    public ResponseResult<PageView<ConcessionApply>> findSupplerByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        ConcessionApplyExample example = new ConcessionApplyExample();
        example.setPageView(new PageView<ConcessionApply>(pageNo, pageSize));

        ConcessionApplyExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<ConcessionApply> pageData = this.concessionApplyService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "推送让步申请接收单给采购员")
    @RequestMapping("service/pushToBuyer")
    @ResponseBody
    public ResponseResult<String> pushToBuyer(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要发送的数据!");
        }
        this.concessionApplyService.pushToBuyer(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "让步接收申请单送签")
    @RequestMapping("service/sendToSign")
    @ResponseBody
    public ResponseResult<String> sendToSign(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要送签的数据!");
        }
        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "确认供应商回复")
    @RequestMapping("service/acceptToSuppler")
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要送签的数据!");
        }
        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "拒绝供应商回复")
    @RequestMapping("service/refuseToSuppler")
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要送签的数据!");
        }
        for (ConcessionApply item : list) {
            if (StringUtils.isEmpty(item.getPurchasingReply())) {
                throw new CommonException("让步接收申请单：" + item.getBillNo() + "回复不能为空，无法提交拒绝!");
            }
        }

        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }


}