package com.els.base.quality.fracas.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="FRACAS 表单数据")
public class FraCas implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("故障编码")
    private String faultNumber;

    @ApiModelProperty("发现日期")
    private Date discoveredDate;

    @ApiModelProperty("项目")
    private String project;

    @ApiModelProperty("产品编码")
    private String productNo;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商SAP代码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("零部件名称")
    private String parts;

    @ApiModelProperty("零部件序列号")
    private String partsNo;

    @ApiModelProperty("故障模式")
    private String failureMode;

    @ApiModelProperty("故障现象（描述）")
    private String failureDescription;

    @ApiModelProperty("发生时机")
    private String failureTiming;

    @ApiModelProperty("故障处理")
    private String failureDeal;

    @ApiModelProperty("根本原因/故障原因")
    private String failureReason;

    @ApiModelProperty("纠正措施")
    private String correctiveAction;

    @ApiModelProperty("状态")
    private String failureStatus;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("发送状态 0未发送 1已发送")
    private Integer sendStatus;

    @ApiModelProperty("状态 0 导入 1 新增（分配给采购）2 推送给供应商 3供应商回复 4 采购同意 5采购拒绝")
    private Integer status;

    @ApiModelProperty("当前处理人")
    private String currentHandler;

    @ApiModelProperty("采购员ID")
    private String buyerId;

    @ApiModelProperty("采购员名称")
    private String buyerName;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("要求供应商回复时间")
    private Date requestResponseTime;

    @ApiModelProperty("供应商回复时间")
    private Date supplierResponseTime;

    @ApiModelProperty("整改类型 8D报告单、整改单")
    private String rectificationType;

    @ApiModelProperty("采购回复")
    private String purchasingReply;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("原因分析")
    private String causeAnalysis;

    @ApiModelProperty("纠正措施")
    private String correctiveAnalysis;

    @ApiModelProperty("完成日期")
    private Date completionDate;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getFaultNumber() {
        return faultNumber;
    }

    public void setFaultNumber(String faultNumber) {
        this.faultNumber = faultNumber == null ? null : faultNumber.trim();
    }

    public Date getDiscoveredDate() {
        return discoveredDate;
    }

    public void setDiscoveredDate(Date discoveredDate) {
        this.discoveredDate = discoveredDate;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getProductNo() {
        return productNo;
    }

    public void setProductNo(String productNo) {
        this.productNo = productNo == null ? null : productNo.trim();
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName == null ? null : productName.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getParts() {
        return parts;
    }

    public void setParts(String parts) {
        this.parts = parts == null ? null : parts.trim();
    }

    public String getPartsNo() {
        return partsNo;
    }

    public void setPartsNo(String partsNo) {
        this.partsNo = partsNo == null ? null : partsNo.trim();
    }

    public String getFailureMode() {
        return failureMode;
    }

    public void setFailureMode(String failureMode) {
        this.failureMode = failureMode == null ? null : failureMode.trim();
    }

    public String getFailureDescription() {
        return failureDescription;
    }

    public void setFailureDescription(String failureDescription) {
        this.failureDescription = failureDescription == null ? null : failureDescription.trim();
    }

    public String getFailureTiming() {
        return failureTiming;
    }

    public void setFailureTiming(String failureTiming) {
        this.failureTiming = failureTiming == null ? null : failureTiming.trim();
    }

    public String getFailureDeal() {
        return failureDeal;
    }

    public void setFailureDeal(String failureDeal) {
        this.failureDeal = failureDeal == null ? null : failureDeal.trim();
    }

    public String getFailureReason() {
        return failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason == null ? null : failureReason.trim();
    }

    public String getCorrectiveAction() {
        return correctiveAction;
    }

    public void setCorrectiveAction(String correctiveAction) {
        this.correctiveAction = correctiveAction == null ? null : correctiveAction.trim();
    }

    public String getFailureStatus() {
        return failureStatus;
    }

    public void setFailureStatus(String failureStatus) {
        this.failureStatus = failureStatus == null ? null : failureStatus.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCurrentHandler() {
        return currentHandler;
    }

    public void setCurrentHandler(String currentHandler) {
        this.currentHandler = currentHandler == null ? null : currentHandler.trim();
    }

    public String getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId == null ? null : buyerId.trim();
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName == null ? null : buyerName.trim();
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getRequestResponseTime() {
        return requestResponseTime;
    }

    public void setRequestResponseTime(Date requestResponseTime) {
        this.requestResponseTime = requestResponseTime;
    }

    public Date getSupplierResponseTime() {
        return supplierResponseTime;
    }

    public void setSupplierResponseTime(Date supplierResponseTime) {
        this.supplierResponseTime = supplierResponseTime;
    }

    public String getRectificationType() {
        return rectificationType;
    }

    public void setRectificationType(String rectificationType) {
        this.rectificationType = rectificationType == null ? null : rectificationType.trim();
    }

    public String getPurchasingReply() {
        return purchasingReply;
    }

    public void setPurchasingReply(String purchasingReply) {
        this.purchasingReply = purchasingReply == null ? null : purchasingReply.trim();
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getCauseAnalysis() {
        return causeAnalysis;
    }

    public void setCauseAnalysis(String causeAnalysis) {
        this.causeAnalysis = causeAnalysis == null ? null : causeAnalysis.trim();
    }

    public String getCorrectiveAnalysis() {
        return correctiveAnalysis;
    }

    public void setCorrectiveAnalysis(String correctiveAnalysis) {
        this.correctiveAnalysis = correctiveAnalysis == null ? null : correctiveAnalysis.trim();
    }

    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}