package com.els.base.quality.fracas.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.fracas.entity.FraCas;
import com.els.base.quality.fracas.entity.FraCasExample;
import com.els.base.quality.fracas.service.FraCasService;
import com.els.base.quality.fracas.utils.FraCasStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;

@Api(value = "FRACAS 表单数据")
@Controller
@RequestMapping("fraCas")
public class FraCasController {
    private static Logger logger= LoggerFactory.getLogger(FraCasController.class);
    @Resource
    protected FraCasService fraCasService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod = "POST", value = "创建FRACAS 表单数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody FraCas fraCas) {
        this.fraCasService.addObj(fraCas);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod = "POST", value = "新增fracas")
    @RequestMapping("service/add")
    @ResponseBody
    public ResponseResult<String> add(@RequestBody FraCas fraCas) {
    	 Assert.isNotBlank(fraCas.getFaultNumber(), "故障编号不能为空");

         Assert.isNotNull(fraCas.getDiscoveredDate(), "发现日期不能为空");
         Assert.isNotBlank(fraCas.getProject(), "项目不能为空");
         Assert.isNotBlank(fraCas.getProductNo(), "产品编码不能为空");
         Assert.isNotBlank(fraCas.getProductName(), "产品名称不能为空");
         Assert.isNotBlank(fraCas.getParts(), "零部件名称不能为空");
         Assert.isNotBlank(fraCas.getPartsNo(), "零部件序列号不能为空");
         Assert.isNotBlank(fraCas.getFailureMode(), "故障模式不能为空");
         Assert.isNotBlank(fraCas.getFailureDescription(), "故障现象(描述)不能为空");
         Assert.isNotBlank(fraCas.getFailureTiming(), "发生时机不能为空");
         Assert.isNotBlank(fraCas.getFailureDeal(), "故障处理不能为空");
        // Assert.isNotBlank(fraCas.getFailureReason(), "根本原因不能为空");
        // Assert.isNotBlank(fraCas.getCorrectiveAction(), "纠正措施不能为空");
         Assert.isNotBlank(fraCas.getFailureStatus(), "状态不能为空");
         Assert.isNotBlank(fraCas.getCurrentHandler(), "当前处理人不能为空");
         Assert.isNotBlank(fraCas.getSupCompanySapCode(), "供应商sap编码不能为空");
         Assert.isNotBlank(fraCas.getSupCompanyName(), "供应商名称");

        this.fraCasService.addFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), fraCas);

        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑FRACAS 表单数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody FraCas fraCas) {
        Assert.isNotBlank(fraCas.getId(), "id 为空，保存失败");
        this.fraCasService.modifyObj(fraCas);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除FRACAS 表单数据")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.fraCasService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量删除FRACAS 表单数据")
    @RequestMapping("service/deleteByIdArray")
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要删除的单据!");
        }
        for (String id : list) {
            FraCas entity = this.fraCasService.queryObjById(id);
            if (entity != null) {
                if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue()) || entity.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue())) {
                    this.fraCasService.deleteObjById(id);
                } else {
                    throw new CommonException("只有未发送状态的单据才可以删除!");
                }

            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑FRACAS 表单数据")
    @RequestMapping("service/setBillSuppler")
    @ResponseBody
    public ResponseResult<String> setBillSuppler(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要保存的数据");
        }
        for (FraCas item : list) {
            if (!item.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue())) {
                throw new CommonException("只有导入状态才可以设置供应商");
            }
            if (StringUtils.isEmpty(item.getSupCompanySapCode())) {
                throw new CommonException("请选择供应商");
            }
            this.fraCasService.modifyObj(item);
        }

        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "获取FRACAS 表单数据")
    @RequestMapping("service/viewById")
    @ResponseBody
    public ResponseResult<FraCas> viewById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "获取数据失败,id不能为空");
        FraCas fracas = this.fraCasService.queryObjById(id);
        return ResponseResult.success(fracas);
    }

    @ApiOperation(httpMethod = "POST", value = "查询FRACAS 表单数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 FraCas", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView(new PageView<FraCas>(pageNo, pageSize));

        FraCasExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<FraCas> pageData = this.fraCasService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "分解到采购业务")
    @RequestMapping("service/pushedToBuyer")
    @ResponseBody
    public ResponseResult<String> pushedToBuyer(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("请选择要操作的单据");
        }
        this.fraCasService.pushedToBuyer(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询FRACAS 表单数据,采购员")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 FraCas", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findBuyerDataByPage")
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findBuyerDataByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView(new PageView<FraCas>(pageNo, pageSize));

        FraCasExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
        //if (!SpringSecurityUtils.getLoginUserId().equals("1")) {
        //    criteria.andBuyerIdEqualTo(SpringSecurityUtils.getLoginUserId());
        //}
        List<String> companyCodeArray=new ArrayList<>();
        List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }

        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<FraCas> pageData = this.fraCasService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "发布给供应商")
    @RequestMapping("service/pushedToSuppler")
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要操作的单据");
        }
        for (FraCas item : list) {
            if (StringUtils.isEmpty(item.getRectificationType())) {
                throw new CommonException("单据：" + item.getFaultNumber() + "处理方式为空，无法发布!");
            }
            FraCas entity = this.fraCasService.queryObjById(item.getId());
            if (entity != null) {
                if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue())) {

                    if (Constant.YES_INT.equals(item.getSendStatus())) {
                        throw new CommonException("单据：" + item.getFaultNumber() + "已经发送过，无需再次发送!");
                    }
                } else {
                    throw new CommonException("只有新增状态单据才可以发送!");
                }

            }
        }
        this.fraCasService.pushedToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量作废FRACAS 表单数据")
    @RequestMapping("service/invalidByIdArray")
    @ResponseBody
    public ResponseResult<String> invalidByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要作废的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            FraCas entity = this.fraCasService.queryObjById(id);
            if (entity != null) {
                if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue())
                        ||entity.getStatus().equals(FraCasStatusEnum.STATUS_INVALID.getValue())
                        ||entity.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue())
                        ||entity.getStatus().equals(FraCasStatusEnum.STATUS_APPROVE.getValue())) {
                    //this.fraCasService.deleteObjById(id);
                    throw new CommonException("所选记录包含未发送或采购确认或作废记录，不能作废!!");
                } else {
                    entity.setStatus(FraCasStatusEnum.STATUS_INVALID.getValue());
                    entity.setIsEnable(Constant.NO_INT);
                    entity.setUpdateUserId(user.getId());
                    entity.setUpdateUserName(user.getNickName());
                    entity.setUpdateTime(new Date());
                    this.fraCasService.modifyObj(entity);
                }

            }
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询FRACAS 表单数据,供应商")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 FraCas", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findSupplerDataByPage")
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findSupplerDataByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView(new PageView<FraCas>(pageNo, pageSize));

        FraCasExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_NEW.getValue());
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<FraCas> pageData = this.fraCasService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商回复")
    @RequestMapping("service/supplerResponse")
    @ResponseBody
    public ResponseResult<String> supplerResponse(@RequestBody List<FraCas> fraCasArray) {
        this.fraCasService.supplerResponse(SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商确认NCR单据")
    @RequestMapping("service/supplierAcceptBill")
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要确认的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (FraCas item : list) {
           /* if (StringUtils.isEmpty(item.getSupplierReply())) {
                throw new CommonException("单据：" + item.getFaultNumber() + "回复内容为空，无法提交确认!");
            }*/
        	  if (StringUtils.isEmpty(item.getCauseAnalysis())) {
                  throw new CommonException("单据：" + item.getFaultNumber() + "原因分析为空，无法提交确认!");

  			}
              if (StringUtils.isEmpty(item.getCorrectiveAnalysis())) {
                  throw new CommonException("单据：" + item.getFaultNumber() + "纠正措施为空，无法提交确认!");

  			}
              Assert.isNotNull(item.getCompletionDate(), "单据：" + item.getFaultNumber() + "完成日期为空，无法提交确认!");
           /* FraCas entity = this.fraCasService.queryObjById(item.getId());
            if (entity != null) {
            	if (item.getRectificationType()=="整改单"||item.getRectificationType()=="8D报告") {
            		 if (StringUtils.isEmpty(entity.getAttachment())) {
                         throw new CommonException("单据：" + item.getFaultNumber() + "未上传附件，无法提交确认!");
                     }
				}
               
            }*/
            item.setSupplierResponseTime(new Date());
            item.setStatus(FraCasStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());

        }
        this.fraCasService.supplerResponse(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "上传附件")
    @RequestMapping("service/attachment")
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody FraCas fraCas) {

        if (StringUtils.isBlank(fraCas.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.fraCasService.addAttachment(SpringSecurityUtils.getLoginUser(), fraCas);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "采购同意供应商回复")
    @RequestMapping("service/acceptToSuppler")
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("请选择要操作的单据");
        }
        this.fraCasService.acceptToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "采购拒绝供应商回复")
    @RequestMapping("service/refuseToSuppler")
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("请选择要操作的单据");
        }
        this.fraCasService.refuseToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }


    @ApiOperation(value = "导入FRACAS单据 Excel", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importFarcasFromExcel"})
    public ResponseResult<String> importFarcasFromExcel(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        if (MapUtils.isEmpty(fileMap)) {
            logger.info("导入FRCASE单据----上传文件为空");
            throw new CommonException("上传文件为空", "file_isNull");
        }

        if (fileMap.size() > 1) {
            logger.info("导入FRCASE单据----无法同时处理多个上传文件");
            throw new CommonException("无法同时处理多个上传文件");
        }

        String key = fileMap.keySet().iterator().next();

        MultipartFile uploadFile = fileMap.get(key);
        logger.info("导入FRCASE单据titleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        List<FraCas> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(uploadFile.getInputStream(), 0, 1, 0, titleAndModelKeys, FraCas.class);
        } catch (Exception e) {
            logger.info("导入异常" + e.getMessage());
            throw new CommonException("导入异常：" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.fraCasService.importFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
        }

        return ResponseResult.success();
    }

    @ApiOperation(value = "导入FRCASE单据 Txt", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importFarcasFromTxt"})
    public ResponseResult<String> importFarcasFromTxt(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);

        String[] keys = {"faultNumber", "discoveredDate", "project", "productNo", "productName", "parts", "partsNo", "failureMode"
                , "failureDescription", "failureTiming", "failureDeal", "failureReason", "correctiveAction", "failureStatus", "currentHandler","supCompanySapCode","getSupCompanyName"};
        try {
            TxtImportResponse<FraCas> importTxt = TxtImportUtils.importTxt(file, "\t",
                    FraCas.class, keys);
            List<FraCas> list = importTxt.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                this.fraCasService.importFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }

        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }

        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("导入文件的格式不正确，目前只支持txt");
        }

        return file;
    }


    @ApiOperation(value = "FRCASE导入模板下载(Excel)", httpMethod = "GET")
    @RequestMapping(value = "service/downloadTemplateExcel")
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {

            // Excel头部以及响应信息
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("FRACAS导入模板.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            // 导出的列头
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            List<FraCas> list = new ArrayList<>();
            // 写入Excel表
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, list, "FRCASE", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            // 下載模板失敗
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障编号", "faultNumber", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发现日期", "discoveredDate", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品编码", "productNo", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品名称", "productName", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件名称", "parts", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件序列号", "partsNo", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障模式", "failureMode", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障现象(描述)", "failureDescription", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生时机", "failureTiming", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障处理", "failureDeal", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("根本原因", "failureReason", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("纠正措施", "correctiveAction", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("状态", "failureStatus", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "currentHandler", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商sap编码", "supCompanySapCode", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName", true));

        return titleAndModelKeys;
    }
    
    
    //导出excel，选中的单据
    @ApiOperation(value = "FRACAS单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "FRACAS单据id", defaultValue = "") @RequestParam(defaultValue = "") String idArray,
            HttpServletResponse response) {
        try {
            logger.info("FRACAS单据导出Excel 参数" + idArray);
            FraCasExample example = new FraCasExample();
            if (StringUtils.isNotBlank(idArray)) {
                //criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
                example.createCriteria().andIdIn(Arrays.asList(idArray.split(",")));
            }

            example.setOrderByClause(" UPDATE_TIME DESC");
             List<FraCas> fraCasList = this.fraCasService.queryAllObjByExample(example);
             for (FraCas fraCas : fraCasList) {
            //用备用字段接受修改状态后的数据
            	 switch(fraCas.getStatus())
            	 {
             	 	 case 1:  fraCas.setAttribute1("新增");
             	 								break;
	            	 case 2:  fraCas.setAttribute1("发布给供应商");
	            	 							break; 
	            	 case 3:  fraCas.setAttribute1("供应商回复");
	            	 							break; 
	            	 case 4:  fraCas.setAttribute1("采购确认");
	            	 							break;
	            	 case 5:  fraCas.setAttribute1("采购拒绝");
	            	 							break;
	            	default :  fraCas.setAttribute1("作废");
	            	 							break;
            	 }
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "FRACAS单据" + System.currentTimeMillis() + ".xls";

            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("FRACAS单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "faultNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品号", "productNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品名称", "productName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生日期", "discoveredDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件", "parts"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件序号", "partsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障模式", "failureMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障现象", "failureDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生时机", "failureTiming"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障处理", "failureDeal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("纠正措施", "correctiveAction"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("状态", "failureStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "currentHandler"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            

            logger.info("FRACAS单据导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
            		fraCasList, "FRACAS单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            fraCasList=null;
            logger.info("FRACAS单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    
    
    
    //采购导出所有的
    @ApiOperation(value = "采购FRACAS单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/purdownloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
   try{	
	   	FraCasExample example = new FraCasExample();
	   	example.setOrderByClause(" UPDATE_TIME DESC");
	      FraCasExample.Criteria criteria = example.createCriteria();
	      if (StringUtils.isNotEmpty(queryParams)) {
              QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                      QueryParamWapper.class);
              CriteriaUtils.addCriterion(criteria, queryParamWapper);
          }
	      criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
	    
	        List<String> companyCodeArray=new ArrayList<>();
	        List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
	                SpringSecurityUtils.getLoginUserId(), null);
	        if (CollectionUtils.isNotEmpty(companyList)) {
	            for (Company company : companyList) {
	                companyCodeArray.add(company.getCompanySapCode());
	            }
	            criteria.andSupCompanySapCodeIn(companyCodeArray);
	        }
	      
          List<FraCas> fraCasList = this.fraCasService.queryAllObjByExample(example);
          for (FraCas fraCas : fraCasList) {
              //用备用字段接受修改状态后的数据
              	 switch(fraCas.getStatus())
              	 {
  	            	
  	            	 case 1:  fraCas.setAttribute1("新增");
  	            	 break;
  	            	 case 2:  fraCas.setAttribute1("发布给供应商");
  	            	 break; 
  	            	 case 3:  fraCas.setAttribute1("供应商回复");
  	            	 break; 
  	            	 case 4:  fraCas.setAttribute1("采购确认");
  	            	 break;
  	            	 case 5:  fraCas.setAttribute1("采购拒绝");
  	            	 break;
  	            	default :  fraCas.setAttribute1("作废");
  	            	 break;
              	 }
              }
        logger.info("FRACAS单据导出Excel 数据条数" + fraCasList.size());
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        String filename = "FRACAS单据库存" + System.currentTimeMillis() + ".xls";
        //header.append("filename=\"" + URLEncoder.encode("FRACAS单据.xls", "UTF-8") + "\";");
        header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
        logger.info("FRACAS单据Excel 文件名称" + filename);
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        OutputStream outputStream = response.getOutputStream();

        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "faultNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品号", "productNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品名称", "productName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生日期", "discoveredDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件", "parts"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件序号", "partsNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障模式", "failureMode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障现象", "failureDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生时机", "failureTiming"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障处理", "failureDeal"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("纠正措施", "correctiveAction"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("状态", "failureStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "currentHandler"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));
        logger.info("FRACAS单据Excel 开始导出文件");
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
        		fraCasList, "FRACAS单据", null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        fraCasList=null;
        logger.info("FRACAS单据导出Excel 文件导出成功");
    }catch(Exception e) {
        e.printStackTrace();
        response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
    }
    	return null;
    }
    
    
    //供应商导出所有的
    @ApiOperation(value = "供应商FRACAS单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/supdownloadReportExcel")
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
   try{	
	   FraCasExample example = new FraCasExample();
      FraCasExample.Criteria criteria = example.createCriteria();
      if (StringUtils.isNotEmpty(queryParams)) {
          QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                  QueryParamWapper.class);
          CriteriaUtils.addCriterion(criteria, queryParamWapper);
      }
      criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
      criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_NEW.getValue());
      criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode()); 
      
        example.setOrderByClause(" UPDATE_TIME DESC");
         List<FraCas> fraCasList = this.fraCasService.queryAllObjByExample(example);
         for (FraCas fraCas : fraCasList) {
             //用备用字段接受修改状态后的数据
             	 switch(fraCas.getStatus())
             	 {
             	 case 1:  fraCas.setAttribute1("新增");
	            	 break;
	            	 case 2:  fraCas.setAttribute1("发布给供应商");
	            	 break; 
	            	 case 3:  fraCas.setAttribute1("供应商回复");
	            	 break; 
	            	 case 4:  fraCas.setAttribute1("采购确认");
	            	 break;
	            	 case 5:  fraCas.setAttribute1("采购拒绝");
	            	 break;
	            	default :  fraCas.setAttribute1("作废");
	            	 break;
             	 }
             }
        logger.info("FRACAS单据导出Excel 数据条数" + fraCasList.size());
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        String filename = "FRACAS单据库存" + System.currentTimeMillis() + ".xls";
        //header.append("filename=\"" + URLEncoder.encode("FRACAS单据.xls", "UTF-8") + "\";");
        header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
        logger.info("FRACAS单据Excel 文件名称" + filename);
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        OutputStream outputStream = response.getOutputStream();

        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "faultNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品号", "productNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("商品名称", "productName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生日期", "discoveredDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件", "parts"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("零部件序号", "partsNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障模式", "failureMode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障现象", "failureDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生时机", "failureTiming"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("故障处理", "failureDeal"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("纠正措施", "correctiveAction"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("状态", "failureStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "currentHandler"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

        logger.info("FRACAS单据Excel 开始导出文件");
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
        		fraCasList, "FRACAS单据", null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        fraCasList=null;
        logger.info("FRACAS单据导出Excel 文件导出成功");
    }catch(Exception e) {
        e.printStackTrace();
        response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
    }
    	return null;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
}