package com.els.base.quality.harms.command;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.quality.harms.common.AbstractHarmsCommand;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;

public class CreateHarmsCmd extends AbstractHarmsCommand<String>{

    private QualityHarmMaterialsVO vo;
    
    public CreateHarmsCmd(QualityHarmMaterialsVO vo) {
        // TODO Auto-generated constructor stub
        this.vo=vo;
    }

    @Override
    public String execute(HarmsInvorker harmsInvorker) {
        // TODO Auto-generated method stub
        //检查数据
        this.verification(vo);
        //处理单据最终信息
        this.dealVoData(vo,harmsInvorker);
        //添加头数据
        harmsInvorker.getQualityHarmMaterialsService().addObj(vo);
        //添加行数据
        for (QualityHarmMaterialsItem item : vo.getItemList()) {          
            harmsInvorker.getQualityHarmMaterialsItemService().addObj(item);
        }
        return null;
    }


    private void dealVoData(QualityHarmMaterialsVO vo, HarmsInvorker harmsInvorker) {
        // TODO Auto-generated method stub
        String id = UUIDGenerator.generateUUID();
        vo.setId(id);
        vo.setProjectId(ProjectUtils.getProjectId());
        vo.setPurUserId(SpringSecurityUtils.getLoginUserId());
        
        Company purCompany=this.getPurCompany();
        vo.setPurCompanyId(purCompany.getId());
        vo.setPurCompanySrmCode(purCompany.getCompanyCode());
        vo.setPurCompanyFullName(purCompany.getCompanyFullName());
        vo.setPurCompanyName(purCompany.getCompanyName());
        //生成单据号
        String billNo = harmsInvorker.getGenerateCodeService().getNextCode("Q_HARM_BILL_NO");
        vo.setHarmBillNo(billNo);
        vo.setSendStatus(Constant.NO_INT);
        vo.setReportCheckStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatusDesc());
        vo.setIsEnable(Constant.YES_INT);
        vo.setBillStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        vo.setCreateTime(new Date());
        for (QualityHarmMaterialsItem item : vo.getItemList()) {
            item.setProjectId(vo.getProjectId());
            item.setHarmMaterialId(id);
            item.setHarmBillNo(billNo);
            item.setCreateTime(new Date());
        }
    }

    private void verification(QualityHarmMaterialsVO vo) {
        // TODO Auto-generated method stub
        Assert.isNotNull(vo, "提交的数据不能为空");
        
        Assert.isNotBlank(vo.getMaterialCode(), "物料编码不能为空");
        Assert.isNotBlank(vo.getMaterialDesc(), "物料描述不能为空");
        Assert.isNotBlank(vo.getSupCompanyId(), "供应商id不能为空!");
        Assert.isNotBlank(vo.getSupCompanySapCode(), "供应商SAP编码不能为空!");
        Assert.isNotBlank(vo.getSupCompanySrmCode(), "供应商SRM编码不能为空!");
        Assert.isNotBlank(vo.getSupCompanyFullName(), "供应商全称不能为空!");
        Assert.isNotBlank(vo.getNecessaryFilling(), "选择必填项不能为空");
        List<QualityHarmMaterialsItem> list = vo.getItemList();
        if(CollectionUtils.isEmpty(list)){
            throw new CommonException("单据的行数据不能为空!");
        }
    }

}
