package com.els.base.quality.harms.command;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.quality.harms.common.AbstractHarmsCommand;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmFormsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;

public class ModifyHarmsCmd extends AbstractHarmsCommand<String>{
    private QualityHarmMaterialsVO vo;
    
    public ModifyHarmsCmd(QualityHarmMaterialsVO vo) {
        this.vo=vo;
    }
    
    @Override
    public String execute(HarmsInvorker harmsInvorker) {
        //校验
        this.verification(vo);
        //已发送状态,采购方修改另存报告编码字段
        QualityHarmMaterials materials = harmsInvorker.getQualityHarmMaterialsService().queryObjById(vo.getId());
        if(materials.getSendStatus().equals(Constant.YES_INT)){
            vo.setUpdateTime(new Date());
            QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
            example.createCriteria().andHarmMaterialIdEqualTo(vo.getId());
            List<QualityHarmMaterialsItem> list = harmsInvorker.getQualityHarmMaterialsItemService().queryAllObjByExample(example);
            if(CollectionUtils.isEmpty(list)){
                throw new CommonException("修改的行数据不能为空");
            }
            for (int i = 0; i < list.size(); i++) {
                QualityHarmMaterialsItem item = list.get(i);
                item.setOtherReportCode(vo.getItemList().get(i).getOtherReportCode());
                harmsInvorker.getQualityHarmMaterialsItemService().modifyObj(item);
                //审核通过时回写到报表
                if(vo.getBillStatus().equals(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus())){
                    QualityHarmFormsExample formsExample = new QualityHarmFormsExample();
                    formsExample.createCriteria().andHarmMaterialItemIdEqualTo(item.getId());
                    List<QualityHarmForms> harmForms = harmsInvorker.getQualityHarmFormsService().queryAllObjByExample(formsExample);
                    for (QualityHarmForms qualityHarmForms : harmForms) {
                        QualityHarmForms forms = new QualityHarmForms();
                        forms.setId(qualityHarmForms.getId());
                        forms.setOtherReportCode(item.getOtherReportCode());
                        harmsInvorker.getQualityHarmFormsService().modifyObj(forms);
                    }
                }
            }
        }
        vo.setUpdateTime(new Date());        
        //更新头信息
        harmsInvorker.getQualityHarmMaterialsService().modifyObj(vo);
        //删除行数据
        harmsInvorker.getQualityHarmMaterialsItemService().deleteByDetailId(vo.getId());
        //更新行信息
        for (QualityHarmMaterialsItem item : vo.getItemList()) {
            item.setCreateTime(new Date());
            item.setHarmMaterialId(vo.getId());
            item.setHarmBillNo(vo.getHarmBillNo());
            item.setProjectId(vo.getProjectId());
            harmsInvorker.getQualityHarmMaterialsItemService().addObj(item);
        }
        return null;
    }

    private void verification(QualityHarmMaterialsVO vo) {
        Assert.isNotNull(vo, "提交的数据为空,无法修改单据!");
        Assert.isNotBlank(vo.getMaterialCode(), "物料编码不能为空");
        Assert.isNotBlank(vo.getMaterialDesc(), "物料描述不能为空");
        Assert.isNotBlank(vo.getSupCompanyId(), "供应商id不能为空!");
        Assert.isNotBlank(vo.getSupCompanySapCode(), "供应商SAP编码不能为空!");
        Assert.isNotBlank(vo.getSupCompanySrmCode(), "供应商SRM编码不能为空!");
        Assert.isNotBlank(vo.getSupCompanyFullName(), "供应商全称不能为空!");
        Assert.isNotBlank(vo.getNecessaryFilling(), "选择必填项不能为空");
        List<QualityHarmMaterialsItem> list = vo.getItemList();
        if(CollectionUtils.isEmpty(list)){
            throw new CommonException("单据的行数据不能为空!");
        }
    }
}
