package com.els.base.quality.harms.common;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;

@Component
public class HarmsInvorker {

    private static Logger logger = LoggerFactory.getLogger(HarmsInvorker.class);
   
    @Resource
    private QualityHarmMaterialsService qualityHarmMaterialsService;
    @Resource
    private QualityHarmMaterialsItemService qualityHarmMaterialsItemService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private QualityHarmFormsService qualityHarmFormsService;
    @Transactional
    public <Result> Result invoke(AbstractHarmsCommand<Result> command) {
        logger.debug("执行命令[{}]", command.getClass().getName());

        // 此处可添加执行前的统一操作
        // 例如身份认证
        command.setharmsInvorker(this);

        Result result = command.execute(this);

        // TODO 此处可添加执行后的操作
        // 例如消息发送

        return result;
    }
    public QualityHarmMaterialsService getQualityHarmMaterialsService() {
        return qualityHarmMaterialsService;
    }
    
    public QualityHarmMaterialsItemService getQualityHarmMaterialsItemService() {
        return qualityHarmMaterialsItemService;
    }
   
    public GenerateCodeService getGenerateCodeService() {
        return generateCodeService;
    }
    public QualityHarmFormsService getQualityHarmFormsService() {
        return qualityHarmFormsService;
    }
    

}
