package com.els.base.quality.harms.entity;

import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="有害物质报告报表")
public class QualityHarmForms implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("表的项目ID")
    private String projectId;

    @ApiModelProperty("有害物质报告ID")
    private String harmMaterialId;

    @ApiModelProperty("有害物质报告ID")
    private String harmMaterialItemId;

    @ApiModelProperty("采购商ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购商简称")
    private String purCompanyName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("检测报告名称")
    private String checkReportName;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("检测报告原件")
    private String attachment;

    @ApiModelProperty("报告编码")
    private String reportCode;

    @ApiModelProperty("另存报告编码")
    private String otherReportCode;

    @ApiModelProperty("检测报告日期")
    private Date checkTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getHarmMaterialId() {
        return harmMaterialId;
    }

    public void setHarmMaterialId(String harmMaterialId) {
        this.harmMaterialId = harmMaterialId == null ? null : harmMaterialId.trim();
    }

    public String getHarmMaterialItemId() {
        return harmMaterialItemId;
    }

    public void setHarmMaterialItemId(String harmMaterialItemId) {
        this.harmMaterialItemId = harmMaterialItemId == null ? null : harmMaterialItemId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getCheckReportName() {
        return checkReportName;
    }

    public void setCheckReportName(String checkReportName) {
        this.checkReportName = checkReportName == null ? null : checkReportName.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getReportCode() {
        return reportCode;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode == null ? null : reportCode.trim();
    }

    public String getOtherReportCode() {
        return otherReportCode;
    }

    public void setOtherReportCode(String otherReportCode) {
        this.otherReportCode = otherReportCode == null ? null : otherReportCode.trim();
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}