package com.els.base.quality.harms.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.els.base.quality.utils.NecessaryFillingJsonDeserializer;
import com.els.base.quality.utils.NecessaryFillingJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="有害物质报告")
public class QualityHarmMaterials implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("表的项目ID")
    private String projectId;

    @ApiModelProperty("采购商ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购商简称")
    private String purCompanyName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("单据号")
    private String harmBillNo;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("供应商分零件号")
    private String supComponentNo;

    @ApiModelProperty("供应商分零件名称")
    private String supComponentName;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("材料名称/牌号（颜色）")
    private String materialInfo;

    @ApiModelProperty("单重（克）")
    private BigDecimal substance;

    @ApiModelProperty("表面处理")
    private String faceHandle;

    @ApiModelProperty("厂商/品牌（生产地点）")
    private String brandInfo;

    @ApiModelProperty("报告检测状态")
    private String reportCheckStatus;

    @ApiModelProperty("层级")
    private String layerLevel;

    @ApiModelProperty("消息推送(采购方)")
    private String purUserId;

    @ApiModelProperty("消息推送(供应商方)")
    private String supUserId;

    @ApiModelProperty("采购商备注")
    private String purRemark;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("选择必填项")
    @JsonDeserialize(using=NecessaryFillingJsonDeserializer.class)
    @JsonSerialize(using=NecessaryFillingJsonSerializer.class)
    private String necessaryFilling;

    @ApiModelProperty("发送状态（0=未发送，1=已发送）")
    private Integer sendStatus;

    @ApiModelProperty("发送供应商时间")
    private Date purSendTime;

    @ApiModelProperty("采购商资料提交时间")
    private Date purCommitTime;

    @ApiModelProperty("供应商资料提交时间")
    private Date supCommitTime;

    @ApiModelProperty("审核人")
    private String approveUsername;

    @ApiModelProperty("审核时间")
    private Date approveTime;

    @ApiModelProperty("审核意见")
    private String approveSuggestion;

    @ApiModelProperty("供应商回签时间")
    private Date supSignTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("单据状态(未回签=0,已回签=1,已审核=2,已驳回=3,已作废=4)")
    private Integer billStatus;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getHarmBillNo() {
        return harmBillNo;
    }

    public void setHarmBillNo(String harmBillNo) {
        this.harmBillNo = harmBillNo == null ? null : harmBillNo.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getSupComponentNo() {
        return supComponentNo;
    }

    public void setSupComponentNo(String supComponentNo) {
        this.supComponentNo = supComponentNo == null ? null : supComponentNo.trim();
    }

    public String getSupComponentName() {
        return supComponentName;
    }

    public void setSupComponentName(String supComponentName) {
        this.supComponentName = supComponentName == null ? null : supComponentName.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo == null ? null : materialInfo.trim();
    }

    public BigDecimal getSubstance() {
        return substance;
    }

    public void setSubstance(BigDecimal substance) {
        this.substance = substance;
    }

    public String getFaceHandle() {
        return faceHandle;
    }

    public void setFaceHandle(String faceHandle) {
        this.faceHandle = faceHandle == null ? null : faceHandle.trim();
    }

    public String getBrandInfo() {
        return brandInfo;
    }

    public void setBrandInfo(String brandInfo) {
        this.brandInfo = brandInfo == null ? null : brandInfo.trim();
    }

    public String getReportCheckStatus() {
        return reportCheckStatus;
    }

    public void setReportCheckStatus(String reportCheckStatus) {
        this.reportCheckStatus = reportCheckStatus == null ? null : reportCheckStatus.trim();
    }

    public String getLayerLevel() {
        return layerLevel;
    }

    public void setLayerLevel(String layerLevel) {
        this.layerLevel = layerLevel == null ? null : layerLevel.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public String getNecessaryFilling() {
        return necessaryFilling;
    }

    public void setNecessaryFilling(String necessaryFilling) {
        this.necessaryFilling = necessaryFilling == null ? null : necessaryFilling.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Date getPurSendTime() {
        return purSendTime;
    }

    public void setPurSendTime(Date purSendTime) {
        this.purSendTime = purSendTime;
    }

    public Date getPurCommitTime() {
        return purCommitTime;
    }

    public void setPurCommitTime(Date purCommitTime) {
        this.purCommitTime = purCommitTime;
    }

    public Date getSupCommitTime() {
        return supCommitTime;
    }

    public void setSupCommitTime(Date supCommitTime) {
        this.supCommitTime = supCommitTime;
    }

    public String getApproveUsername() {
        return approveUsername;
    }

    public void setApproveUsername(String approveUsername) {
        this.approveUsername = approveUsername == null ? null : approveUsername.trim();
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getApproveSuggestion() {
        return approveSuggestion;
    }

    public void setApproveSuggestion(String approveSuggestion) {
        this.approveSuggestion = approveSuggestion == null ? null : approveSuggestion.trim();
    }

    public Date getSupSignTime() {
        return supSignTime;
    }

    public void setSupSignTime(Date supSignTime) {
        this.supSignTime = supSignTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}