package com.els.base.quality.harms.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="有害物质报告行项")
public class QualityHarmMaterialsItem implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("表的项目ID")
    private String projectId;

    @ApiModelProperty("有害物质报告ID")
    private String harmMaterialId;

    @ApiModelProperty("单据号")
    private String harmBillNo;

    @ApiModelProperty("层级")
    private String layerLevel;

    @ApiModelProperty("供应商分零件号")
    private String supComponentNo;

    @ApiModelProperty("供应商分零件名称")
    private String supComponentName;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("材料名称/牌号（颜色）")
    private String materialInfo;

    @ApiModelProperty("单重（克）")
    private BigDecimal substance;

    @ApiModelProperty("表面处理")
    private String faceHandle;

    @ApiModelProperty("厂商/品牌（生产地点）")
    private String brandInfo;

    @ApiModelProperty("检测报告名称")
    private String checkReportName;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("检测报告原件")
    private String attachment;

    @ApiModelProperty("报告编码")
    private String reportCode;

    @ApiModelProperty("另存报告编码")
    private String otherReportCode;

    @ApiModelProperty("检测报告日期")
    private Date checkTime;

    @ApiModelProperty("行项采购商备注")
    private String itemPurRemark;

    @ApiModelProperty("行项供应商备注")
    private String itemSupRemark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getHarmMaterialId() {
        return harmMaterialId;
    }

    public void setHarmMaterialId(String harmMaterialId) {
        this.harmMaterialId = harmMaterialId == null ? null : harmMaterialId.trim();
    }

    public String getHarmBillNo() {
        return harmBillNo;
    }

    public void setHarmBillNo(String harmBillNo) {
        this.harmBillNo = harmBillNo == null ? null : harmBillNo.trim();
    }

    public String getLayerLevel() {
        return layerLevel;
    }

    public void setLayerLevel(String layerLevel) {
        this.layerLevel = layerLevel == null ? null : layerLevel.trim();
    }

    public String getSupComponentNo() {
        return supComponentNo;
    }

    public void setSupComponentNo(String supComponentNo) {
        this.supComponentNo = supComponentNo == null ? null : supComponentNo.trim();
    }

    public String getSupComponentName() {
        return supComponentName;
    }

    public void setSupComponentName(String supComponentName) {
        this.supComponentName = supComponentName == null ? null : supComponentName.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo == null ? null : materialInfo.trim();
    }

    public BigDecimal getSubstance() {
        return substance;
    }

    public void setSubstance(BigDecimal substance) {
        this.substance = substance;
    }

    public String getFaceHandle() {
        return faceHandle;
    }

    public void setFaceHandle(String faceHandle) {
        this.faceHandle = faceHandle == null ? null : faceHandle.trim();
    }

    public String getBrandInfo() {
        return brandInfo;
    }

    public void setBrandInfo(String brandInfo) {
        this.brandInfo = brandInfo == null ? null : brandInfo.trim();
    }

    public String getCheckReportName() {
        return checkReportName;
    }

    public void setCheckReportName(String checkReportName) {
        this.checkReportName = checkReportName == null ? null : checkReportName.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getReportCode() {
        return reportCode;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode == null ? null : reportCode.trim();
    }

    public String getOtherReportCode() {
        return otherReportCode;
    }

    public void setOtherReportCode(String otherReportCode) {
        this.otherReportCode = otherReportCode == null ? null : otherReportCode.trim();
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getItemPurRemark() {
        return itemPurRemark;
    }

    public void setItemPurRemark(String itemPurRemark) {
        this.itemPurRemark = itemPurRemark == null ? null : itemPurRemark.trim();
    }

    public String getItemSupRemark() {
        return itemSupRemark;
    }

    public void setItemSupRemark(String itemSupRemark) {
        this.itemSupRemark = itemSupRemark == null ? null : itemSupRemark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}