package com.els.base.quality.harms.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.quality.harms.dao.QualityHarmFormsMapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmFormsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultQualityHarmFormsService")
public class QualityHarmFormsServiceImpl implements QualityHarmFormsService {
    @Resource
    protected QualityHarmFormsMapper qualityHarmFormsMapper;
    
    @Resource
    protected QualityHarmMaterialsService qualityHarmMaterialsService;
    
    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Override
    public void addObj(QualityHarmForms t) {
        this.qualityHarmFormsMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.qualityHarmFormsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Override
    public void modifyObj(QualityHarmForms t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.qualityHarmFormsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="qualityHarmForms", keyGenerator="redisKeyGenerator")
    @Override
    public QualityHarmForms queryObjById(String id) {
        return this.qualityHarmFormsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualityHarmForms", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualityHarmForms> queryAllObjByExample(QualityHarmFormsExample example) {
        return this.qualityHarmFormsMapper.selectByExample(example);
    }

    @Cacheable(value="qualityHarmForms", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualityHarmForms> queryObjByPage(QualityHarmFormsExample example) {
        PageView<QualityHarmForms> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmFormsMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Transactional
    @Override
    public void modifyForms(QualityHarmForms qualityHarmForms) {
        // TODO Auto-generated method stub
        QualityHarmForms form = new QualityHarmForms();
        form.setId(qualityHarmForms.getId());
        form.setUpdateTime(new Date());
        form.setOtherReportCode(qualityHarmForms.getOtherReportCode());
        this.qualityHarmFormsMapper.updateByPrimaryKeySelective(form);
            QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
            example.createCriteria().andIdEqualTo(qualityHarmForms.getHarmMaterialItemId());
            List<QualityHarmMaterialsItem> materialsItems = this.qualityHarmMaterialsItemService.queryAllObjByExample(example);
            if(CollectionUtils.isEmpty(materialsItems)){
                throw new CommonException("行数据为空");
            }
                QualityHarmMaterialsItem item = new QualityHarmMaterialsItem();
                item.setId(qualityHarmForms.getHarmMaterialItemId());
                item.setOtherReportCode(form.getOtherReportCode());
                this.qualityHarmMaterialsItemService.modifyObj(item);
                                               
        }

    @Transactional
    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Override
    public void addAll(List<QualityHarmForms> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.qualityHarmFormsMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Override
    public void deleteByExample(QualityHarmFormsExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.qualityHarmFormsMapper.deleteByExample(arg0);
        
    }
    
}