package com.els.base.quality.harms.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.harms.dao.QualityHarmMaterialsItemMapper;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultQualityHarmMaterialsItemService")
public class QualityHarmMaterialsItemServiceImpl implements QualityHarmMaterialsItemService {
    @Resource
    protected QualityHarmMaterialsItemMapper qualityHarmMaterialsItemMapper;

    @CacheEvict(value={"qualityHarmMaterialsItem"}, allEntries=true)
    @Override
    public void addObj(QualityHarmMaterialsItem t) {
        this.qualityHarmMaterialsItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmMaterialsItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.qualityHarmMaterialsItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmMaterialsItem"}, allEntries=true)
    @Override
    public void modifyObj(QualityHarmMaterialsItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.qualityHarmMaterialsItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="qualityHarmMaterialsItem", keyGenerator="redisKeyGenerator")
    @Override
    public QualityHarmMaterialsItem queryObjById(String id) {
        return this.qualityHarmMaterialsItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualityHarmMaterialsItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualityHarmMaterialsItem> queryAllObjByExample(QualityHarmMaterialsItemExample example) {
        return this.qualityHarmMaterialsItemMapper.selectByExample(example);
    }

    @Cacheable(value="qualityHarmMaterialsItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualityHarmMaterialsItem> queryObjByPage(QualityHarmMaterialsItemExample example) {
        PageView<QualityHarmMaterialsItem> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmMaterialsItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="qualityHarmMaterialsItem", keyGenerator="redisKeyGenerator")
    @Override
    public void deleteByDetailId(String id) {
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(id);
        this.qualityHarmMaterialsItemMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"qualityHarmMaterialsItem"}, allEntries=true)
    @Override
    public void addAll(List<QualityHarmMaterialsItem> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.qualityHarmMaterialsItemMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value={"qualityHarmMaterialsItem"}, allEntries=true)
    @Override
    public void deleteByExample(QualityHarmMaterialsItemExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.qualityHarmMaterialsItemMapper.deleteByExample(arg0);
        
    }
}