package com.els.base.quality.harms.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.harms.dao.QualityHarmMaterialsMapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.im.HarmMaterialImTemplet;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultQualityHarmMaterialsService")
public class QualityHarmMaterialsServiceImpl implements QualityHarmMaterialsService{
    private static final String IM_CODE = "QUALITY_HARM_MATERIAL";
    
    @Resource
    protected QualityHarmMaterialsMapper qualityHarmMaterialsMapper;

    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    
    @Resource
    private CompanyUserRefService companyUserRefService;
    
    @Resource
    private QualityHarmMaterialsItemService qualityHarmMaterialsItemService;
    
    @Resource
    private QualityHarmFormsService qualityHarmFormsService;
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void addObj(QualityHarmMaterials t) {
        this.qualityHarmMaterialsMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.qualityHarmMaterialsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void modifyObj(QualityHarmMaterials t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.qualityHarmMaterialsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="qualityHarmMaterials", keyGenerator="redisKeyGenerator")
    @Override
    public QualityHarmMaterials queryObjById(String id) {
        return this.qualityHarmMaterialsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="qualityHarmMaterials", keyGenerator="redisKeyGenerator")
    @Override
    public List<QualityHarmMaterials> queryAllObjByExample(QualityHarmMaterialsExample example) {
        return this.qualityHarmMaterialsMapper.selectByExample(example);
    }

    @Cacheable(value="qualityHarmMaterials", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QualityHarmMaterials> queryObjByPage(QualityHarmMaterialsExample example) {
        PageView<QualityHarmMaterials> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmMaterialsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void delete(List<QualityHarmMaterials> data, User user) {
        // TODO Auto-generated method stub
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空!");
        }
        List<String> ids = null;
        for(QualityHarmMaterials item : data){
            if(StringUtils.isEmpty(item.getId())){
                throw new CommonException("传递的参数列表中存在id为空!");
            }
            if(null == ids)
                ids = new ArrayList<>();
            //放到数组中
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria()
               .andIdIn(ids)
               .andSendStatusEqualTo(Constant.YES_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example) > 0){
            throw new CommonException("您选择的数据中包含已发送的单据,无法删除单据!");
        }
        
        example.clear();
        example.createCriteria()
           .andIdIn(ids);
        
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setIsEnable(Constant.NO_INT);
        qhm.setUpdateTime(new Date());
        qhm.setPurUserId(user.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void abolish(List<QualityHarmMaterials> data, User loginUser) {
        // TODO Auto-generated method stub
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空");
        }
        List<String> ids=null;
        for (QualityHarmMaterials item : data) {
            if(StringUtils.isEmpty(item.getId())){
                throw new CommonException("传递的参数列表存在id为空!");
            }
            if(null==ids)
                ids=new ArrayList<>();
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("您选择的数据中包含未发送的单据,无法作废单据!");
        }
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        
        example.clear();
        example.createCriteria()
           .andIdIn(ids)
           .andBillStatusIn(billStatusList);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("您选择的数据中包含已回签或已审核或已驳回或已作废的单据,无法作废单据");
        }
        example.clear();
        example.createCriteria()
            .andIdIn(ids);
        
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatusDesc());
        materials.setUpdateTime(new Date());
        materials.setPurUserId(loginUser.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        
      //消息推送
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if(null == groupMap){
            return ;
        }
        Set<String> keySet = groupMap.keySet();
        Iterator<String> it = keySet.iterator();
        while(it.hasNext()){
            String key=it.next();
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            //进行消息推送
            defaultThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                final HarmMaterialImTemplet templet = constructImInfo(1, "作废", hms);
                sendMessagesToSup(loginUser, templet, list.get(0));
            }
        });
        }
    }
    
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void sendToSup(List<QualityHarmMaterials> data, User loginUser) {
        // TODO Auto-generated method stub
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空!");
        }
        List<String> ids = null;
        for(QualityHarmMaterials item : data){
            if(StringUtils.isEmpty(item.getId())){
                throw new CommonException("传递的参数列表中存在id为空!");
            }
            if(null == ids)
                ids = new ArrayList<>();
            //放到数组中
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria()
               .andIdIn(ids)
               .andSendStatusEqualTo(Constant.YES_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example) > 0){
            throw new CommonException("您选择的数据中包含已发送的单据,无法重复发送单据!");
        }
        
        example.clear();
        example.createCriteria()
            .andIdIn(ids);
        
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setSendStatus(Constant.YES_INT);
        qhm.setUpdateTime(new Date());
        qhm.setPurSendTime(new Date());
        qhm.setPurCommitTime(new Date());
        qhm.setPurUserId(loginUser.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    
        //消息推送
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if(null == groupMap){
            return ;
        }
        Set<String> keySet = groupMap.keySet();
        Iterator<String> it = keySet.iterator();
        while(it.hasNext()){
            String key=it.next();
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            //进行消息推送
            defaultThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                final HarmMaterialImTemplet templet = constructImInfo(1, "发送", hms);
                sendMessagesToSup(loginUser, templet, list.get(0));
            }
        });
        }
    }
    
    /**
     * 根据SRM编码对单据进行不同的分组,因为最终要推消息给不同的供应商
     * @param list
     * @return
     */
    private Map<String, List<QualityHarmMaterials>> groupHamrMaterial(List<QualityHarmMaterials> list) {
        if(null == list){
            return null;
        }
        Map<String,List<QualityHarmMaterials>> groupMap=new HashMap<>();
        for (QualityHarmMaterials qhm : list) {
            String supCompanySrmCode = qhm.getSupCompanySrmCode();
            List<QualityHarmMaterials> materials=groupMap.get(supCompanySrmCode);
            if(null == materials){
                materials=new ArrayList<>();
            }
            materials.add(qhm);
            groupMap.put(supCompanySrmCode,materials);
        }
        return groupMap;
    }

    private HarmMaterialImTemplet constructImInfo(int role,String operate,List<QualityHarmMaterials> list){
        if(CollectionUtils.isEmpty(list)){
            throw new CommonException("列表为空,无法生成消息模板!");
        }
        HarmMaterialImTemplet tem = new HarmMaterialImTemplet();
        //设置角色信息:1是为采购商,其他为供应商
        if(role == 1){
            tem.setRole("采购商");
            //设置采购商的名称
            if(StringUtils.isNotEmpty(list.get(0).getPurCompanyName())){
                tem.setCompanyName(list.get(0).getPurCompanyName());
            }else{
                tem.setCompanyName("");
            }
        }else{
            tem.setRole("供应商");
            //设置供应商的名称
            if(StringUtils.isNotEmpty(list.get(0).getSupCompanyName())){
                tem.setCompanyName(list.get(0).getSupCompanyName());
            }else{
                tem.setCompanyName("");
            }
        }
        //设置操作
        Assert.isNotBlank(operate, "没有传入操作字段,无法生成消息模板!");
        tem.setOperate(operate);
        //设置其他信息
        tem.setOtherInfo("了新的有害物质报告单据,单据号包括：");
        //单据号
        List<String > noList = new ArrayList<>();
        for (QualityHarmMaterials item : list) {
            noList.add(item.getHarmBillNo());
        }
        String  billData= StringUtils.join(noList,",");
        tem.setBillList(billData);
        return tem;
    }
    
    /**
     * 发送消息给供应商
     */
    public void sendMessagesToSup(User loginUser,HarmMaterialImTemplet templet,QualityHarmMaterials data){
        com.els.base.core.entity.user.User supUser = companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message<HarmMaterialImTemplet>  message = Message.init(templet) // 传数据
                .setBusinessTypeCode(IM_CODE) // 业务编码
                .setCompanyCode(data.getPurCompanySrmCode()) // 发送消息企业SRM编码
                .setMsgLevel(MessageLevelEnum.HIGH) // 消息等级
                .setSenderId(loginUser.getId()) // 发送人userId
                .addReceiverId(supUser.getId()); // 接收人userId
        MessageSendUtils.sendMessage(message);
    }
    
    /**
     * 发送消息给采购商
     */
    public void sendMessagesToPur(QualityHarmMaterials data,HarmMaterialImTemplet templet){
        Message<HarmMaterialImTemplet>  message = Message.init(templet) // 传数据
                .setBusinessTypeCode(IM_CODE) // 业务编码
                .setCompanyCode(data.getSupCompanySrmCode())
                .setMsgLevel(MessageLevelEnum.HIGH)
                .setSenderId(data.getSupUserId())
                .addReceiverId(data.getPurUserId());
    MessageSendUtils.sendMessage(message);
    }
    
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void sendToPur(List<QualityHarmMaterials> data, User loginUser) {
        // TODO Auto-generated method stub
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空!");
        }
        List<String> ids = null;
        for(QualityHarmMaterials item : data){
            if(StringUtils.isEmpty(item.getId())){
                throw new CommonException("传递的参数列表中存在id为空!");
            }
            //如果明细中需要提交文件却没有提交的,不让回签
            QualityHarmMaterialsItemExample itemExample = new QualityHarmMaterialsItemExample();
            itemExample.createCriteria()
                    .andHarmMaterialIdEqualTo(item.getId());
            
            List<QualityHarmMaterialsItem> itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample(itemExample);
            if(CollectionUtils.isEmpty(itemList)){
                throw new CommonException("id为"+item.getId()+"的行数据为空,无法回签单据!");
            }
            for (QualityHarmMaterialsItem it : itemList) {
               
                    if(StringUtils.isEmpty(it.getAttachment())){
                        throw new CommonException("单据号为"+it.getHarmBillNo()+",其中行'"+it.getCheckReportName()+"'没有提交必填的附件,无法回签单据!");
                    }
                    if("[]".equals(it.getAttachment())){
                        throw new CommonException("单据号为"+it.getHarmBillNo()+",其中行'"+it.getCheckReportName()+"'没有提交必填的附件,无法回签单据!");
                    }
                
            }
            //如果供应商附件提交齐全,允许加入回签id列表中
            if(null == ids)
                ids = new ArrayList<>();
            //放到数组中
            ids.add(item.getId());
        }
        
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria()
               .andIdIn(ids)
               .andSendStatusEqualTo(Constant.NO_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example) > 0){
            throw new CommonException("您选择的数据中包含未发送的单据,无法回签单据!");
        }
        
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        
        example.clear();
        example.createCriteria()
           .andIdIn(ids)
           .andBillStatusIn(billStatusList);
        if(this.qualityHarmMaterialsMapper.countByExample(example) > 0){
            throw new CommonException("只有未回签的单据才可以回签单据,您选择的数据中包含已回签或已审核或已作废或已驳回的单据!");
        }
        
        //回签单据
        example.clear();
        example.createCriteria()
           .andIdIn(ids);
        
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
        qhm.setSupSignTime(new Date());
        qhm.setSupCommitTime(new Date());
        qhm.setUpdateTime(new Date());
        qhm.setSupUserId(loginUser.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    
        //消息推送
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if(null == groupMap){
            return ;
        }
        Set<String> keySet = groupMap.keySet();
        Iterator<String> it = keySet.iterator();
        while(it.hasNext()){
            String key=it.next();
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            //进行消息推送
            defaultThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                final HarmMaterialImTemplet templet = constructImInfo(2, "回签", hms);
                sendMessagesToPur(list.get(0), templet);
            }
        });
        }
    }
    
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void audit(List<QualityHarmMaterials> data, User loginUser) {
        // TODO Auto-generated method stub
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空");
        }
        List<String> ids=new ArrayList<>();
        for (QualityHarmMaterials materials : data) {
            Assert.isNotBlank(materials.getId(), "传递到的参数列表存在id为空");
            ids.add(materials.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids)
            .andSendStatusEqualTo(Constant.NO_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("您选择的数据中包含未发送的单据,无法审核单据!");
        }
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
    
        example.clear();
        example.createCriteria()
            .andIdIn(ids)
            .andBillStatusIn(billStatusList);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("只有已回签的单据才可以审核,您选择的数据中包含未回签或已审核或已作废或已驳回的单据!");
        }
        
        example.clear();
        example.createCriteria()
            .andIdIn(ids);
        
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatusDesc());
        qhm.setApproveTime(new Date());
        qhm.setApproveUsername(loginUser.getNickName());
        qhm.setUpdateTime(new Date());
        qhm.setPurUserId(loginUser.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        //写入报表
        this.addToHarmForms(data);
        //消息推送
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if(null == groupMap){
            return ;
        }
        Set<String> keySet = groupMap.keySet();
        Iterator<String> it = keySet.iterator();
        while(it.hasNext()){
            String key=it.next();
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            //进行消息推送
            defaultThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                final HarmMaterialImTemplet templet = constructImInfo(1, "审核", hms);
                sendMessagesToSup(loginUser, templet, list.get(0));
            }
        });
        }
        
    }

    private void addToHarmForms(List<QualityHarmMaterials> data) {
        // TODO Auto-generated method stub
        if(data==null){
            return;
        }
        for (QualityHarmMaterials qhm : data) {
            QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
            example.createCriteria().andHarmMaterialIdEqualTo(qhm.getId());
            List<QualityHarmMaterialsItem> items = this.qualityHarmMaterialsItemService.queryAllObjByExample(example);
            QualityHarmMaterialsExample example2=new QualityHarmMaterialsExample();
            example2.createCriteria().andIdEqualTo(qhm.getId());
            List<QualityHarmMaterials> harmMaterials = this.qualityHarmMaterialsMapper.selectByExample(example2);
            for (QualityHarmMaterials qh : harmMaterials) {
                for (QualityHarmMaterialsItem item : items) {
                    QualityHarmForms form = new QualityHarmForms();
                    form.setProjectId(item.getProjectId());
                    form.setHarmMaterialId(item.getHarmMaterialId());
                    form.setHarmMaterialItemId(item.getId());
                    form.setReportCode(item.getReportCode());
                    form.setRemark(item.getItemSupRemark());
                    form.setPurCompanyId(qh.getPurCompanyId());
                    form.setPurCompanySrmCode(qh.getPurCompanySrmCode());
                    form.setPurCompanyName(qh.getPurCompanyName());
                    form.setPurCompanyFullName(qh.getPurCompanyFullName());
                    form.setSupCompanyId(qh.getSupCompanyId());
                    form.setSupCompanyName(qh.getSupCompanyName());
                    form.setSupCompanyFullName(qh.getSupCompanyFullName());
                    form.setSupCompanySapCode(qh.getSupCompanySapCode());
                    form.setSupCompanySrmCode(qh.getSupCompanySrmCode());
                    form.setMaterialCode(qh.getMaterialCode());
                    form.setMaterialDesc(qh.getMaterialDesc());
                    form.setOtherReportCode(item.getOtherReportCode());
                    form.setCheckReportName(item.getCheckReportName());
                    form.setCheckTime(item.getCheckTime());
                    form.setAttachment(item.getAttachment());
                    form.setCreateTime(new Date());
                    this.qualityHarmFormsService.addObj(form);
                }
            }
        }
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void reject(List<QualityHarmMaterials> data, User loginUser) {
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("传递的数据为空!");
        }
        List<String> ids=new ArrayList<>();
        for (QualityHarmMaterials qhm : data) {
            Assert.isNotBlank(qhm.getId(), "传递的参数列表中存在id为空!");
            ids.add(qhm.getId());
        }
        //判断单据状态是否符合驳回条件
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria()
            .andIdIn(ids)
            .andSendStatusEqualTo(Constant.NO_INT);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("您选择的数据中包含未发送的单据,无法驳回!");
        }
        List<Integer> billStatusList=new ArrayList<>();
        billStatusList.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        
        example.clear();
        example.createCriteria().andIdIn(ids)
            .andBillStatusIn(billStatusList);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("只有已回签的单据才可以驳回,您选择的数据中包含未回签或已审核或已作废或已驳回的单据!");
        }
        example.clear();
        example.createCriteria()
            .andIdIn(ids);
        
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatusDesc());
        materials.setApproveTime(new Date());
        materials.setApproveUsername(loginUser.getNickName());
        materials.setUpdateTime(new Date());
        materials.setPurUserId(loginUser.getId());
        
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        
        //消息推送
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if(null == groupMap){
            return ;
        }
        Set<String> keySet = groupMap.keySet();
        Iterator<String> it = keySet.iterator();
        while(it.hasNext()){
            String key=it.next();
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            //进行消息推送
            defaultThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                final HarmMaterialImTemplet templet = constructImInfo(1, "驳回", hms);
                sendMessagesToSup(loginUser, templet, list.get(0));
            }
        });
        }
    }
    
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void updateBillAttachmentInfo(QualityHarmMaterialsVO vo) {
        Assert.isNotNull(vo,"传递数据为空");
        //判断单据状态,未回签才可修改
        Assert.isNotBlank(vo.getId(), "传递的单据id为空");
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria()
            .andIdEqualTo(vo.getId())
            .andBillStatusIn(billStatusList);
        if(this.qualityHarmMaterialsMapper.countByExample(example)>0){
            throw new CommonException("只有未回签的单据才可以修改附件信息!");
        }
        List<QualityHarmMaterialsItem> itemList = vo.getItemList();
        if(CollectionUtils.isEmpty(itemList)){
            throw new CommonException("行项数据为空!");
        }
        for (QualityHarmMaterialsItem item : itemList) {
            Assert.isNotBlank(item.getAttachment(), "'"+item.getCheckReportName()+"'必须提交的附件传递的文件信息不能为空!");
            Assert.isNotNull(item.getCheckTime(), "'"+item.getCheckReportName()+"'的检测时间不能为空!");
            if("[]".equals(item.getAttachment())){
                throw new CommonException("'"+item.getCheckReportName()+"'必须提交的附件传递的文件信息不能为空!");
            }
        }
        //先清除行项数据,再添加
        this.qualityHarmMaterialsItemService.deleteByDetailId(vo.getId());
        for (QualityHarmMaterialsItem item : itemList) {
            item.setCreateTime(new Date());
            item.setHarmMaterialId(vo.getId());
            item.setHarmBillNo(vo.getHarmBillNo());
            item.setProjectId(vo.getProjectId());
            //更新数据
            this.qualityHarmMaterialsItemService.addObj(item);
        }
    }

    @Transactional
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void addAll(List<QualityHarmMaterials> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.qualityHarmMaterialsMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Override
    public void deleteByExample(QualityHarmMaterialsExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.qualityHarmMaterialsMapper.deleteByExample(arg0);
        
    }
}