package com.els.base.quality.harms.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmFormsExample;
import com.els.base.quality.harms.service.QualityHarmFormsService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="有害物质报告报表")
@Controller
@RequestMapping("qualityHarmForms")
public class QualityHarmFormsController {
    @Resource
    protected QualityHarmFormsService qualityHarmFormsService;

//    @ApiOperation(httpMethod="POST", value="创建有害物质报告报表")
//    @RequestMapping("service/create")
//    @ResponseBody
//    public ResponseResult<String> create(@RequestBody QualityHarmForms qualityHarmForms) {
//        this.qualityHarmFormsService.addObj(qualityHarmForms);
//        return ResponseResult.success();
//    }

    @ApiOperation(httpMethod="POST", value="编辑有害物质报告报表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<QualityHarmForms> data) {
        if(CollectionUtils.isEmpty(data)){
            throw new CommonException("数据不能为空!");
        }
        for (QualityHarmForms qualityHarmForms : data) {
            Assert.isNotBlank(qualityHarmForms.getId(), "id 为空，保存失败");
            this.qualityHarmFormsService.modifyForms(qualityHarmForms);
        }
        return ResponseResult.success();
    }

//    @ApiOperation(httpMethod="POST", value="删除有害物质报告报表")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
//        Assert.isNotBlank(id, "删除失败,id不能为空");
//        this.qualityHarmFormsService.deleteObjById(id);
//        return ResponseResult.success();
//    }

    @ApiOperation(httpMethod="POST", value="查询有害物质报告报表")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualityHarmForms", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualityHarmForms>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmFormsExample example = new QualityHarmFormsExample();
        example.setPageView(new PageView<QualityHarmForms>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
//        QualityHarmFormsExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualityHarmForms> pageData = this.qualityHarmFormsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}