package com.els.base.quality.harms.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.harms.command.CreateHarmsCmd;
import com.els.base.quality.harms.command.ModifyHarmsCmd;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="有害物质报告")
@Controller
@RequestMapping("qualityHarmMaterials")
public class QualityHarmMaterialsController {
    
    @Resource
    private HarmsInvorker Invorker;
   
    @Resource
    protected QualityHarmMaterialsService qualityHarmMaterialsService;

    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;
    
    @ApiOperation(httpMethod="POST", value="创建有害物质报告")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualityHarmMaterialsVO qualityHarmMaterialsVO) {
//        this.qualityHarmMaterialsService.addObj(qualityHarmMaterials);
        CreateHarmsCmd cmd=new CreateHarmsCmd(qualityHarmMaterialsVO);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑有害物质报告")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualityHarmMaterialsVO vo) {
        Assert.isNotBlank(vo.getId(), "id 为空，保存失败");
//        this.qualityHarmMaterialsService.modifyObj(qualityHarmMaterials);
        ModifyHarmsCmd cmd=new ModifyHarmsCmd(vo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="批量删除有害物质报告")
    @RequestMapping("service/pur/delete")
    @ResponseBody
    public ResponseResult<String> delete(@RequestBody List<QualityHarmMaterials> data) {
//        Assert.isNotBlank(id, "删除失败,id不能为空");
//        this.qualityHarmMaterialsService.deleteObjById(id);
        this.qualityHarmMaterialsService.delete(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量作废单据")
    @RequestMapping("service/pur/abolish")
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.abolish(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量发送单据")
    @RequestMapping("service/pur/sendToSup")
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToSup(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商回签单据")
    @RequestMapping("service/pur/sendToPur")
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToPur(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量审核单据")
    @RequestMapping("service/pur/audit")
    @ResponseBody
    public ResponseResult<String> audit(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.audit(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量驳回单据")
    @RequestMapping("service/pur/reject")
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.reject(data,SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商更新附件信息")
    @RequestMapping("service/sup/updateBillAttachmentInfo")
    @ResponseBody
    public ResponseResult<String> updateBillAttachmentInfo(@RequestBody QualityHarmMaterialsVO vo){
        this.qualityHarmMaterialsService.updateBillAttachmentInfo(vo);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="查询有害物质报告(采购方)")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualityHarmMaterials", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/pur/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForPur( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView(new PageView<QualityHarmMaterials>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualityHarmMaterials> pageData = this.qualityHarmMaterialsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查询有害物质报告(采购方)")
    @ApiImplicitParams({ 
        @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
        @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
        @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualityHarmMaterials", paramType = "body", dataType = "QueryParamWapper" )  
    }) 
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForSup( 
        @RequestParam(defaultValue="0") int pageNo,  
        @RequestParam(defaultValue="10") int pageSize, 
        @RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView(new PageView<QualityHarmMaterials>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        Company company = CompanyUtils.currentCompany();
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andSendStatusEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualityHarmMaterials> pageData = this.qualityHarmMaterialsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查看单据详情(采购方)")
    @RequestMapping("service/pur/findDetailById")
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailByIdForPur(String id) {
        if(StringUtils.isEmpty(id)){
            throw new CommonException("传递的id为空!");
        }
        QualityHarmMaterials data = this.qualityHarmMaterialsService.queryObjById(id);
        if(null == data){
            throw new CommonException("根据id查找的单据不存在!");
        }
        
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        //将对象的属性赋值给vo
        BeanUtils.copyProperties(data, vo);
        //查询行项数据
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria()
            .andHarmMaterialIdEqualTo(id);
        
        List<QualityHarmMaterialsItem> itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample(example);
        //如果是未回签,采购商方不查看附件信息
        if(BillStatusEnum.STATUS_UN_SIGN.getBillStatus().equals(vo.getBillStatus())){
            if(CollectionUtils.isNotEmpty(itemList)){
                for (QualityHarmMaterialsItem item : itemList) {
                    item.setAttachment(null);
                    item.setCheckTime(null);
                    item.setItemSupRemark(null);
                }
            }
        }
        vo.setItemList(itemList);
        
        return ResponseResult.success(vo);
    }
    
    @ApiOperation(httpMethod="POST", value="查看单据详情(供应商方)")
    @RequestMapping("service/sup/findDetailById")
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailById(String id) {
        if(StringUtils.isEmpty(id)){
            throw new CommonException("传递的id为空!");
        }
        QualityHarmMaterials data = this.qualityHarmMaterialsService.queryObjById(id);
        if(null == data){
            throw new CommonException("根据id查找的单据不存在!");
        }
        
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        //将对象的属性赋值给vo
        BeanUtils.copyProperties(data, vo);
        //查询行项数据
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria()
            .andHarmMaterialIdEqualTo(id);
        
        List<QualityHarmMaterialsItem> itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample(example);
        vo.setItemList(itemList);
        return ResponseResult.success(vo);
    }
}