package com.els.base.quality.harms.web.controller;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="有害物质报告行项")
@Controller
@RequestMapping("qualityHarmMaterialsItem")
public class QualityHarmMaterialsItemController {
    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;

    @ApiOperation(httpMethod="POST", value="创建有害物质报告行项")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualityHarmMaterialsItem qualityHarmMaterialsItem) {
        this.qualityHarmMaterialsItemService.addObj(qualityHarmMaterialsItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑有害物质报告行项")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualityHarmMaterialsItem qualityHarmMaterialsItem) {
        Assert.isNotBlank(qualityHarmMaterialsItem.getId(), "id 为空，保存失败");
        this.qualityHarmMaterialsItemService.modifyObj(qualityHarmMaterialsItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除有害物质报告行项")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.qualityHarmMaterialsItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询有害物质报告行项")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 QualityHarmMaterialsItem", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterialsItem>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.setPageView(new PageView<QualityHarmMaterialsItem>(pageNo, pageSize));
        
        QualityHarmMaterialsItemExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<QualityHarmMaterialsItem> pageData = this.qualityHarmMaterialsItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}