package com.els.base.quality.inspection.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Liuqinxiang
 */
@ApiModel(value="SAP检验不合格批次")
public class UnQualifiedBatch implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("检验批（SAP检验批编号）")
    private String inspectionLot;

    @ApiModelProperty("系统状态")
    private String erpStatus;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称/物料描述")
    private String materialName;

    @ApiModelProperty("物料描述")
    private String materialSpecification;

    @ApiModelProperty("采购凭证号(订单号)")
    private String orderNo;

    @ApiModelProperty("采购凭证的项目编号(订单行号)")
    private String orderItemNo;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("检验批数量/ActLotQty")
    private Integer actLotQty;

    @ApiModelProperty("检验数量")
    private Integer checkQty;

    @ApiModelProperty("检验数量中的缺陷数量/检验数量中的缺陷数量")
    private Integer defectsNumber;

    @ApiModelProperty("非限制使用库存")
    private Integer unrestrictedInventory;

    @ApiModelProperty("冻结数量 ")
    private Integer freezeQty;

    @ApiModelProperty("冻结库存")
    private Integer freezeInventory;

    @ApiModelProperty("检验员")
    private String inspector;

    @ApiModelProperty("短文本")
    private String shortText;

    @ApiModelProperty("使用决策代码")
    private String decisionCode;

    @ApiModelProperty("决策短文本")
    private String decisionNotes;

    @ApiModelProperty("决策长文本")
    private String decisionLengthText;

    @ApiModelProperty("代码的短文本")
    private String shortTextCode;

    @ApiModelProperty("项目正文")
    private String projectText;

    @ApiModelProperty("检验描述")
    private String checkDescription;

    @ApiModelProperty("不合格描述长文本")
    private String disqualificationText;

    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;

    @ApiModelProperty("责任方")
    private String responsibility;

    @ApiModelProperty("产品类别/产品类别")
    private String productCategory;

    @ApiModelProperty("创建人")
    private String usgdecMadeBy;

    @ApiModelProperty("UD代码日期")
    private Date udCodeDate;

    @ApiModelProperty("决策修改人")
    private String decisionChange;

    @ApiModelProperty("决策修改日期")
    private Date decisionModificationDate;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getInspectionLot() {
        return inspectionLot;
    }

    public void setInspectionLot(String inspectionLot) {
        this.inspectionLot = inspectionLot == null ? null : inspectionLot.trim();
    }

    public String getErpStatus() {
        return erpStatus;
    }

    public void setErpStatus(String erpStatus) {
        this.erpStatus = erpStatus == null ? null : erpStatus.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialSpecification() {
        return materialSpecification;
    }

    public void setMaterialSpecification(String materialSpecification) {
        this.materialSpecification = materialSpecification == null ? null : materialSpecification.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(String orderItemNo) {
        this.orderItemNo = orderItemNo == null ? null : orderItemNo.trim();
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName == null ? null : factoryName.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public Integer getActLotQty() {
        return actLotQty;
    }

    public void setActLotQty(Integer actLotQty) {
        this.actLotQty = actLotQty;
    }

    public Integer getCheckQty() {
        return checkQty;
    }

    public void setCheckQty(Integer checkQty) {
        this.checkQty = checkQty;
    }

    public Integer getDefectsNumber() {
        return defectsNumber;
    }

    public void setDefectsNumber(Integer defectsNumber) {
        this.defectsNumber = defectsNumber;
    }

    public Integer getUnrestrictedInventory() {
        return unrestrictedInventory;
    }

    public void setUnrestrictedInventory(Integer unrestrictedInventory) {
        this.unrestrictedInventory = unrestrictedInventory;
    }

    public Integer getFreezeQty() {
        return freezeQty;
    }

    public void setFreezeQty(Integer freezeQty) {
        this.freezeQty = freezeQty;
    }

    public Integer getFreezeInventory() {
        return freezeInventory;
    }

    public void setFreezeInventory(Integer freezeInventory) {
        this.freezeInventory = freezeInventory;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector == null ? null : inspector.trim();
    }

    public String getShortText() {
        return shortText;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText == null ? null : shortText.trim();
    }

    public String getDecisionCode() {
        return decisionCode;
    }

    public void setDecisionCode(String decisionCode) {
        this.decisionCode = decisionCode == null ? null : decisionCode.trim();
    }

    public String getDecisionNotes() {
        return decisionNotes;
    }

    public void setDecisionNotes(String decisionNotes) {
        this.decisionNotes = decisionNotes == null ? null : decisionNotes.trim();
    }

    public String getDecisionLengthText() {
        return decisionLengthText;
    }

    public void setDecisionLengthText(String decisionLengthText) {
        this.decisionLengthText = decisionLengthText == null ? null : decisionLengthText.trim();
    }

    public String getShortTextCode() {
        return shortTextCode;
    }

    public void setShortTextCode(String shortTextCode) {
        this.shortTextCode = shortTextCode == null ? null : shortTextCode.trim();
    }

    public String getProjectText() {
        return projectText;
    }

    public void setProjectText(String projectText) {
        this.projectText = projectText == null ? null : projectText.trim();
    }

    public String getCheckDescription() {
        return checkDescription;
    }

    public void setCheckDescription(String checkDescription) {
        this.checkDescription = checkDescription == null ? null : checkDescription.trim();
    }

    public String getDisqualificationText() {
        return disqualificationText;
    }

    public void setDisqualificationText(String disqualificationText) {
        this.disqualificationText = disqualificationText == null ? null : disqualificationText.trim();
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo == null ? null : needFollowNo.trim();
    }

    public String getResponsibility() {
        return responsibility;
    }

    public void setResponsibility(String responsibility) {
        this.responsibility = responsibility == null ? null : responsibility.trim();
    }

    public String getProductCategory() {
        return productCategory;
    }

    public void setProductCategory(String productCategory) {
        this.productCategory = productCategory == null ? null : productCategory.trim();
    }

    public String getUsgdecMadeBy() {
        return usgdecMadeBy;
    }

    public void setUsgdecMadeBy(String usgdecMadeBy) {
        this.usgdecMadeBy = usgdecMadeBy == null ? null : usgdecMadeBy.trim();
    }

    public Date getUdCodeDate() {
        return udCodeDate;
    }

    public void setUdCodeDate(Date udCodeDate) {
        this.udCodeDate = udCodeDate;
    }

    public String getDecisionChange() {
        return decisionChange;
    }

    public void setDecisionChange(String decisionChange) {
        this.decisionChange = decisionChange == null ? null : decisionChange.trim();
    }

    public Date getDecisionModificationDate() {
        return decisionModificationDate;
    }

    public void setDecisionModificationDate(Date decisionModificationDate) {
        this.decisionModificationDate = decisionModificationDate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}