package com.els.base.quality.inspection.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.inspection.dao.UnQualifiedBatchMapper;
import com.els.base.quality.inspection.entity.UnQualifiedBatch;
import com.els.base.quality.inspection.entity.UnQualifiedBatchExample;
import com.els.base.quality.inspection.service.UnQualifiedBatchService;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultUnQualifiedBatchService")
public class UnQualifiedBatchServiceImpl implements UnQualifiedBatchService {
    @Resource
    protected UnQualifiedBatchMapper unQualifiedBatchMapper;

    @Resource
    protected CompanyService companyService;

    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public void addObj(UnQualifiedBatch t) {
        this.unQualifiedBatchMapper.insertSelective(t);
    }

    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.unQualifiedBatchMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public void modifyObj(UnQualifiedBatch t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.unQualifiedBatchMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "unQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public UnQualifiedBatch queryObjById(String id) {
        return this.unQualifiedBatchMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "unQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public List<UnQualifiedBatch> queryAllObjByExample(UnQualifiedBatchExample example) {
        return this.unQualifiedBatchMapper.selectByExample(example);
    }

    @Cacheable(value = "unQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<UnQualifiedBatch> queryObjByPage(UnQualifiedBatchExample example) {
        PageView<UnQualifiedBatch> pageView = example.getPageView();
        pageView.setQueryResult(this.unQualifiedBatchMapper.selectByExampleByPage(example));
        return pageView;
    }

    /**
     * 从SAP导入不合格检验批次系信息
     **/
    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public int importUnQualifiedBatchFromSAP(List<UnQualifiedBatch> list, StringBuilder builder) {
        int errorCount = 0;
        builder.append("开始处理数据").append("\r\n");
        if (list == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        builder.append("接收到不合格检验批次数据" + list.size() + "条").append("\r\n");

        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }

        builder.append("开始处理数据").append("\r\n");
        for (UnQualifiedBatch item : list) {
            try {

                UnQualifiedBatchExample unQualifiedBatchExample = new UnQualifiedBatchExample();
                UnQualifiedBatchExample.Criteria criteria = unQualifiedBatchExample.createCriteria();
                criteria.andInspectionLotEqualTo(item.getInspectionLot());
                int count = unQualifiedBatchMapper.countByExample(unQualifiedBatchExample);
                if (count > 0) {
                    UnQualifiedBatch uQualifiedBatch = unQualifiedBatchMapper.selectByExample(unQualifiedBatchExample).get(0);
                    criteria.andIdEqualTo(uQualifiedBatch.getId());
                    uQualifiedBatch.setUpdateTime(new Date());
                    unQualifiedBatchMapper.updateByExampleSelective(item, unQualifiedBatchExample);
                } else {
                    item.setProjectId(projectId);
                    item.setCompanyId(companyId);
                    item.setCreateTime(new Date());
                    item.setCreateUserId("Webservice");
                    item.setCreateUserName("Webservice");
                    item.setUpdateTime(new Date());
                    unQualifiedBatchMapper.insertSelective(item);
                }
                //根据不合格品检验单生成不合格品处置单

            } catch (Exception e) {
                errorCount++;
                builder.append("检验批次:" + item.getInspectionLot() + "数据保存失败")
                        .append("\r\n");
                try {
                    builder.append("检验批次信息").append("\r\n");
                    builder.append(JsonUtils.writeValueAsString(item)).append("\r\n");
                } catch (JsonProcessingException e1) {
                    e1.printStackTrace();
                }
                builder.append("错误原因:" + e.getMessage()).append("\r\n");
            }
            builder.append("处理成功条数 " + (list.size() - errorCount) + "条").append("\r\n");
            builder.append("处理失败条数 " + errorCount + "条").append("\r\n");
            builder.append("数据处理完成").append("\r\n");
        }
        return errorCount;
    }

    @Cacheable(value = "unQualifiedBatch", keyGenerator = "redisKeyGenerator")
    public Boolean isExists(UnQualifiedBatch entity) {

        UnQualifiedBatchExample unQualifiedBatchExample = new UnQualifiedBatchExample();
        UnQualifiedBatchExample.Criteria criteria = unQualifiedBatchExample.createCriteria();
        criteria.andInspectionLotEqualTo(entity.getInspectionLot());
        int count = unQualifiedBatchMapper.countByExample(unQualifiedBatchExample);
        if (count > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Transactional
    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public void addAll(List<UnQualifiedBatch> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.unQualifiedBatchMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value = {"unQualifiedBatch"}, allEntries = true)
    @Override
    public void deleteByExample(UnQualifiedBatchExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.unQualifiedBatchMapper.deleteByExample(arg0);
        
    }
}