package com.els.base.quality.inspection.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.inspection.entity.UnQualifiedBatch;
import com.els.base.quality.inspection.entity.UnQualifiedBatchExample;
import com.els.base.quality.inspection.service.UnQualifiedBatchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="SAP检验不合格批次")
@Controller
@RequestMapping("unQualifiedBatch")
public class UnQualifiedBatchController {
    @Resource
    protected UnQualifiedBatchService unQualifiedBatchService;

    @ApiOperation(httpMethod="POST", value="创建SAP检验不合格批次")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UnQualifiedBatch unQualifiedBatch) {
        this.unQualifiedBatchService.addObj(unQualifiedBatch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑SAP检验不合格批次")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UnQualifiedBatch unQualifiedBatch) {
        Assert.isNotBlank(unQualifiedBatch.getId(), "id 为空，保存失败");
        this.unQualifiedBatchService.modifyObj(unQualifiedBatch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除SAP检验不合格批次")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.unQualifiedBatchService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询SAP检验不合格批次")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 UnQualifiedBatch", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<UnQualifiedBatch>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        UnQualifiedBatchExample example = new UnQualifiedBatchExample();
        example.setPageView(new PageView<UnQualifiedBatch>(pageNo, pageSize));
        
        UnQualifiedBatchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<UnQualifiedBatch> pageData = this.unQualifiedBatchService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}