package com.els.base.quality.ncr.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="NCR数据表")
public class Ncr implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    private String supUserId;

    @ApiModelProperty("NCR ID QMS系统的NCRID")
    private String ncrQmsId;

    @ApiModelProperty("NCR编码")
    private String ncrNumber;

    @ApiModelProperty("NCR报告")
    private String ncrReport;

    @ApiModelProperty("开立时间")
    private Date openTime;

    @ApiModelProperty("是否关闭")
    private String isClose;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称/产品名称")
    private String materialName;

    @ApiModelProperty("图号")
    private String mapNo;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("不合格描述")
    private String unqualifiedDescription;

    @ApiModelProperty("不合格类型")
    private String unqualifiedType;

    @ApiModelProperty("公司编码 责任方")
    private String purCompanyCode;

    @ApiModelProperty("公司编码(SAP)责任方")
    private String purCompanySapCode;

    @ApiModelProperty("公司名称 责任方")
    private String purCompanyName;

    @ApiModelProperty("供应商代码（生产单位）")
    private String supCompanyCode;

    @ApiModelProperty("供应商SAP编码（生产单位）")
    private String supCompanySapCode;

    @ApiModelProperty("供应商名称（生产单位）")
    private String supCompanyName;

    @ApiModelProperty("项目")
    private String project;

    @ApiModelProperty("负责人")
    private String responsible;

    @ApiModelProperty("处理方式")
    private String disposalWay;

    @ApiModelProperty("当前处置人员")
    private String disposalUser;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("发送状态 0未发送 1已发送")
    private Integer sendStatus;

    @ApiModelProperty("状态1新增2发布3供应商回复4确认回复5拒绝回复")
    private Integer status;

    @ApiModelProperty("整改类型 8D报告单、整改单")
    private String rectificationType;

    @ApiModelProperty("要求供应商回复时间")
    private Date requestResponseTime;

    @ApiModelProperty("供应商回复时间")
    private Date supplierResponseTime;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("采购回复")
    private String purchasingReply;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("备注字段")
    private String memo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("原因分析")
    private String causeAnalysis;

    @ApiModelProperty("纠正措施")
    private String correctiveAnalysis;

    @ApiModelProperty("完成日期")
    private Date completionDate;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getNcrQmsId() {
        return ncrQmsId;
    }

    public void setNcrQmsId(String ncrQmsId) {
        this.ncrQmsId = ncrQmsId == null ? null : ncrQmsId.trim();
    }

    public String getNcrNumber() {
        return ncrNumber;
    }

    public void setNcrNumber(String ncrNumber) {
        this.ncrNumber = ncrNumber == null ? null : ncrNumber.trim();
    }

    public String getNcrReport() {
        return ncrReport;
    }

    public void setNcrReport(String ncrReport) {
        this.ncrReport = ncrReport == null ? null : ncrReport.trim();
    }

    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public String getIsClose() {
        return isClose;
    }

    public void setIsClose(String isClose) {
        this.isClose = isClose == null ? null : isClose.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getUnqualifiedDescription() {
        return unqualifiedDescription;
    }

    public void setUnqualifiedDescription(String unqualifiedDescription) {
        this.unqualifiedDescription = unqualifiedDescription == null ? null : unqualifiedDescription.trim();
    }

    public String getUnqualifiedType() {
        return unqualifiedType;
    }

    public void setUnqualifiedType(String unqualifiedType) {
        this.unqualifiedType = unqualifiedType == null ? null : unqualifiedType.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getResponsible() {
        return responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible == null ? null : responsible.trim();
    }

    public String getDisposalWay() {
        return disposalWay;
    }

    public void setDisposalWay(String disposalWay) {
        this.disposalWay = disposalWay == null ? null : disposalWay.trim();
    }

    public String getDisposalUser() {
        return disposalUser;
    }

    public void setDisposalUser(String disposalUser) {
        this.disposalUser = disposalUser == null ? null : disposalUser.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRectificationType() {
        return rectificationType;
    }

    public void setRectificationType(String rectificationType) {
        this.rectificationType = rectificationType == null ? null : rectificationType.trim();
    }

    public Date getRequestResponseTime() {
        return requestResponseTime;
    }

    public void setRequestResponseTime(Date requestResponseTime) {
        this.requestResponseTime = requestResponseTime;
    }

    public Date getSupplierResponseTime() {
        return supplierResponseTime;
    }

    public void setSupplierResponseTime(Date supplierResponseTime) {
        this.supplierResponseTime = supplierResponseTime;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public String getPurchasingReply() {
        return purchasingReply;
    }

    public void setPurchasingReply(String purchasingReply) {
        this.purchasingReply = purchasingReply == null ? null : purchasingReply.trim();
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getCauseAnalysis() {
        return causeAnalysis;
    }

    public void setCauseAnalysis(String causeAnalysis) {
        this.causeAnalysis = causeAnalysis == null ? null : causeAnalysis.trim();
    }

    public String getCorrectiveAnalysis() {
        return correctiveAnalysis;
    }

    public void setCorrectiveAnalysis(String correctiveAnalysis) {
        this.correctiveAnalysis = correctiveAnalysis == null ? null : correctiveAnalysis.trim();
    }

    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}