package com.els.base.quality.ncr.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.ncr.dao.NcrMapper;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.entity.NcrExample;
import com.els.base.quality.ncr.service.NcrService;

import java.util.List;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.apache.commons.collections.CollectionUtils;

@Service("defaultNcrService")
public class NcrServiceImpl implements NcrService {
    @Resource
    protected NcrMapper ncrMapper;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected CompanyUserRefService companyUserRefService;


    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void addObj(Ncr t) {
        this.ncrMapper.insertSelective(t);
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.ncrMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void modifyObj(Ncr t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.ncrMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="ncr", keyGenerator="redisKeyGenerator")
    @Override
    public Ncr queryObjById(String id) {
        return this.ncrMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="ncr", keyGenerator="redisKeyGenerator")
    @Override
    public List<Ncr> queryAllObjByExample(NcrExample example) {
        return this.ncrMapper.selectByExample(example);
    }

    @Cacheable(value="ncr", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<Ncr> queryObjByPage(NcrExample example) {
        PageView<Ncr> pageView = example.getPageView();
        pageView.setQueryResult(this.ncrMapper.selectByExampleByPage(example));
        return pageView;
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void importNcrFromQMS(List<Ncr> list,StringBuilder builder) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }

        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }

        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                if(this.isExists(ncritem))
                {
                    ncritem.setUpdateUserId("WebService");
                    ncritem.setUpdateUserName("WebService");
                    ncritem.setUpdateTime(now);
                }
                else {
                    CompanyExample supCompanyExample = new CompanyExample();
                    supCompanyExample.createCriteria().andCompanyNameEqualTo(ncritem.getSupCompanyName());
                    List<Company> supCompanyList = companyService.queryAllObjByExample(supCompanyExample);
                    if (CollectionUtils.isNotEmpty(supCompanyList)) {
                        ncritem.setSupCompanyCode(supCompanyList.get(0).getCompanyCode());
                        ncritem.setSupCompanySapCode(supCompanyList.get(0).getCompanySapCode());
                    }

                    ncritem.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
                    ncritem.setProjectId(projectId);
                    ncritem.setCompanyId(companyId);
                    ncritem.setCreateUserId("WebService");
                    ncritem.setUpdateUserId("WebService");
                    ncritem.setCreateUserName("WebService");
                    ncritem.setUpdateUserName("WebService");
                    ncritem.setCreateTime(now);
                    ncritem.setUpdateTime(now);
                    this.addObj(ncritem);
                }
            } catch (CommonException ee) {
                //throw new CommonException("数据导入失败！" + ee.getMessage());
                builder.append("数据导入失败").append("\r\n");
                builder.append("单据号码"+ncritem.getNcrNumber()).append("\r\n");
                builder.append(ee.getMessage()).append("\r\n");
            }
        }
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Cacheable(value = "inspection", keyGenerator = "redisKeyGenerator")
    public Boolean isExists(Ncr ncr) {

        NcrExample inspectionExample = new NcrExample();
        NcrExample.Criteria criteria = inspectionExample.createCriteria();
        criteria.andNcrQmsIdEqualTo(ncr.getNcrQmsId());
        criteria.andNcrNumberEqualTo(ncr.getNcrNumber());
        int count = this.ncrMapper.countByExample(inspectionExample);
        if (count > 0) {
            return true;
        } else {
            return false;
        }
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void importNcr(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setProjectId(projectId);
                ncritem.setCompanyId(companyId);
                ncritem.setCreateUserId(user.getId());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setCreateUserName(user.getNickName());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setCreateTime(now);
                ncritem.setUpdateTime(now);
                ncritem.setPurCompanyName("南京康尼机电轨道交通");
                ncritem.setPurCompanySapCode("50000000");
                ncritem.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
                this.addObj(ncritem);
            } catch (CommonException ee) {
                throw new CommonException("数据导入失败！" + ee.getMessage());
            }
        }
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
	public void addNcr(String projectId, String currentCompanyId,
			com.els.base.auth.entity.User loginUser, Ncr ncr) {
    	  Date now = new Date();
    	ncr.setProjectId(projectId);
    	ncr.setCompanyId(currentCompanyId);
    	ncr.setCreateUserId(loginUser.getId());
    	ncr.setUpdateUserId(loginUser.getId());
    	ncr.setCreateUserName(loginUser.getNickName());
    	ncr.setUpdateUserName(loginUser.getNickName());
    	ncr.setCreateTime(now);
    	ncr.setUpdateTime(now);
    	ncr.setPurCompanyName("南京康尼机电轨道交通");
    	ncr.setPurCompanySapCode("50000000");
    	ncr.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
    	this.addObj(ncr);
	}

    /**
     * NCR推送到采购员 生成不合格处理单
     * */
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void pushedToBuyer(User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                //
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
                //

            } catch (CommonException ee) {
                throw new CommonException("推送失败："+ee.getMessage());
            }
        }
    }


    /**
     * NCR推送给供应商
     * */
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void pushedToSuppler(User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_PUBLIC.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
              	ncritem.setSendStatus(Constant.YES_INT);
                this.modifyObj(ncritem);
                //

            } catch (CommonException ee) {
                throw new CommonException("推送失败："+ee.getMessage());
            }
        }
    }
    /**
     * 供应商回复信息
     * */
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void supplerResponse(User user, Ncr entity) {
        Date now = new Date();
        Ncr ncr=this.queryObjById(entity.getId());
       // ncr.setSupplierReply(entity.getSupplierReply());
        ncr.setCauseAnalysis(entity.getCauseAnalysis());
        ncr.setCorrectiveAnalysis(entity.getCorrectiveAnalysis());
        ncr.setCompletionDate(entity.getCompletionDate());
        ncr.setStatus(NcrStatusEnum.STATUS_CONFIRM.getValue());
        ncr.setSupplierResponseTime(new Date());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(now);
        this.modifyObj(ncr);
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void acceptToSuppler(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_APPROVE.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
                //

            } catch (CommonException ee) {
                throw new CommonException("推送失败："+ee.getMessage());
            }
        }
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void refuseToSuppler(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_REFUSED.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
                //

            } catch (CommonException ee) {
                throw new CommonException("推送失败："+ee.getMessage());
            }
        }
    }
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void addAttachment(User user, Ncr ncr) {
        Date now = new Date();
        ncr.setUpdateUserId(user.getId());
        ncr.setUpdateUserName(user.getNickName());
        ncr.setUpdateTime(now);
        this.modifyObj(ncr);
    }

    @Cacheable(value="ncr", keyGenerator="redisKeyGenerator")
	@Override
	public int countByExample(NcrExample ncrExample) {
	int countByExample = this.ncrMapper.countByExample(ncrExample);

		return countByExample;
	}

    @Transactional
    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void addAll(List<Ncr> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.ncrMapper.insertSelective(item);
        });

    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    @Override
    public void deleteByExample(NcrExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.ncrMapper.deleteByExample(arg0);

    }

    @Override
    public void outTimeReply() {
        //拿到所有状态为【发布给供应商】且【超出5天未回复的数据】的单据
        List<Ncr> ncrList = this.ncrMapper.selectOutTimeReplyData();
        //根据供应商编码分组
        Map<String, List<Ncr>> listMap = ncrList.stream().collect(Collectors.groupingBy(Ncr::getSupCompanySapCode));
        for (Map.Entry<String,List<Ncr>> entry :listMap.entrySet()){
            List<Ncr> value = entry.getValue();
            List<String> ncrNumberList = value.stream().map(Ncr::getNcrNumber).collect(Collectors.toList());
            String ncrNumber = StringUtils.join(ncrNumberList, ",");
            // 通过供应商公司id查询用户
            CompanyExample example=new CompanyExample();
            example.createCriteria().andCompanySapCodeEqualTo(entry.getKey());
            List<Company> companyList = this.companyService.queryAllObjByExample(example);
            User user = companyUserRefService.queryMainUserOfCompany(companyList.get(0).getId());
            Ncr ncr=new Ncr();
            ncr.setNcrNumber(ncrNumber);
            ncr.setSupUserId(user.getId());
            ncr.setSupCompanyCode(companyList.get(0).getCompanyCode());
            Message<Ncr> message = Message.init(ncr)
                    .setCompanyCode(entry.getKey())
                    .setSenderId("1")
                    .addReceiverId(user.getId())
                    .setMsgLevel(MessageLevelEnum.HIGH)
                    .setBusinessTypeCode(NcrStatusEnum.NCR_OUT_TIME_REPLY.getDesc());
            MessageSendUtils.sendMessage(message);
        }
    }
}