package com.els.base.quality.ncr.utils;

import com.els.base.utils.excel.DateConverter;
import jxl.Cell;
import jxl.Sheet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 针对不同日期格式进行转换
 * @author wuwenxin
 *
 */
public class MultipleDateConverter extends DateConverter {
	
	/**
	 * 针对yyyy-MM-dd、yyyy/MM/dd、yyyyMMdd三种格式，如果为其他格式，则抛出异常
	 */
	@Override
	public Date convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
		Date date;
		try {
			date = new SimpleDateFormat("yyyy-MM-dd").parse(content);
		} catch (Exception e) {
			try {
				date = new SimpleDateFormat("yyyy/MM/dd").parse(content);
			} catch (Exception e2) {
				date = new SimpleDateFormat("yyyyMMdd").parse(content);
			}
		}
		return date;
	}
}
