package com.els.base.quality.ncr.utils;

public enum NcrStatusEnum {
    STATUS_INVALID(-1,"作废"),
    /**新增**/
    STATUS_NEW(1,"新增"),
    /**发布给供应商*/
    STATUS_PUBLIC(2,"发布给供应商"),
    /**供应商回复*/
    STATUS_CONFIRM(3,"供应商回复"),
    /**已驳回**/
    STATUS_APPROVE(4,"采购同意"),
    /**采购拒绝**/
    STATUS_REFUSED(5,"采购拒绝"),
    /**NCR超期未回复预警**/
    NCR_OUT_TIME_REPLY(6,"NCR_OUT_TIME_REPLY");

    private final Integer value;
    private final String desc;

    private NcrStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}
