package com.els.base.quality.ncr.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.entity.NcrExample;
import com.els.base.quality.ncr.service.NcrService;
import com.els.base.quality.ncr.utils.MultipleDateConverter;
import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.*;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.*;

@Api(value = "NCR数据表")
@Controller
@RequestMapping("ncr")
public class NcrController {

    private static final NcrController titleAndModelKeys = null;

	Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    protected NcrService ncrService;

    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod = "POST", value = "创建NCR数据表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Ncr ncr) {
        this.ncrService.addObj(ncr);
        return ResponseResult.success();
    }
    @ApiOperation(httpMethod = "POST", value = "新增ncr")
    @RequestMapping("service/add")
    @ResponseBody
    public ResponseResult<String> add(@RequestBody Ncr ncr) {
    	 Assert.isNotBlank(ncr.getNcrQmsId(), "QMS系统的NCRID不能为空");
         Assert.isNotBlank(ncr.getNcrNumber(), "NCR编码不能为空");
         Assert.isNotBlank(ncr.getNcrReport(), "NCR报告不能为空");
         Assert.isNotNull(ncr.getOpenTime(),"开立时间不能为空");

         Assert.isNotBlank(ncr.getIsClose(), "是否关闭不能为空");
         Assert.isNotBlank(ncr.getMaterialCode(), "物料代码不能为空");
         Assert.isNotBlank(ncr.getMaterialName(), "产品名称不能为空");
         Assert.isNotBlank(ncr.getMapNo(), "图号不能为空");
         Assert.isNotNull(ncr.getQuantity(), "数量不能为空");
         Assert.isNotBlank(ncr.getUnqualifiedDescription(), "不合格描述不能为空");
         Assert.isNotBlank(ncr.getUnqualifiedType(), "不合格类型不能为空");
         Assert.isNotBlank(ncr.getPurCompanyName(), "责任方不能为空");
         Assert.isNotBlank(ncr.getProject(), "项目不能为空");
         Assert.isNotBlank(ncr.getResponsible(), "负责人不能为空");
         Assert.isNotBlank(ncr.getDisposalWay(), "处理方式不能为空");
         Assert.isNotBlank(ncr.getDisposalUser(), "当前处置人员不能为空");
         
         Assert.isNotBlank(ncr.getSupCompanySapCode(), "供应商sapcode不能为空");
         Assert.isNotBlank(ncr.getSupCompanyName(), "供应商名称不能为空");

        this.ncrService.addNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(),ncr);

        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑NCR数据表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Ncr ncr) {
        Assert.isNotBlank(ncr.getId(), "id 为空，保存失败");
        this.ncrService.modifyObj(ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除NCR数据表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.ncrService.deleteObjById(id);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "批量删除NCR数据表")
    @RequestMapping("service/deleteByIdArray")
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {

        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要删除的单据!");
        }
        for (String id : list) {
            Ncr entity = this.ncrService.queryObjById(id);
            if (entity != null) {
                if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                    this.ncrService.deleteObjById(id);
                } else {
                    throw new CommonException("只有新增状态单据才可以删除!");
                }

            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询NCR数据表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Ncr", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Ncr>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        NcrExample example = new NcrExample();
        example.setPageView(new PageView<Ncr>(pageNo, pageSize));

        NcrExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIsEnableEqualTo(Constant.YES_INT);

        List<String> companyCodeArray = new ArrayList<>();
        List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }


        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<Ncr> pageData = this.ncrService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "推送到采购员")
    @RequestMapping("service/pushedToBuyer")
    @ResponseBody
    public ResponseResult<String> pushedToBuyer(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要处理的单据");
        }
        List<Ncr> NcrArray = new ArrayList<>();
        for (String id : list) {
            Ncr entity = this.ncrService.queryObjById(id);
            if (entity != null) {
                if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                    //this.ncrService.deleteObjById(id);
                    NcrArray.add(entity);
                } else {
                    throw new CommonException("只有新增状态单据才可以推送!");
                }

            }
        }
        this.ncrService.pushedToBuyer(SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "发送到供应商")
    @RequestMapping("service/pushedToSuppler")
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("请选择要处理的单据");
        }
        for (Ncr item : NcrArray) {
            Ncr entity = this.ncrService.queryObjById(item.getId());
            if (entity != null) {
                if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                    if (StringUtils.isEmpty(item.getRectificationType())) {
                        throw new CommonException("单据：" + item.getNcrNumber() + "处理方式为空，无法发布!");
                    }
                    if (Constant.YES_INT.equals(entity.getSendStatus())) {
                        throw new CommonException("单据：" + item.getNcrNumber() + "已经发送过，无需再次发送!");
                    }
                } else {
                    throw new CommonException("只有新增状态单据才可以发送!");
                }

            }
        }
        this.ncrService.pushedToSuppler(SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询NCR数据表 供应商")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Ncr", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findSupplerByPage")
    @ResponseBody
    public ResponseResult<PageView<Ncr>> findSupplerByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        NcrExample example = new NcrExample();
        example.setPageView(new PageView<Ncr>(pageNo, pageSize));

        NcrExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        criteria.andStatusNotEqualTo(NcrStatusEnum.STATUS_NEW.getValue());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<Ncr> pageData = this.ncrService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "供应商回复")
    @RequestMapping("service/supplerResponse")
    @ResponseBody
    public ResponseResult<String> supplerResponse(@RequestBody Ncr NcrEntity) {
        this.ncrService.supplerResponse(SpringSecurityUtils.getLoginUser(), NcrEntity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "GET", value = "NCR超期未回复预警")
    @RequestMapping("service/outTimeReply")
    @ResponseBody
    public ResponseResult<String> outTimeReply() {
        this.ncrService.outTimeReply();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商确认NCR单据")
    @RequestMapping("service/supplierAcceptBill")
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要确认的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (Ncr item : list) {
           /* if (StringUtils.isEmpty(item.getSupplierReply())) {
                throw new CommonException("单据：" + item.getNcrNumber() + "回复内容为空，无法提交确认!");
                
            }*/
        		if (StringUtils.isEmpty(item.getCauseAnalysis())) {
                    throw new CommonException("单据：" + item.getNcrNumber() + "原因分析为空，无法提交确认!");

    			}
                if (StringUtils.isEmpty(item.getCorrectiveAnalysis())) {
                    throw new CommonException("单据：" + item.getNcrNumber() + "纠正措施为空，无法提交确认!");

    			}
                Assert.isNotNull(item.getCompletionDate(), "单据：" + item.getNcrNumber() + "完成日期为空，无法提交确认!");
			
        	
            item.setSupplierResponseTime(new Date());
            item.setStatus(NcrStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            this.ncrService.supplerResponse(SpringSecurityUtils.getLoginUser(), item);
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "上传附件")
    @RequestMapping("service/attachment")
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody Ncr ncr) {

        if (StringUtils.isBlank(ncr.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.ncrService.addAttachment(SpringSecurityUtils.getLoginUser(), ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购同意供应商回复")
    @RequestMapping("service/acceptToSuppler")
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("请选择要操作的单据");
        }
        this.ncrService.acceptToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购拒绝供应商回复")
    @RequestMapping("service/refuseToSuppler")
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("请选择要操作的单据");
        }
        this.ncrService.refuseToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(value = "导入NCR单据 Excel", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importNcrFromExcel"})
    public ResponseResult<String> importNcrFromExcel(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        if (MapUtils.isEmpty(fileMap)) {
            logger.info("导入NCR单据----上传文件为空");
            throw new CommonException("上传文件为空", "file_isNull");
        }

        if (fileMap.size() > 1) {
            logger.info("导入NCR单据----无法同时处理多个上传文件");
            throw new CommonException("无法同时处理多个上传文件");
        }

        String key = fileMap.keySet().iterator().next();

        MultipartFile uploadFile = fileMap.get(key);
        logger.info("导入NCR单据titleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        List<Ncr> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(uploadFile.getInputStream(), 0, 1, 0, titleAndModelKeys, Ncr.class);
        } catch (Exception e) {
            logger.info("导入异常" + e.getMessage());
            throw new CommonException("导入异常：" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.ncrService.importNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
        }

        return ResponseResult.success();
    }

    @ApiOperation(value = "导入NCR单据 Txt", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importNcrFromTxt"})
    public ResponseResult<String> importNcrFromTxt(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = {"ncrQmsId", "ncrNumber", "ncrReport", "openTime", "isClose", "materialCode", "materialName", "mapNo"
                , "quantity", "unqualifiedDescription", "unqualifiedType", "purCompanyName", "supCompanyName", "project", "responsible", "disposalWay", "disposalUser","supCompanySapCode","supCompanyName"};
        try {
            TxtImportResponse<Ncr> importTxt = TxtImportUtils.importTxt(file, "\t",
                    Ncr.class, keys);
            List<Ncr> list = importTxt.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                this.ncrService.importNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }

        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }

        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("导入文件的格式不正确，目前只支持txt");
        }

        return file;
    }


    @ApiOperation(value = "NCR导入模板下载(Excel)", httpMethod = "GET")
    @RequestMapping(value = "service/downloadTemplateExcel")
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {

            // Excel头部以及响应信息
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("NCR导入模板.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            // 导出的列头
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            List<Ncr> list = new ArrayList<>();
            // 写入Excel表
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, list, "FRCASE", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            // 下載模板失敗
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();

        MultipleDateConverter dateConverter = new MultipleDateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("ID", "ncrQmsId", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("NCR编码", "ncrNumber", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("NCR报告", "ncrReport", true));


        TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey("开立时间", "openTime");
        validDateFromKey.setToObjConverter(dateConverter);
        validDateFromKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(validDateFromKey);
        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开立时间", "openTime", true));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否关闭", "isClose", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料代码", "materialCode", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品名称", "materialName", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格描述", "unqualifiedDescription", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格类型", "unqualifiedType", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("责任方", "purCompanyName", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "responsible", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "disposalWay", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处置人员", "disposalUser", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商sap编码", "supCompanySapCode", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName", true));

        return titleAndModelKeys;
    }


    //导出excel，选中的单据
    @ApiOperation(value = "NCR单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "NCR单据id", defaultValue = "") @RequestParam(defaultValue = "") String idArray,
            HttpServletResponse response) {
        try {
            logger.info("NCR单据导出Excel 参数" + idArray);
            NcrExample example = new NcrExample();
            if (StringUtils.isNotBlank(idArray)) {
                //criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
                example.createCriteria().andIdIn(Arrays.asList(idArray.split(",")));
            }

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Ncr> ncrList = this.ncrService.queryAllObjByExample(example);
            for (Ncr ncr : ncrList) {
                //用备用字段接受修改状态后的数据
                switch (ncr.getStatus()) {

                    case 1:
                        ncr.setAttribute1("新增");
                        break;
                    case 2:
                        ncr.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        ncr.setAttribute1("供应商回复");
                        break;
                    case 4:
                        ncr.setAttribute1("采购确认");
                        break;
                    case 5:
                        ncr.setAttribute1("采购拒绝");
                        break;
                    default:
                        ncr.setAttribute1("作废");
                        break;
                }
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR单据" + System.currentTimeMillis() + ".xls";

            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("NCR单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();

            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("NCR报告单号", "ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格现象", "unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));


            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey("时间", "createTime");
            validDateFromKey.setToObjConverter(dateConverter);
            validDateFromKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "createTime"));

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));


            logger.info("NCR单据导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, ncrList, "NCR单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            logger.info("NCR单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //采购导出所有的
    @ApiOperation(value = "采购NCR单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/purdownloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            NcrExample example = new NcrExample();
            NcrExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            List<String> companyCodeArray = new ArrayList<>();
            List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                    SpringSecurityUtils.getLoginUserId(), null);
            if (CollectionUtils.isNotEmpty(companyList)) {
                for (Company company : companyList) {
                    companyCodeArray.add(company.getCompanySapCode());
                }
                criteria.andSupCompanySapCodeIn(companyCodeArray);
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Ncr> ncrList = this.ncrService.queryAllObjByExample(example);
            for (Ncr ncr : ncrList) {
                //用备用字段接受修改状态后的数据
                switch (ncr.getStatus()) {
                    case 1:
                        ncr.setAttribute1("新增");
                        break;
                    case 2:
                        ncr.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        ncr.setAttribute1("供应商回复");
                        break;
                    case 4:
                        ncr.setAttribute1("采购确认");
                        break;
                    case 5:
                        ncr.setAttribute1("采购拒绝");
                        break;
                    default:
                        ncr.setAttribute1("作废");
                        break;
                }
            }
            logger.info("NCR单据导出Excel 数据条数" + ncrList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR单据库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("NCR单据.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("NCR单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("NCR报告单号", "ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "purCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格现象", "unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));

            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");
            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey("时间", "createTime");
            validDateFromKey.setToObjConverter(dateConverter);
            validDateFromKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "createTime"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));
            logger.info("NCR单据Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    ncrList, "NCR单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            logger.info("NCR单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //供应商导出所有的
    @ApiOperation(value = "供应商NCR单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/supdownloadReportExcel")
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            NcrExample example = new NcrExample();
            NcrExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
            criteria.andSendStatusEqualTo(Constant.YES_INT);
            criteria.andStatusNotEqualTo(NcrStatusEnum.STATUS_NEW.getValue());

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Ncr> ncrList = this.ncrService.queryAllObjByExample(example);
            for (Ncr ncr : ncrList) {
                //用备用字段接受修改状态后的数据
                switch (ncr.getStatus()) {

                    case 1:
                        ncr.setAttribute1("新增");
                        break;
                    case 2:
                        ncr.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        ncr.setAttribute1("供应商回复");
                        break;
                    case 4:
                        ncr.setAttribute1("采购确认");
                        break;
                    case 5:
                        ncr.setAttribute1("采购拒绝");
                        break;
                    default:
                        ncr.setAttribute1("作废");
                        break;
                }
            }
            logger.info("NCR单据导出Excel 数据条数" + ncrList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR单据库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("NCR单据.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("NCR单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("NCR报告单号", "ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "purCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格现象", "unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));


            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");
            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey("时间", "createTime");
            validDateFromKey.setToObjConverter(dateConverter);
            validDateFromKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "createTime"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("当前处理人", "disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            logger.info("NCR单据Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    ncrList, "NCR单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            logger.info("NCR单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


}