package com.els.base.quality.report.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel(value="质量管理-零件不良报告书")
public class BadReport implements Serializable {


    /************以下非自动生成***************/

    @ApiModelProperty("不良报告行列表")
    private List<BadReportItem> badReportItemList;
    public List<BadReportItem> getBadReportItemList() {
        return badReportItemList;
    }
    public void setBadReportItemList(List<BadReportItem> badReportItemList) {
        this.badReportItemList = badReportItemList;
    }
    /**************************************/

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购商ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商简称")
    private String purCompanyName;

    @ApiModelProperty("采购商全称")
    private String purCompanyFullName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("消息推送(采购方)")
    private String purUserId;

    @ApiModelProperty("消息推送(供应商方)")
    private String supUserId;

    @ApiModelProperty("采购商备注")
    private String purRemark;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("发送状态（0=未发送，1=已发送）")
    private Integer sendStatus;

    @ApiModelProperty("供应商发送时间")
    private Date purSendTime;

    @ApiModelProperty("采购商资料提交时间")
    private Date purCommitTime;

    @ApiModelProperty("供应商资料提交时间")
    private Date supCommitTime;

    @ApiModelProperty("供应商回签时间")
    private Date supSignTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("(未回签=0, 已回签=1, 已审核=2, 已驳回=3, 已作废=4)")
    private Integer billStatus;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("单据号")
    private String badReportNo;

    @ApiModelProperty("机种名")
    private String modelName;

    @ApiModelProperty("供应商分零件号")
    private String supComponentNo;

    @ApiModelProperty("供应商分零件名称")
    private String supComponentName;

    @ApiModelProperty("LOT NO")
    private String lotNo;

    @ApiModelProperty("LOT 描述")
    private String lotDesc;

    @ApiModelProperty("LOT 数量")
    private Integer lotQuantity;

    @ApiModelProperty("发生时间")
    private Date reportTime;

    @ApiModelProperty("发生地方")
    private String reportPlace;

    @ApiModelProperty("承认人ID")
    private String recognizedUserId;

    @ApiModelProperty("承认人名称")
    private String recognizedUserName;

    @ApiModelProperty("品管部门确认人ID")
    private String qualityConfirmId;

    @ApiModelProperty("品管部门确认人名称")
    private String qualityConfirmName;

    @ApiModelProperty("发行")
    private String publishName;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("不良报告图片")
    private String badReportImg;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回复附件名称")
    private String supBadReportFile;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购上传附件名称")
    private String purBadReportFile;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Date getPurSendTime() {
        return purSendTime;
    }

    public void setPurSendTime(Date purSendTime) {
        this.purSendTime = purSendTime;
    }

    public Date getPurCommitTime() {
        return purCommitTime;
    }

    public void setPurCommitTime(Date purCommitTime) {
        this.purCommitTime = purCommitTime;
    }

    public Date getSupCommitTime() {
        return supCommitTime;
    }

    public void setSupCommitTime(Date supCommitTime) {
        this.supCommitTime = supCommitTime;
    }

    public Date getSupSignTime() {
        return supSignTime;
    }

    public void setSupSignTime(Date supSignTime) {
        this.supSignTime = supSignTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getBadReportNo() {
        return badReportNo;
    }

    public void setBadReportNo(String badReportNo) {
        this.badReportNo = badReportNo == null ? null : badReportNo.trim();
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName == null ? null : modelName.trim();
    }

    public String getSupComponentNo() {
        return supComponentNo;
    }

    public void setSupComponentNo(String supComponentNo) {
        this.supComponentNo = supComponentNo == null ? null : supComponentNo.trim();
    }

    public String getSupComponentName() {
        return supComponentName;
    }

    public void setSupComponentName(String supComponentName) {
        this.supComponentName = supComponentName == null ? null : supComponentName.trim();
    }

    public String getLotNo() {
        return lotNo;
    }

    public void setLotNo(String lotNo) {
        this.lotNo = lotNo == null ? null : lotNo.trim();
    }

    public String getLotDesc() {
        return lotDesc;
    }

    public void setLotDesc(String lotDesc) {
        this.lotDesc = lotDesc == null ? null : lotDesc.trim();
    }

    public Integer getLotQuantity() {
        return lotQuantity;
    }

    public void setLotQuantity(Integer lotQuantity) {
        this.lotQuantity = lotQuantity;
    }

    public Date getReportTime() {
        return reportTime;
    }

    public void setReportTime(Date reportTime) {
        this.reportTime = reportTime;
    }

    public String getReportPlace() {
        return reportPlace;
    }

    public void setReportPlace(String reportPlace) {
        this.reportPlace = reportPlace == null ? null : reportPlace.trim();
    }

    public String getRecognizedUserId() {
        return recognizedUserId;
    }

    public void setRecognizedUserId(String recognizedUserId) {
        this.recognizedUserId = recognizedUserId == null ? null : recognizedUserId.trim();
    }

    public String getRecognizedUserName() {
        return recognizedUserName;
    }

    public void setRecognizedUserName(String recognizedUserName) {
        this.recognizedUserName = recognizedUserName == null ? null : recognizedUserName.trim();
    }

    public String getQualityConfirmId() {
        return qualityConfirmId;
    }

    public void setQualityConfirmId(String qualityConfirmId) {
        this.qualityConfirmId = qualityConfirmId == null ? null : qualityConfirmId.trim();
    }

    public String getQualityConfirmName() {
        return qualityConfirmName;
    }

    public void setQualityConfirmName(String qualityConfirmName) {
        this.qualityConfirmName = qualityConfirmName == null ? null : qualityConfirmName.trim();
    }

    public String getPublishName() {
        return publishName;
    }

    public void setPublishName(String publishName) {
        this.publishName = publishName == null ? null : publishName.trim();
    }

    public String getBadReportImg() {
        return badReportImg;
    }

    public void setBadReportImg(String badReportImg) {
        this.badReportImg = badReportImg == null ? null : badReportImg.trim();
    }

    public String getSupBadReportFile() {
        return supBadReportFile;
    }

    public void setSupBadReportFile(String supBadReportFile) {
        this.supBadReportFile = supBadReportFile == null ? null : supBadReportFile.trim();
    }

    public String getPurBadReportFile() {
        return purBadReportFile;
    }

    public void setPurBadReportFile(String purBadReportFile) {
        this.purBadReportFile = purBadReportFile == null ? null : purBadReportFile.trim();
    }
}