package com.els.base.quality.report.service;

import com.els.base.core.entity.user.User;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;
import com.els.base.quality.report.entity.BadReport;
import com.els.base.quality.report.entity.BadReportExample;

import java.util.List;

public interface BadReportService extends BaseService<BadReport, BadReportExample, String> {

    /**
     * 质量管理-删除不良报告单据
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void deleteObjByIds(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 质量管理-创建不良报告单据
     * @param project
     * @param company
     * @param loginUser
     * @param badReport
     */
    void create(Project project, Company company, User loginUser, BadReport badReport);

    /**
     * 质量管理-供应商发送不良报告单据给采购商(供应商用)
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void sendForSup(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 采购商发送不良报告单据给供应商(采购商用)
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void sendForPur(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 质量管理-采购商作废不良报告单据
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void abolish(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 质量管理-采购商提交审核
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void audit(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 质量管理-采购商驳回资料
     * @param project
     * @param company
     * @param loginUser
     * @param badReportList
     */
    void reject(Project project, Company company, User loginUser, List<BadReport> badReportList);

    /**
     * 质量管理-采购商编辑资料
     * @param project
     * @param company
     * @param loginUser
     * @param badReport
     */
    void editForPur(Project project, Company company, User loginUser, BadReport badReport);

    /**
     * 质量管理-供应商编辑资料
     * @param project
     * @param company
     * @param loginUser
     * @param badReport
     */
    void editForSup(Project project, Company company, User loginUser, BadReport badReport);
}