package com.els.base.quality.report.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.report.dao.BadReportItemMapper;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.entity.BadReportItemExample;
import com.els.base.quality.report.service.BadReportItemService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultBadeReportItemService")
public class BadReportItemServiceImpl implements BadReportItemService {
    @Resource
    protected BadReportItemMapper badReportItemMapper;

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Transactional
    @Override
    public void deleteByExample(BadReportItemExample example) {
        //return badReportItemMapper.deleteByExample(example);
        badReportItemMapper.deleteByExample(example);
    }

    @Cacheable(value="badeReportItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<BadReportItem> queryByBadReportId(String id) {
        Assert.isNotBlank(id,"不良报告的ID不能为空!");
        BadReportItemExample badReportItemExample =new BadReportItemExample();
        badReportItemExample.createCriteria()
                .andBadReportIdEqualTo(id);
        List<BadReportItem> badReportItems = badReportItemMapper.selectByExample(badReportItemExample);
        return badReportItems;
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Override
    public void addObj(BadReportItem t) {
        this.badReportItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.badReportItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Override
    public void modifyObj(BadReportItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.badReportItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="badeReportItem", keyGenerator="redisKeyGenerator")
    @Override
    public BadReportItem queryObjById(String id) {
        return this.badReportItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="badeReportItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<BadReportItem> queryAllObjByExample(BadReportItemExample example) {
        return this.badReportItemMapper.selectByExample(example);
    }

    @Cacheable(value="badeReportItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BadReportItem> queryObjByPage(BadReportItemExample example) {
        PageView<BadReportItem> pageView = example.getPageView();
        pageView.setQueryResult(this.badReportItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Transactional
    @Override
    public void addAll(List<BadReportItem> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.badReportItemMapper.insertSelective(item);
        });
        
    }
}