package com.els.base.quality.report.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.report.entity.BadReport;
import com.els.base.quality.report.entity.BadReportExample;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.service.BadReportItemService;
import com.els.base.quality.report.service.BadReportService;
import com.els.base.quality.utils.BillStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

@Api(value="质量管理-零件不良报告书")
@Controller
@RequestMapping("badReport")
public class BadReportController {

    @Resource
    private BadReportService badReportService;
    @Resource
    private BadReportItemService badReportItemService;

    @ApiOperation(httpMethod="POST", value="质量管理-采购商驳回资料")
    @RequestMapping("service/reject")
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody List<BadReport> badReportList) {
        this.badReportService.reject(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-采购商提交审核")
    @RequestMapping("service/audit")
    @ResponseBody
    public ResponseResult<String> audit(@RequestBody List<BadReport> badReportList) {
        this.badReportService.audit(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-采购商作废不良报告单据")
    @RequestMapping("service/abolish")
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody List<BadReport> badReportList) {
        this.badReportService.abolish(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-发送接口（供应商）")
    @RequestMapping("service/sup/send")
    @ResponseBody
    public ResponseResult<String> sendForSup(@RequestBody List<BadReport> badReportList) {
        this.badReportService.sendForSup(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-发送接口（采购商）")
    @RequestMapping("service/pur/send")
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody List<BadReport> badReportList) {
        this.badReportService.sendForPur(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-创建零件不良报告书")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BadReport badReport) {
        this.badReportService.create(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-编辑零件不良报告书（采购商）")
    @RequestMapping("service/pur/edit")
    @ResponseBody
    public ResponseResult<String> editForPur(@RequestBody BadReport badReport) {
        this.badReportService.editForPur(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="质量管理-编辑零件不良报告书(供应商)")
    @RequestMapping("service/sup/edit")
    @ResponseBody
    public ResponseResult<String> editForSup(@RequestBody BadReport badReport) {
        this.badReportService.editForSup(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    /*@ApiOperation(httpMethod="POST", value="质量管理-删除零件不良报告书")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.badReportService.deleteObjById(id);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="质量管理-删除零件不良报告书")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList,"单据不能为空!");
        this.badReportService.deleteObjByIds(ProjectUtils.getProject(),CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="质量管理-查询零件不良报告书（采购商")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 BadReport", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/pur/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BadReport>> findByPageForPur(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {

        BadReportExample example = new BadReportExample();
        BadReportExample.Criteria criteria = example.createCriteria();
        example.setPageView(new PageView<BadReport>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<BadReport> pageData = this.badReportService.queryObjByPage(example);

        List<BadReport> queryResult = pageData.getQueryResult();
        if(CollectionUtils.isEmpty(queryResult)){
            return ResponseResult.success(pageData);
        }
        for (BadReport badReport : queryResult) {
            String id = badReport.getId();
            List<BadReportItem> list=badReportItemService.queryByBadReportId(id);
            badReport.setBadReportItemList(list);

            //如果是未回签的状态，那么采购商无法看到供应商上传的文件数据
           if( badReport.getBillStatus().intValue()== BillStatusEnum.STATUS_UN_SIGN.getBillStatus().intValue()){
               badReport.setSupBadReportFile(null);
               badReport.setSupRemark(null);
           }

        }

        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="质量管理-查询零件不良报告书（供应商）")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 BadReport", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BadReport>> findByPageForSup(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {

        BadReportExample example = new BadReportExample();
        BadReportExample.Criteria criteria = example.createCriteria();
        example.setPageView(new PageView<BadReport>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andSendStatusEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<BadReport> pageData = this.badReportService.queryObjByPage(example);
        List<BadReport> queryResult = pageData.getQueryResult();
        if(CollectionUtils.isEmpty(queryResult)){
            return ResponseResult.success(pageData);
        }
        for (BadReport badReport : queryResult) {
            String id = badReport.getId();
            List<BadReportItem> list=badReportItemService.queryByBadReportId(id);
            badReport.setBadReportItemList(list);
        }
        return ResponseResult.success(pageData);
    }
}