package com.els.base.quality.report.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.entity.BadReportItemExample;
import com.els.base.quality.report.service.BadReportItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

@Api(value="质量管理-不良报告行数据")
@Controller
@RequestMapping("badReportItem")
public class BadReportItemController {
    @Resource
    protected BadReportItemService badReportItemService;

   /* @ApiOperation(httpMethod="POST", value="创建质量管理-不良报告行数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BadReportItem badReportItem) {
        this.badReportItemService.addObj(badReportItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑质量管理-不良报告行数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BadReportItem badReportItem) {
        if (StringUtils.isBlank(badReportItem.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.badReportItemService.modifyObj(badReportItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除质量管理-不良报告行数据")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.badReportItemService.deleteObjById(id);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="查询质量管理-不良报告行数据")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 BadReportItem", paramType = "body", dataType = "QueryParamWapper" )
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BadReportItem>> findByPage(
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        BadReportItemExample example = new BadReportItemExample();
        example.setPageView(new PageView<BadReportItem>(pageNo, pageSize));
        
        BadReportItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<BadReportItem> pageData = this.badReportItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}