package com.els.base.quality.result.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel(value="质量管理-检查结果兼处理报告")
public class CheckResult implements Serializable {

    /************以下非自动生成***************/

    @ApiModelProperty("不良报告行列表")
    private List<CheckResultItem> checkResultItemList;

    public List<CheckResultItem> getCheckResultItemList() {
        return checkResultItemList;
    }

    public void setCheckResultItemList(List<CheckResultItem> checkResultItemList) {
        this.checkResultItemList = checkResultItemList;
    }

    @ApiModelProperty("尺寸测量数据")
    private List<CheckResultData> checkResultDataList;

    public List<CheckResultData> getCheckResultDataList() {
        return checkResultDataList;
    }

    public void setCheckResultDataList(List<CheckResultData> checkResultDataList) {
        this.checkResultDataList = checkResultDataList;
    }

    /**************************************/

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购商ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商简称")
    private String purCompanyName;

    @ApiModelProperty("采购商全称")
    private String purCompanyFullName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("客户物料编码")
    private String purMaterialCode;

    @ApiModelProperty("客户物料名称")
    private String purMaterialName;

    @ApiModelProperty("客户物料描述")
    private String purMaterialDesc;

    @ApiModelProperty("制单人ID")
    private String purUserId;

    @ApiModelProperty("制单人名称")
    private String purUserName;

    @ApiModelProperty("确认人ID")
    private String confirmUserId;

    @ApiModelProperty("确认人名称")
    private String confirmUserName;

    @ApiModelProperty("承认人ID")
    private String recognizeUserId;

    @ApiModelProperty("承认人名称")
    private String recognizeUserName;

    @ApiModelProperty("生技人ID")
    private String bioTechUserId;

    @ApiModelProperty("生技人名称")
    private String bioTechUserName;

    @ApiModelProperty("质量管理人ID")
    private String qualityTechUserId;

    @ApiModelProperty("质量管理人名称")
    private String qualityTechUserName;

    @ApiModelProperty("供应商用户ID（供应商接收消息的用户ID）")
    private String supUserId;

    @ApiModelProperty("供应商用户姓名（供应商接收消息的用户名称）")
    private String supUserName;

    @ApiModelProperty("采购商备注")
    private String purRemark;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("发送状态（0=未发送，1=已发送）")
    private Integer sendStatus;

    @ApiModelProperty("供应商发送时间")
    private Date purSendTime;

    @ApiModelProperty("采购商资料提交时间")
    private Date purCommitTime;

    @ApiModelProperty("供应商资料提交时间")
    private Date supCommitTime;

    @ApiModelProperty("供应商回签时间")
    private Date supSignTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("(未回签=0, 已回签=1, 已审核=2, 已驳回=3, 已作废=4)")
    private Integer billStatus;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("检查结果单据号")
    private String resultReportNo;

    @ApiModelProperty("抽样方案")
    private String sampling;

    @ApiModelProperty("适用机种")
    private String availableMachine;

    @ApiModelProperty("来料日期")
    private Date incomeMaterialTime;

    @ApiModelProperty("检验批量")
    private String inspectionLot;

    @ApiModelProperty("LOT NO")
    private String lotNo;

    @ApiModelProperty("LOT 描述")
    private String lotDesc;

    @ApiModelProperty("LOT 数量")
    private Integer lotQuantity;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("检查基准")
    private String checkStandard;

    @ApiModelProperty("检查目的")
    private String checkPurpose;

    /*@JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)*/
    @ApiModelProperty("其他测量数据")
    private String checkData;

    @ApiModelProperty("不良内容描述")
    private String defectDesc;

    @ApiModelProperty("处理及不合格评审")
    private String handleWay;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getPurMaterialCode() {
        return purMaterialCode;
    }

    public void setPurMaterialCode(String purMaterialCode) {
        this.purMaterialCode = purMaterialCode == null ? null : purMaterialCode.trim();
    }

    public String getPurMaterialName() {
        return purMaterialName;
    }

    public void setPurMaterialName(String purMaterialName) {
        this.purMaterialName = purMaterialName == null ? null : purMaterialName.trim();
    }

    public String getPurMaterialDesc() {
        return purMaterialDesc;
    }

    public void setPurMaterialDesc(String purMaterialDesc) {
        this.purMaterialDesc = purMaterialDesc == null ? null : purMaterialDesc.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getConfirmUserId() {
        return confirmUserId;
    }

    public void setConfirmUserId(String confirmUserId) {
        this.confirmUserId = confirmUserId == null ? null : confirmUserId.trim();
    }

    public String getConfirmUserName() {
        return confirmUserName;
    }

    public void setConfirmUserName(String confirmUserName) {
        this.confirmUserName = confirmUserName == null ? null : confirmUserName.trim();
    }

    public String getRecognizeUserId() {
        return recognizeUserId;
    }

    public void setRecognizeUserId(String recognizeUserId) {
        this.recognizeUserId = recognizeUserId == null ? null : recognizeUserId.trim();
    }

    public String getRecognizeUserName() {
        return recognizeUserName;
    }

    public void setRecognizeUserName(String recognizeUserName) {
        this.recognizeUserName = recognizeUserName == null ? null : recognizeUserName.trim();
    }

    public String getBioTechUserId() {
        return bioTechUserId;
    }

    public void setBioTechUserId(String bioTechUserId) {
        this.bioTechUserId = bioTechUserId == null ? null : bioTechUserId.trim();
    }

    public String getBioTechUserName() {
        return bioTechUserName;
    }

    public void setBioTechUserName(String bioTechUserName) {
        this.bioTechUserName = bioTechUserName == null ? null : bioTechUserName.trim();
    }

    public String getQualityTechUserId() {
        return qualityTechUserId;
    }

    public void setQualityTechUserId(String qualityTechUserId) {
        this.qualityTechUserId = qualityTechUserId == null ? null : qualityTechUserId.trim();
    }

    public String getQualityTechUserName() {
        return qualityTechUserName;
    }

    public void setQualityTechUserName(String qualityTechUserName) {
        this.qualityTechUserName = qualityTechUserName == null ? null : qualityTechUserName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Date getPurSendTime() {
        return purSendTime;
    }

    public void setPurSendTime(Date purSendTime) {
        this.purSendTime = purSendTime;
    }

    public Date getPurCommitTime() {
        return purCommitTime;
    }

    public void setPurCommitTime(Date purCommitTime) {
        this.purCommitTime = purCommitTime;
    }

    public Date getSupCommitTime() {
        return supCommitTime;
    }

    public void setSupCommitTime(Date supCommitTime) {
        this.supCommitTime = supCommitTime;
    }

    public Date getSupSignTime() {
        return supSignTime;
    }

    public void setSupSignTime(Date supSignTime) {
        this.supSignTime = supSignTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getResultReportNo() {
        return resultReportNo;
    }

    public void setResultReportNo(String resultReportNo) {
        this.resultReportNo = resultReportNo == null ? null : resultReportNo.trim();
    }

    public String getSampling() {
        return sampling;
    }

    public void setSampling(String sampling) {
        this.sampling = sampling == null ? null : sampling.trim();
    }

    public String getAvailableMachine() {
        return availableMachine;
    }

    public void setAvailableMachine(String availableMachine) {
        this.availableMachine = availableMachine == null ? null : availableMachine.trim();
    }

    public Date getIncomeMaterialTime() {
        return incomeMaterialTime;
    }

    public void setIncomeMaterialTime(Date incomeMaterialTime) {
        this.incomeMaterialTime = incomeMaterialTime;
    }

    public String getInspectionLot() {
        return inspectionLot;
    }

    public void setInspectionLot(String inspectionLot) {
        this.inspectionLot = inspectionLot == null ? null : inspectionLot.trim();
    }

    public String getLotNo() {
        return lotNo;
    }

    public void setLotNo(String lotNo) {
        this.lotNo = lotNo == null ? null : lotNo.trim();
    }

    public String getLotDesc() {
        return lotDesc;
    }

    public void setLotDesc(String lotDesc) {
        this.lotDesc = lotDesc == null ? null : lotDesc.trim();
    }

    public Integer getLotQuantity() {
        return lotQuantity;
    }

    public void setLotQuantity(Integer lotQuantity) {
        this.lotQuantity = lotQuantity;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getCheckStandard() {
        return checkStandard;
    }

    public void setCheckStandard(String checkStandard) {
        this.checkStandard = checkStandard == null ? null : checkStandard.trim();
    }

    public String getCheckPurpose() {
        return checkPurpose;
    }

    public void setCheckPurpose(String checkPurpose) {
        this.checkPurpose = checkPurpose == null ? null : checkPurpose.trim();
    }

    public String getCheckData() {
        return checkData;
    }

    public void setCheckData(String checkData) {
        this.checkData = checkData == null ? null : checkData.trim();
    }

    public String getDefectDesc() {
        return defectDesc;
    }

    public void setDefectDesc(String defectDesc) {
        this.defectDesc = defectDesc == null ? null : defectDesc.trim();
    }

    public String getHandleWay() {
        return handleWay;
    }

    public void setHandleWay(String handleWay) {
        this.handleWay = handleWay == null ? null : handleWay.trim();
    }
}