package com.els.base.quality.result.service;

import com.els.base.core.entity.user.User;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;
import com.els.base.quality.result.entity.CheckResult;
import com.els.base.quality.result.entity.CheckResultExample;

import java.util.List;

public interface CheckResultService extends BaseService<CheckResult, CheckResultExample, String> {

    /**
     * 质量管理-新增检查结果兼处理报告
     * @param project
     * @param company
     * @param loginUser
     * @param checkResult
     */
    void create(Project project, Company company, User loginUser, CheckResult checkResult);

    /**
     * 质量管理-编辑检查结果兼处理报告
     * @param project
     * @param company
     * @param loginUser
     * @param checkResult
     */
    void edit(Project project, Company company, User loginUser, CheckResult checkResult);

    /**
     * 质量管理-发送检查结果兼处理报告给供应商
     * @param project
     * @param company
     * @param loginUser
     * @param checkResultList
     */
    void sendForPur(Project project, Company company, User loginUser, List<CheckResult> checkResultList);

    /**
     * 质量管理-删除检查结果兼处理报告
     * @param project
     * @param company
     * @param loginUser
     * @param checkResultList
     */
    void deleteObjByIds(Project project, Company company, User loginUser, List<CheckResult> checkResultList);
}