package com.els.base.quality.result.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.result.dao.CheckResultDataMapper;
import com.els.base.quality.result.entity.CheckResultData;
import com.els.base.quality.result.entity.CheckResultDataExample;
import com.els.base.quality.result.service.CheckResultDataService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCheckResultDataService")
public class CheckResultDataServiceImpl implements CheckResultDataService {
    @Resource
    protected CheckResultDataMapper checkResultDataMapper;

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Transactional
    @Override
    public void deleteByExample(CheckResultDataExample checkResultDataExample) {
       // return checkResultDataMapper.deleteByExample(checkResultDataExample);
        checkResultDataMapper.deleteByExample(checkResultDataExample);
    }

    @Cacheable(value="checkResultData", keyGenerator="redisKeyGenerator")
    @Override
    public List<CheckResultData> queryByCheckResultId(String id) {
        Assert.isNotBlank(id,"ID不能为空");
        CheckResultDataExample checkResultDataExample =new CheckResultDataExample();
        checkResultDataExample.createCriteria().andQualityResultIdEqualTo(id);
        return checkResultDataMapper.selectByExample(checkResultDataExample);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Override
    public void addObj(CheckResultData t) {
        this.checkResultDataMapper.insertSelective(t);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.checkResultDataMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Override
    public void modifyObj(CheckResultData t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.checkResultDataMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="checkResultData", keyGenerator="redisKeyGenerator")
    @Override
    public CheckResultData queryObjById(String id) {
        return this.checkResultDataMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="checkResultData", keyGenerator="redisKeyGenerator")
    @Override
    public List<CheckResultData> queryAllObjByExample(CheckResultDataExample example) {
        return this.checkResultDataMapper.selectByExample(example);
    }

    @Cacheable(value="checkResultData", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CheckResultData> queryObjByPage(CheckResultDataExample example) {
        PageView<CheckResultData> pageView = example.getPageView();
        pageView.setQueryResult(this.checkResultDataMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Override
    public void addAll(List<CheckResultData> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.checkResultDataMapper.insertSelective(item);
        });
        
    }
}