package com.els.base.quality.result.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.quality.result.dao.CheckResultItemMapper;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.entity.CheckResultItemExample;
import com.els.base.quality.result.service.CheckResultItemService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCheckResultItemService")
public class CheckResultItemServiceImpl implements CheckResultItemService {
    @Resource
    protected CheckResultItemMapper checkResultItemMapper;

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    @Override
    public void deleteByExample(CheckResultItemExample checkResultItemExample) {
        this.checkResultItemMapper.deleteByExample(checkResultItemExample);
    }

    @Cacheable(value="checkResultItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<CheckResultItem> queryByCheckResultId(String checkResultId) {
        CheckResultItemExample checkResultItemExample =new CheckResultItemExample();
        checkResultItemExample.createCriteria().andQualityResultIdEqualTo(checkResultId);
        return checkResultItemMapper.selectByExample(checkResultItemExample);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    @Override
    public void addObj(CheckResultItem t) {
        this.checkResultItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.checkResultItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    @Override
    public void modifyObj(CheckResultItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.checkResultItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="checkResultItem", keyGenerator="redisKeyGenerator")
    @Override
    public CheckResultItem queryObjById(String id) {
        return this.checkResultItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="checkResultItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<CheckResultItem> queryAllObjByExample(CheckResultItemExample example) {
        return this.checkResultItemMapper.selectByExample(example);
    }

    @Cacheable(value="checkResultItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CheckResultItem> queryObjByPage(CheckResultItemExample example) {
        PageView<CheckResultItem> pageView = example.getPageView();
        pageView.setQueryResult(this.checkResultItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    @Override
    public void addAll(List<CheckResultItem> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.checkResultItemMapper.insertSelective(item);
        });
        
    }
}