package com.els.base.quality.result.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.report.entity.BadReport;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.service.BadReportItemService;
import com.els.base.quality.result.entity.CheckResult;
import com.els.base.quality.result.entity.CheckResultData;
import com.els.base.quality.result.entity.CheckResultExample;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.service.CheckResultDataService;
import com.els.base.quality.result.service.CheckResultItemService;
import com.els.base.quality.result.service.CheckResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="质量管理-检查结果兼处理报告")
@Controller
@RequestMapping("checkResult")
public class CheckResultController {
    @Resource
    protected CheckResultService checkResultService;
    @Resource
    protected  CheckResultItemService  checkResultItemService;
    @Resource
    protected  CheckResultDataService checkResultDataService;

    @ApiOperation(httpMethod="POST", value="创建质量管理-采购商发送检查结果兼处理报告给供应商")
    @RequestMapping("service/pur/send")
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody List<CheckResult> checkResultList) {
        this.checkResultService.sendForPur(ProjectUtils.getProject(),CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), checkResultList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="创建质量管理-检查结果兼处理报告")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CheckResult checkResult) {
        this.checkResultService.create(ProjectUtils.getProject(),CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), checkResult);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑质量管理-检查结果兼处理报告")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CheckResult checkResult) {
        this.checkResultService.edit(ProjectUtils.getProject(),CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), checkResult);
        return ResponseResult.success();
    }

   /* @ApiOperation(httpMethod="POST", value="删除质量管理-检查结果兼处理报告")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.checkResultService.deleteObjById(id);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="批量删除质量管理-检查结果兼处理报告")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<CheckResult> checkResultList) {
        this.checkResultService.deleteObjByIds(ProjectUtils.getProject(),CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), checkResultList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询质量管理-检查结果兼处理报告（供应方）")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CheckResult", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CheckResult>> findByPageForSup(
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CheckResultExample example = new CheckResultExample();
        example.setPageView(new PageView<CheckResult>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CheckResultExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CheckResult> pageData = this.checkResultService.queryObjByPage(example);
        List<CheckResult> queryResult = pageData.getQueryResult();
        if(CollectionUtils.isEmpty(queryResult)){
            return ResponseResult.success(pageData);
        }
        for (CheckResult checkResult : queryResult) {
            String id = checkResult.getId();
            List<CheckResultItem> list= checkResultItemService.queryByCheckResultId(id);
            checkResult.setCheckResultItemList(list);

            //尺寸测量数据
            List<CheckResultData> checkResultDataList= checkResultDataService.queryByCheckResultId(id);
            checkResult.setCheckResultDataList(checkResultDataList);
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="查询质量管理-检查结果兼处理报告(采购方)")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CheckResult", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/pur/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CheckResult>> findByPageForPur(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {
        CheckResultExample example = new CheckResultExample();
        example.setPageView(new PageView<CheckResult>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CheckResultExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<CheckResult> pageData = this.checkResultService.queryObjByPage(example);

        List<CheckResult> queryResult = pageData.getQueryResult();
        if(CollectionUtils.isEmpty(queryResult)){
            return ResponseResult.success(pageData);
        }
        for (CheckResult checkResult : queryResult) {
            String id = checkResult.getId();

            //检查结果兼处理报告行
            List<CheckResultItem> list= checkResultItemService.queryByCheckResultId(id);
            checkResult.setCheckResultItemList(list);

            //尺寸测量数据
            List<CheckResultData> checkResultDataList= checkResultDataService.queryByCheckResultId(id);
            checkResult.setCheckResultDataList(checkResultDataList);
        }
        return ResponseResult.success(pageData);
    }
}