package com.els.base.quality.result.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.entity.CheckResultItemExample;
import com.els.base.quality.result.service.CheckResultItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="质量管理-检查结果兼处理报告行数据")
@Controller
@RequestMapping("checkResultItem")
public class CheckResultItemController {
    @Resource
    protected CheckResultItemService checkResultItemService;

    @ApiOperation(httpMethod="POST", value="创建质量管理-检查结果兼处理报告行数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CheckResultItem checkResultItem) {
        this.checkResultItemService.addObj(checkResultItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑质量管理-检查结果兼处理报告行数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CheckResultItem checkResultItem) {
        if (StringUtils.isBlank(checkResultItem.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.checkResultItemService.modifyObj(checkResultItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除质量管理-检查结果兼处理报告行数据")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.checkResultItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询质量管理-检查结果兼处理报告行数据")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CheckResultItem", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CheckResultItem>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CheckResultItemExample example = new CheckResultItemExample();
        example.setPageView(new PageView<CheckResultItem>(pageNo, pageSize));
        
        CheckResultItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CheckResultItem> pageData = this.checkResultItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}