/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.annex.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.quality.annex.dao.AnnexItemMapper;
import com.els.base.quality.annex.entity.AnnexItem;
import com.els.base.quality.annex.entity.AnnexItemExample;
import com.els.base.quality.annex.service.AnnexItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAnnexItemService")
public class AnnexItemServiceImpl
implements AnnexItemService {
    @Resource
    protected AnnexItemMapper annexItemMapper;

    @CacheEvict(value={"annexItem"}, allEntries=true)
    public void addObj(AnnexItem t) {
        this.annexItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"annexItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.annexItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"annexItem"}, allEntries=true)
    public void modifyObj(AnnexItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.annexItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"annexItem"}, keyGenerator="redisKeyGenerator")
    public AnnexItem queryObjById(String id) {
        return this.annexItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"annexItem"}, keyGenerator="redisKeyGenerator")
    public List<AnnexItem> queryAllObjByExample(AnnexItemExample example) {
        return this.annexItemMapper.selectByExample(example);
    }

    @Cacheable(value={"annexItem"}, keyGenerator="redisKeyGenerator")
    public PageView<AnnexItem> queryObjByPage(AnnexItemExample example) {
        PageView<AnnexItem> pageView = example.getPageView();
        pageView.setQueryResult(this.annexItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByExample(AnnexItemExample annexItemExample) {
        this.annexItemMapper.deleteByExample(annexItemExample);
    }

    @Transactional
    @CacheEvict(value={"annexItem"}, allEntries=true)
    public void addAll(List<AnnexItem> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.annexItemMapper.insertSelective((AnnexItem)item);
        });
    }
}

