/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.annex.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.annex.dao.AnnexMapper;
import com.els.base.quality.annex.entity.Annex;
import com.els.base.quality.annex.entity.AnnexExample;
import com.els.base.quality.annex.entity.AnnexItem;
import com.els.base.quality.annex.entity.AnnexItemExample;
import com.els.base.quality.annex.im.AnnexImTemplet;
import com.els.base.quality.annex.service.AnnexItemService;
import com.els.base.quality.annex.service.AnnexService;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAnnexService")
public class AnnexServiceImpl
implements AnnexService {
    private static final String IM_CODE = "QUALITY_ANNEX_PUR_SEND";
    @Resource
    protected AnnexMapper annexMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private AnnexItemService annexItemSerivce;

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void insert(String projectId, User loginUser, Company purCompany, Annex annex) {
        Company supCompany = this.companyService.queryCompanyByCode(annex.getSupCompanySrmCode());
        Assert.isNotNull((Object)supCompany, (String)"\u516c\u53f8\u4e0d\u5b58\u5728");
        annex.setSupCompanyFullName(supCompany.getCompanyFullName());
        annex.setSupCompanyId(supCompany.getId());
        annex.setSupCompanyName(supCompany.getCompanyName());
        annex.setSupCompanySapCode(supCompany.getCompanySapCode());
        annex.setCreateBillName(loginUser.getNickName());
        annex.setSendStatus(Constant.NO_INT);
        annex.setDocumentNumber(this.generateCodeService.getNextCode("QUALITY_ANNEX_CONTACTS_NO"));
        annex.setUpdateTime(new Date());
        annex.setBillStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        annex.setIsEnable(Constant.YES_INT);
        annex.setProjectId(projectId);
        annex.setPurCommitTime(new Date());
        annex.setPurCompanyUserId(loginUser.getId());
        annex.setPurCompanyFullName(purCompany.getCompanyFullName());
        annex.setPurCompanyId(purCompany.getId());
        annex.setPurCompanyName(purCompany.getCompanyName());
        annex.setPurCompanySapCode(purCompany.getCompanySapCode());
        annex.setPurCompanySrmCode(purCompany.getCompanyCode());
        this.annexMapper.insertSelective(annex);
        List<AnnexItem> annexItemList = annex.getAnnexItemList();
        for (int i = 0; i < annexItemList.size(); ++i) {
            annexItemList.get(i).setCreateTime(new Date());
            annexItemList.get(i).setProjectId(projectId);
            annexItemList.get(i).setAnnexId(annex.getId());
            annexItemList.get(i).setUpdateTime(new Date());
            annexItemList.get(i).setDocumentNumber(annex.getDocumentNumber());
            annexItemList.get(i).setSortNumber(i);
            this.annexItemSerivce.addObj(annexItemList.get(i));
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void deleteObjByIds(String projectId, List<Annex> annexList) {
        Annex annex2;
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex2 : annexList) {
            Assert.isNotBlank((String)annex2.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex2.getId());
        }
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(projectId).andIsEnableEqualTo(Constant.YES_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        annex2 = new Annex();
        annex2.setIsEnable(Constant.NO_INT);
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.NO_INT);
        this.annexMapper.updateByExampleSelective(annex2, annexExample);
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void invalidObjByIds(String projectId, final User loginUser, List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex : annexList) {
            Assert.isNotBlank((String)annex.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        list.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andBillStatusIn(list).andSendStatusEqualTo(Constant.YES_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u9a73\u56de\u6216\u5df2\u56de\u7b7e\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
        }
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.NO_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
        }
        Annex annex = new Annex();
        annex.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId);
        this.annexMapper.updateByExampleSelective(annex, annexExample);
        final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
        Assert.isNotEmpty(annexs, (String)"\u5355\u636e\u4f5c\u5e9f\u53d1\u9001\u6d88\u606f\u65f6\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Annex annex : annexs) {
                    AnnexImTemplet templ = AnnexServiceImpl.this.constructImInfo(1, "\u5df2\u4f5c\u5e9f", annex);
                    AnnexServiceImpl.this.sendMessagesToSup(loginUser, templ, annex);
                }
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void checkObjByIds(String projectId, final User loginUser, List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex : annexList) {
            Assert.isNotBlank((String)annex.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.YES_INT).andBillStatusIn(list);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u672a\u56de\u7b7e\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838");
        }
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.NO_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u5ba1\u6838");
        }
        Annex annex = new Annex();
        annex.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId);
        this.annexMapper.updateByExampleSelective(annex, annexExample);
        final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
        Assert.isNotEmpty(annexs, (String)"\u5355\u636e\u5ba1\u6279\u53d1\u9001\u6d88\u606f\u65f6\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Annex annex : annexs) {
                    AnnexImTemplet templ = AnnexServiceImpl.this.constructImInfo(1, "\u5df2\u5ba1\u6279", annex);
                    AnnexServiceImpl.this.sendMessagesToSup(loginUser, templ, annex);
                }
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void rejectObjByIds(String projectId, final User loginUser, List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex : annexList) {
            Assert.isNotBlank((String)annex.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        list.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.YES_INT).andBillStatusIn(list);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u5df2\u9a73\u56de\u6216\u5df2\u5ba1\u6838\u6216\u672a\u56de\u7b7e\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u9a73\u56de\u64cd\u4f5c");
        }
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.NO_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u64cd\u4f5c");
        }
        Annex annex = new Annex();
        annex.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId);
        this.annexMapper.updateByExampleSelective(annex, annexExample);
        final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
        Assert.isNotEmpty(annexs, (String)"\u9a73\u56de\u53d1\u9001\u6d88\u606f\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Annex annex : annexs) {
                    AnnexImTemplet templ = AnnexServiceImpl.this.constructImInfo(1, "\u5df2\u9a73\u56de", annex);
                    AnnexServiceImpl.this.sendMessagesToSup(loginUser, templ, annex);
                }
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void purSendToSup(String projectId, final User loginUser, List<Annex> annexList) {
        Annex annex2;
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex2 : annexList) {
            Assert.isNotBlank((String)annex2.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex2.getId());
        }
        for (String annexId : ids) {
            AnnexItemExample annexItemExample = new AnnexItemExample();
            annexItemExample.createCriteria().andAnnexIdEqualTo(annexId);
            List annexItems = this.annexItemSerivce.queryAllObjByExample((IExample)annexItemExample);
            for (AnnexItem annexItem : annexItems) {
                Assert.isNotBlank((String)annexItem.getAppendageType(), (String)"\u6240\u9009\u5355\u636e\u4e2d\u6709\u5355\u636e\u7684\u9644\u4ef6\u7c7b\u578b\u6ca1\u6709\u9009\u62e9");
                Assert.isNotBlank((String)annexItem.getPurUploadName(), (String)"\u6240\u9009\u5355\u636e\u4e2d\u6709\u5355\u636e\u7684\u91c7\u8d2d\u5546\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u53d1\u9001\uff0c\u8c22\u8c22\uff01");
                if (!annexItem.getPurUploadName().equals("[]")) continue;
                throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u6709\u5355\u636e\u7684\u91c7\u8d2d\u5546\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u53d1\u9001\uff0c\u8c22\u8c22\uff01");
            }
        }
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andSendStatusEqualTo(Constant.YES_INT);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u53d1\u9001\u64cd\u4f5c");
        }
        annex2 = new Annex();
        annex2.setSendStatus(Constant.YES_INT);
        annex2.setPurSendTime(new Date());
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId);
        this.annexMapper.updateByExampleSelective(annex2, annexExample);
        final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
        Assert.isNotEmpty(annexs, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Annex annex : annexs) {
                    AnnexImTemplet templet = AnnexServiceImpl.this.constructImInfo(1, "\u53d1\u9001", annex);
                    AnnexServiceImpl.this.sendMessagesToSup(loginUser, templet, annex);
                }
            }
        });
    }

    public void sendMessagesToSup(User loginUser, AnnexImTemplet templet, Annex annex) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(annex.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(annex.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void supSendToPur(String projectId, final User loginUser, List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u9519\u8bef");
        ArrayList<String> ids = new ArrayList<String>();
        for (Annex annex : annexList) {
            Assert.isNotBlank((String)annex.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            ids.add(annex.getId());
        }
        for (String annexId : ids) {
            AnnexItemExample annexItemExample = new AnnexItemExample();
            annexItemExample.createCriteria().andAnnexIdEqualTo(annexId);
            List annexItems = this.annexItemSerivce.queryAllObjByExample((IExample)annexItemExample);
            for (AnnexItem annexItem : annexItems) {
                Assert.isNotBlank((String)annexItem.getSupReplyName(), (String)"\u6240\u9009\u5355\u636e\u4e2d\u6709\u5355\u636e\u7684\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u540e\u518d\u56de\u7b7e\uff0c\u8c22\u8c22\uff01");
                if (!annexItem.getSupReplyName().equals("[]")) continue;
                throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u6709\u5355\u636e\u7684\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u540e\u518d\u56de\u7b7e\uff0c\u8c22\u8c22\uff01");
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        list.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        AnnexExample annexExample = new AnnexExample();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId).andBillStatusIn(list);
        if (this.annexMapper.countByExample(annexExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5df2\u56de\u7b7e\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u9a73\u56de\u6216\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u53d1\u9001\u64cd\u4f5c");
        }
        Annex annex = new Annex();
        annex.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        annex.setSupSendTime(new Date());
        annex.setSupConfirmTime(new Date());
        annexExample.clear();
        annexExample.createCriteria().andIdIn(ids).andProjectIdEqualTo(projectId);
        this.annexMapper.updateByExampleSelective(annex, annexExample);
        final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
        Assert.isNotEmpty(annexs, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Annex annex : annexs) {
                    AnnexImTemplet imTemplet = AnnexServiceImpl.this.constructImInfo(2, "\u56de\u7b7e", annex);
                    AnnexServiceImpl.this.sendMessagesToPur(loginUser, annex, imTemplet);
                }
            }
        });
    }

    public void sendMessagesToPur(User loginUser, Annex annex, AnnexImTemplet imTemplet) {
        Message message = Message.init((Object)imTemplet).setBusinessTypeCode(IM_CODE).setCompanyCode(annex.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(annex.getPurCompanyUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected AnnexImTemplet constructImInfo(int role, String operate, Annex annex) {
        Assert.isNotNull((Object)annex, (String)"\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
        AnnexImTemplet temp = new AnnexImTemplet();
        if (role == 1) {
            temp.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotBlank((String)annex.getSupCompanyName())) {
                temp.setCompanyName(annex.getPurCompanyName());
            } else {
                temp.setCompanyName("");
            }
        } else {
            temp.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotBlank((String)annex.getSupCompanyName())) {
                temp.setCompanyName(annex.getSupCompanyName());
            } else {
                temp.setCompanyName("");
            }
        }
        if (StringUtils.isBlank((String)operate)) {
            throw new CommonException("\u64cd\u4f5c\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u53d1\u9001\u6d88\u606f");
        }
        temp.setOperate(operate);
        temp.setOtherInfo("\u4e86\u65b0\u7684\u9644\u4ef6\u5f80\u6765\u5355\u636e\uff0c\u5355\u636e\u53f7\u4e3a\uff1a");
        temp.setBillList(annex.getDocumentNumber());
        return temp;
    }

    @CacheEvict(value={"annex"}, allEntries=true)
    public void deleteObjById(String id) {
        this.annexMapper.deleteByPrimaryKey(id);
    }

    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void modifyObj(Annex t) {
        if (t == null) {
            throw new CommonException("\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        Company supCompany = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
        Assert.isNotNull((Object)supCompany, (String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        t.setSupCompanyName(supCompany.getCompanyName());
        t.setSupCompanyFullName(supCompany.getCompanyFullName());
        t.setSupCompanyId(supCompany.getId());
        t.setSupCompanySapCode(supCompany.getCompanySapCode());
        t.setUpdateTime(new Date());
        this.annexMapper.updateByPrimaryKeySelective(t);
        List<AnnexItem> annexItemList = t.getAnnexItemList();
        Assert.isNotEmpty(annexItemList, (String)"\u9644\u4ef6\u5f80\u6765\u884c\u9879\u6570\u636e\u4e3a\u7a7a");
        AnnexItemExample annexItemExample = new AnnexItemExample();
        annexItemExample.createCriteria().andAnnexIdEqualTo(t.getId());
        this.annexItemSerivce.deleteByExample(annexItemExample);
        for (int i = 0; i < annexItemList.size(); ++i) {
            annexItemList.get(i).setProjectId(t.getProjectId());
            annexItemList.get(i).setAnnexId(t.getId());
            annexItemList.get(i).setUpdateTime(new Date());
            annexItemList.get(i).setDocumentNumber(t.getDocumentNumber());
            annexItemList.get(i).setSortNumber(i);
            annexItemList.get(i).setSupReplyName("[]");
            this.annexItemSerivce.addObj(annexItemList.get(i));
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void supUpdateInfo(Annex annex) {
        Assert.isNotNull((Object)annex, (String)"\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
        Assert.isNotBlank((String)annex.getId(), (String)"\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        annex.setSupCommitTime(new Date());
        this.annexMapper.updateByPrimaryKeySelective(annex);
        List<AnnexItem> annexItemList = annex.getAnnexItemList();
        Assert.isNotEmpty(annexItemList, (String)"\u5355\u636e\u7684\u884c\u9879\u6570\u636e\u4e3a\u7a7a");
        for (AnnexItem annexItem : annexItemList) {
            annexItem.setUpdateTime(new Date());
            this.annexItemSerivce.modifyObj(annexItem);
        }
    }

    @Cacheable(value={"annex"}, keyGenerator="redisKeyGenerator")
    public Annex queryObjById(String id) {
        return this.annexMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"annex"}, keyGenerator="redisKeyGenerator")
    public List<Annex> queryAllObjByExample(AnnexExample example) {
        return this.annexMapper.selectByExample(example);
    }

    @Cacheable(value={"annex"}, keyGenerator="redisKeyGenerator")
    public PageView<Annex> queryObjByPage(AnnexExample example) {
        PageView<Annex> pageView = example.getPageView();
        pageView.setQueryResult(this.annexMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"annex"}, allEntries=true)
    public void addObj(Annex t) {
        this.annexMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"annex"}, allEntries=true)
    public void addAll(List<Annex> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.annexMapper.insertSelective((Annex)item);
        });
    }

    public void deleteByExample(AnnexExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.annexMapper.deleteByExample(arg0);
    }
}

