/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.annex.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.annex.entity.Annex;
import com.els.base.quality.annex.entity.AnnexExample;
import com.els.base.quality.annex.entity.AnnexItem;
import com.els.base.quality.annex.entity.AnnexItemExample;
import com.els.base.quality.annex.service.AnnexItemService;
import com.els.base.quality.annex.service.AnnexService;
import com.els.base.quality.utils.BillStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
@Controller
@RequestMapping(value={"annex"})
public class AnnexController {
    @Resource
    protected AnnexService annexService;
    @Resource
    protected AnnexItemService annexItemService;

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u521b\u5efa\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Annex annex) {
        Assert.isNotNull((Object)annex, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)annex.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((String)annex.getPurRemarks()) && annex.getPurRemarks().length() > 500) {
            throw new CommonException("\u4f60\u8f93\u5165\u7684\u5907\u6ce8\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        List<AnnexItem> annexItems = annex.getAnnexItemList();
        for (AnnexItem annexItem : annexItems) {
            if (StringUtils.isNotBlank((String)annexItem.getItemPurRemarks()) && annexItem.getItemPurRemarks().length() > 500) {
                throw new CommonException("\u4f60\u8f93\u5165\u7684\u91c7\u8d2d\u65b9\u5907\u6ce8\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6");
            }
            if (!StringUtils.isNotBlank((String)annexItem.getPurUploadName()) || annexItem.getPurUploadName().length() <= 3500) continue;
            throw new CommonException("\u4f60\u4e0a\u4f20\u7684\u9644\u4ef6\u6570\u8d85\u6807\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        this.annexService.insert(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany(), annex);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u5220\u9664\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.deleteObjByIds(ProjectUtils.getProjectId(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u4f5c\u5e9f\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/invalidByIds"})
    @ResponseBody
    public ResponseResult<String> invalidByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.invalidObjByIds(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u5ba1\u6838\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/checkByIds"})
    @ResponseBody
    public ResponseResult<String> checkByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.checkObjByIds(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u9a73\u56de\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/rejectByIds"})
    @ResponseBody
    public ResponseResult<String> rejectByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.rejectObjByIds(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u53d1\u9001\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/pursendByIds"})
    @ResponseBody
    public ResponseResult<String> pursendByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.purSendToSup(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u53d1\u9001\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/supsendByIds"})
    @ResponseBody
    public ResponseResult<String> supsendByIds(@RequestBody(required=true) List<Annex> annexList) {
        Assert.isNotEmpty(annexList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.annexService.supSendToPur(ProjectUtils.getProjectId(), (User)SpringSecurityUtils.getLoginUser(), annexList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Annex", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Annex>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AnnexExample example = new AnnexExample();
        example.setPageView((PageView<Annex>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_BILL_TIME DESC");
        AnnexExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.annexService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Annex", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Annex>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AnnexExample example = new AnnexExample();
        example.setPageView((PageView<Annex>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_BILL_TIME DESC");
        AnnexExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.annexService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u770b\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/pur/findAnnexById"})
    @ResponseBody
    public ResponseResult<Annex> purFindAnnexById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Annex annex = (Annex)this.annexService.queryObjById(id);
        Assert.isNotNull((Object)annex, (String)"\u6839\u636eID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        AnnexItemExample annexItemExample = new AnnexItemExample();
        annexItemExample.setOrderByClause("SORT_NUMBER ASC");
        annexItemExample.createCriteria().andAnnexIdEqualTo(id);
        List annexItemList = this.annexItemService.queryAllObjByExample((IExample)annexItemExample);
        if (annex.getBillStatus().equals(BillStatusEnum.STATUS_UN_SIGN.getBillStatus())) {
            for (AnnexItem annexItem : annexItemList) {
                annexItem.setItemSupRemarks(null);
                annexItem.setSupReplyName(null);
            }
        }
        annex.setAnnexItemList(annexItemList);
        return ResponseResult.success((Object)annex);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u770b\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/sup/findAnnexById"})
    @ResponseBody
    public ResponseResult<Annex> supFindAnnexById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Annex annex = (Annex)this.annexService.queryObjById(id);
        Assert.isNotNull((Object)annex, (String)"\u6839\u636eID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        AnnexItemExample annexItemExample = new AnnexItemExample();
        annexItemExample.setOrderByClause("SORT_NUMBER ASC");
        annexItemExample.createCriteria().andAnnexIdEqualTo(id);
        List annexItemList = this.annexItemService.queryAllObjByExample((IExample)annexItemExample);
        annex.setAnnexItemList(annexItemList);
        return ResponseResult.success((Object)annex);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u7f16\u8f91\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/pur/edit"})
    @ResponseBody
    public ResponseResult<String> purEdit(@RequestBody Annex annex) {
        if (StringUtils.isBlank((String)annex.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)annex.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((String)annex.getPurRemarks()) && annex.getPurRemarks().length() > 500) {
            throw new CommonException("\u4f60\u8f93\u5165\u7684\u5907\u6ce8\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        List<AnnexItem> annexItems = annex.getAnnexItemList();
        for (AnnexItem annexItem : annexItems) {
            if (StringUtils.isNotBlank((String)annexItem.getItemPurRemarks()) && annexItem.getItemPurRemarks().length() > 500) {
                throw new CommonException("\u4f60\u8f93\u5165\u7684\u91c7\u8d2d\u65b9\u5907\u6ce8\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6");
            }
            if (!StringUtils.isNotBlank((String)annexItem.getPurUploadName()) || annexItem.getPurUploadName().length() <= 3500) continue;
            throw new CommonException("\u4f60\u4e0a\u4f20\u7684\u9644\u4ef6\u6570\u8d85\u6807\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (annex.getSendStatus() == Constant.YES_INT) {
            throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001\uff0c\u4e0d\u80fd\u518d\u4fee\u6539");
        }
        this.annexService.modifyObj(annex);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u7f16\u8f91\u8d28\u91cf\u7ba1\u7406\u2014\u9644\u4ef6\u5f80\u6765\u8868")
    @RequestMapping(value={"service/sup/edit"})
    @ResponseBody
    public ResponseResult<String> supEdit(@RequestBody Annex annex) {
        if (StringUtils.isBlank((String)annex.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        List<AnnexItem> annexItems = annex.getAnnexItemList();
        for (AnnexItem annexItem : annexItems) {
            if (StringUtils.isNotBlank((String)annexItem.getItemSupRemarks()) && annexItem.getItemSupRemarks().length() > 500) {
                throw new CommonException("\u4f60\u8f93\u5165\u7684\u4f9b\u5e94\u65b9\u5907\u6ce8\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6");
            }
            if (!StringUtils.isNotBlank((String)annexItem.getSupReplyName()) || annexItem.getSupReplyName().length() <= 3500) continue;
            throw new CommonException("\u4f60\u4e0a\u4f20\u7684\u9644\u4ef6\u6570\u8d85\u6807\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (annex.getBillStatus() != BillStatusEnum.STATUS_UN_SIGN.getBillStatus()) {
            throw new CommonException("\u5355\u636e\u4e0d\u662f\u672a\u56de\u7b7e\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u4fee\u6539");
        }
        this.annexService.supUpdateInfo(annex);
        return ResponseResult.success();
    }
}

