/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.appealform.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.appealform.entity.AppealForm;
import com.els.base.quality.appealform.entity.AppealFormExample;
import com.els.base.quality.appealform.service.AppealFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7533\u8bc9\u5355")
@Controller
@RequestMapping(value={"appealForm"})
public class AppealFormController {
    @Resource
    protected AppealFormService appealFormService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7533\u8bc9\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AppealForm appealForm) {
        this.appealFormService.addObj(appealForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7533\u8bc9\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AppealForm appealForm) {
        Assert.isNotBlank((String)appealForm.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.appealFormService.modifyObj(appealForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7533\u8bc9\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.appealFormService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u4e2a\u7533\u8bc9\u5355")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<AppealForm> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        AppealForm form = (AppealForm)this.appealFormService.queryObjById(id);
        return ResponseResult.success((Object)form);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7533\u8bc9\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 AppealForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<AppealForm>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AppealFormExample example = new AppealFormExample();
        example.setPageView((PageView<AppealForm>)new PageView(pageNo, pageSize));
        AppealFormExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.appealFormService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u7533\u8bc9\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 AppealForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerAppealByPage"})
    @ResponseBody
    public ResponseResult<PageView<AppealForm>> findSupplerAppealByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AppealFormExample example = new AppealFormExample();
        example.setPageView((PageView<AppealForm>)new PageView(pageNo, pageSize));
        AppealFormExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.appealFormService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u7ed9\u91c7\u8d2d\u5458")
    @RequestMapping(value={"service/pushToBuyer"})
    @ResponseBody
    public ResponseResult<String> pushToBuyer(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e!");
        }
        this.appealFormService.pushToBuyer(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5458\u63a5\u53d7")
    @RequestMapping(value={"service/acceptToBuyer"})
    @ResponseBody
    public ResponseResult<String> acceptToBuyer(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e!");
        }
        this.appealFormService.acceptToBuyer(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5458\u62d2\u7edd")
    @RequestMapping(value={"service/refuseToSuppler"})
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e!");
        }
        for (AppealForm item : list) {
            if (!StringUtils.isEmpty((String)item.getFeedbackDepartmentOpinion())) continue;
            throw new CommonException("\u7533\u8bc9\u5355\uff1a" + item.getBillNo() + "\u53cd\u9988\u90e8\u95e8\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u62d2\u7edd!");
        }
        this.appealFormService.refuseToSuppler(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }
}

