/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.bill.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.bill.dao.UnQualifiedBillMapper;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.bill.entity.UnQualifiedBillExample;
import com.els.base.quality.bill.service.UnQualifiedBillService;
import com.els.base.quality.bill.util.UnBillStatusEnum;
import com.els.base.quality.inspection.entity.Inspection;
import com.els.base.quality.inspection.entity.UnQualifiedBatch;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultUnQualifiedBillService")
public class UnQualifiedBillServiceImpl
implements UnQualifiedBillService {
    private Logger logger = LoggerFactory.getLogger(UnQualifiedBillServiceImpl.class);
    @Resource
    protected UnQualifiedBillMapper unQualifiedBillMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void addObj(UnQualifiedBill t) {
        this.unQualifiedBillMapper.insertSelective(t);
    }

    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void deleteObjById(String id) {
        this.unQualifiedBillMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void modifyObj(UnQualifiedBill t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.unQualifiedBillMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"unQualifiedBill"}, keyGenerator="redisKeyGenerator")
    public UnQualifiedBill queryObjById(String id) {
        return this.unQualifiedBillMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"unQualifiedBill"}, keyGenerator="redisKeyGenerator")
    public List<UnQualifiedBill> queryAllObjByExample(UnQualifiedBillExample example) {
        return this.unQualifiedBillMapper.selectByExample(example);
    }

    @Cacheable(value={"unQualifiedBill"}, keyGenerator="redisKeyGenerator")
    public PageView<UnQualifiedBill> queryObjByPage(UnQualifiedBillExample example) {
        PageView<UnQualifiedBill> pageView = example.getPageView();
        pageView.setQueryResult(this.unQualifiedBillMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void createUnQualifiedBill(UnQualifiedBatch entity) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(entity.getSupCompanySapCode());
        List supCompanyList = this.companyService.queryAllObjByExample((IExample)supompanyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            supCompany = (Company)supCompanyList.get(0);
        }
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("APPEAL_FORM_NO");
        UnQualifiedBill billentity = new UnQualifiedBill();
        billentity.setProjectId(projectId);
        billentity.setCompanyId(companyId);
        billentity.setIsEnable(Constant.YES_INT);
        billentity.setBillStatus(UnBillStatusEnum.STATUS_NEW.getValue());
        billentity.setMaterialCode(entity.getMaterialCode());
        billentity.setMaterialName(entity.getMaterialName());
        billentity.setMaterialSpecification(entity.getMaterialSpecification());
        billentity.setSupCompanyCode(supCompany.getCompanyCode());
        billentity.setSupCompanyName(entity.getSupCompanyName());
        billentity.setSupCompanySapCode(entity.getSupCompanySapCode());
        billentity.setMapNo(entity.getAttribute1());
        CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
        CompanyPurRefExample.Criteria companyPurRefCriteria = companyPurRefExample.createCriteria();
        companyPurRefCriteria.andProjectIdEqualTo(projectId);
        companyPurRefCriteria.andSupCompanyIdEqualTo(supCompany.getId());
        companyPurRefCriteria.andPurCompanyIdEqualTo(companyId);
        List list = this.companyPurRefService.queryAllObjByExample((IExample)companyPurRefExample);
        if (list.isEmpty()) {
            throw new CommonException("\u4f9b\u5e94\u5546" + supCompany.getCompanyName() + "\u5c1a\u672a\u7ef4\u62a4\u5bf9\u5e94\u7684\u91c7\u8d2d\u5458\uff0c\u65e0\u6cd5\u751f\u6210\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355!");
        }
        billentity.setTrackUserid(((CompanyPurRef)list.get(0)).getUserId());
        UserExample example = new UserExample();
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(((CompanyPurRef)list.get(0)).getUserId());
        List userList = this.userService.queryAllObjByExample((IExample)example);
        billentity.setTrackUsername(((User)userList.get(0)).getNickName());
        billentity.setBillDate(entity.getCreateTime());
        billentity.setDisqualification(entity.getShortTextCode() + " " + entity.getProjectText());
        billentity.setDisqualificationCategory(entity.getProductCategory());
        billentity.setSourceId(entity.getId());
        billentity.setSourceNo(entity.getInspectionLot());
        billentity.setSourceType("UnQualifiedBatch");
        billentity.setInspector(entity.getInspector());
        Date nowDate = new Date();
        billentity.setUpdateTime(nowDate);
        billentity.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        billentity.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        billentity.setCreateTime(nowDate);
        billentity.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        billentity.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        this.addObj(billentity);
    }

    @Override
    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void createUnQualifiedBill(Inspection entity) {
        this.logger.info("--\u5f00\u59cb\u521b\u5efa\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355");
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        this.logger.info("--\u67e5\u627e\u516c\u53f8");
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        this.logger.info("--\u67e5\u627e\u4f9b\u5e94\u5546\u6570\u636e");
        String supCompanySapCode = entity.getSupCompanySapCode().replaceAll("^0+", "");
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode);
        List supCompanyList = this.companyService.queryAllObjByExample((IExample)supompanyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            if (companyList.size() <= 0) {
                throw new CommonException("\u4f9b\u5e94\u5546\u4ee3\u7801\u4e3a" + supCompanySapCode + "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u751f\u6210\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355!");
            }
            supCompany = (Company)supCompanyList.get(0);
        }
        this.logger.info("--\u751f\u6210\u5355\u636e\u6d41\u6c34\u53f7 UNQUALIFIED_BILL_NO");
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("UNQUALIFIED_BILL_NO");
        UnQualifiedBill billentity = new UnQualifiedBill();
        billentity.setBillNo(billNo);
        billentity.setProjectId(projectId);
        billentity.setCompanyId(companyId);
        billentity.setIsEnable(Constant.YES_INT);
        billentity.setBillStatus(UnBillStatusEnum.STATUS_NEW.getValue());
        billentity.setMaterialCode(entity.getMaterialCode());
        billentity.setMaterialName(entity.getMaterialName());
        billentity.setMaterialSpecification(entity.getMaterialSpecification());
        billentity.setSupCompanyCode(supCompany.getCompanyCode());
        billentity.setSupCompanyName(entity.getSupCompanyName());
        billentity.setSupCompanySapCode(supCompanySapCode);
        billentity.setMapNo(entity.getMapNo());
        this.logger.info("--\u627e\u5230\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u91c7\u8d2d\u5458");
        billentity.setBillDate(entity.getCreateTime());
        billentity.setUdDate(entity.getUdDate());
        billentity.setDisqualification(entity.getDefectCodeText());
        billentity.setSourceId(entity.getId());
        billentity.setSourceNo(entity.getInspectionLot());
        billentity.setSourceType("UnQualifiedBatch");
        billentity.setInspector(entity.getInspector());
        billentity.setInspectionLot(entity.getInspectionLot());
        billentity.setFactoryCode(entity.getFactoryCode());
        billentity.setFactoryName(entity.getFactoryName());
        billentity.setActLotQty(entity.getActLotQty());
        billentity.setDefectCodeShortText(entity.getDefectCodeShortText());
        billentity.setDefectCodeText(entity.getDefectCodeText());
        billentity.setCheckDescription(entity.getInspectionDescription());
        billentity.setUdCodeShortText(entity.getUdCodeShortTxt());
        billentity.setUdDate(entity.getUdDate());
        billentity.setResponsibility(entity.getResponsibility());
        billentity.setProductCategory(entity.getProductCategory());
        billentity.setDecisionLengthText(entity.getDecisionLengthText());
        billentity.setInspectionBatchDescription(entity.getInspectionBatchDescription());
        billentity.setPurchaseCategories(entity.getPurchaseCategories());
        billentity.setNeedFollowNo(entity.getNeedFollowNo());
        billentity.setQuantity(entity.getFreezeInventory());
        Date nowDate = new Date();
        billentity.setUpdateTime(nowDate);
        billentity.setUpdateUserId(entity.getInspector());
        billentity.setUpdateUserName(entity.getInspector());
        billentity.setCreateTime(nowDate);
        billentity.setCreateUserId(entity.getInspector());
        billentity.setCreateUserName(entity.getInspector());
        this.logger.info("--\u5355\u636e\u65b0\u589e");
        this.addObj(billentity);
    }

    @Override
    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void modifyList(List<UnQualifiedBill> list) {
        Date nowDate = new Date();
        for (UnQualifiedBill item : list) {
            item.setUpdateTime(nowDate);
            item.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            item.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(item);
        }
    }

    @Override
    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void addAttachment(User user, UnQualifiedBill bill) {
        Date nowDate = new Date();
        bill.setUpdateTime(nowDate);
        bill.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        bill.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.modifyObj(bill);
    }

    @Override
    @Cacheable(value={"unQualifiedBill"}, keyGenerator="redisKeyGenerator")
    public int countByExample(UnQualifiedBillExample unQualifiedBillExample) {
        int countByExample = this.unQualifiedBillMapper.countByExample(unQualifiedBillExample);
        return countByExample;
    }

    @Transactional
    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void addAll(List<UnQualifiedBill> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.unQualifiedBillMapper.insertSelective((UnQualifiedBill)item);
        });
    }

    @CacheEvict(value={"unQualifiedBill"}, allEntries=true)
    public void deleteByExample(UnQualifiedBillExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.unQualifiedBillMapper.deleteByExample(arg0);
    }

    @Override
    public void outTimeReply() {
        List<UnQualifiedBill> unQualifiedBillList = this.unQualifiedBillMapper.selectOutTimeReplyData();
        Map<String, List<UnQualifiedBill>> listMap = unQualifiedBillList.stream().collect(Collectors.groupingBy(UnQualifiedBill::getSupCompanySapCode));
        for (Map.Entry<String, List<UnQualifiedBill>> entry : listMap.entrySet()) {
            List<UnQualifiedBill> value = entry.getValue();
            List billNoList = value.stream().map(UnQualifiedBill::getBillNo).collect(Collectors.toList());
            String billNo = StringUtils.join(billNoList, (String)",");
            CompanyExample example = new CompanyExample();
            example.createCriteria().andCompanySapCodeEqualTo(entry.getKey());
            List companyList = this.companyService.queryAllObjByExample((IExample)example);
            User user = this.companyUserRefService.queryMainUserOfCompany(((Company)companyList.get(0)).getId());
            UnQualifiedBill unQualifiedBill = new UnQualifiedBill();
            unQualifiedBill.setBillNo(billNo);
            unQualifiedBill.setSupUserId(user.getId());
            unQualifiedBill.setSupCompanyCode(((Company)companyList.get(0)).getCompanyCode());
            Message message = Message.init((Object)unQualifiedBill).setCompanyCode(entry.getKey()).setSenderId("1").addReceiverId(user.getId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(UnBillStatusEnum.UN_BILL_OUT_TIME_REPLY.getDesc());
            MessageSendUtils.sendMessage((Message)message);
        }
    }
}

