/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.bill.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.bill.entity.UnQualifiedBillExample;
import com.els.base.quality.bill.service.UnQualifiedBillService;
import com.els.base.quality.bill.util.UnBillStatusEnum;
import com.els.base.quality.concession.service.ConcessionApplyService;
import com.els.base.quality.concession.utils.UnApplyStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
@Controller
@RequestMapping(value={"unQualifiedBill"})
public class UnQualifiedBillController {
    private Logger logger = LoggerFactory.getLogger(UnQualifiedBillController.class);
    @Resource
    protected UnQualifiedBillService unQualifiedBillService;
    @Resource
    protected ConcessionApplyService concessionApplyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UnQualifiedBill unQualifiedBill) {
        this.unQualifiedBillService.addObj(unQualifiedBill);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UnQualifiedBill unQualifiedBill) {
        Assert.isNotBlank((String)unQualifiedBill.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.unQualifiedBillService.modifyObj(unQualifiedBill);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        UnQualifiedBill entity = (UnQualifiedBill)this.unQualifiedBillService.queryObjById(id);
        if (entity != null) {
            if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                this.unQualifiedBillService.deleteObjById(id);
            } else {
                throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5355\u636e!");
        }
        for (String id : list) {
            UnQualifiedBill entity = (UnQualifiedBill)this.unQualifiedBillService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                this.unQualifiedBillService.deleteObjById(id);
                continue;
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 UnQualifiedBill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<UnQualifiedBill>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        UnQualifiedBillExample example = new UnQualifiedBillExample();
        example.setPageView((PageView<UnQualifiedBill>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" UPDATE_TIME DESC");
        UnQualifiedBillExample.Criteria criteria = example.createCriteria();
        ArrayList<String> companyCodeArray = new ArrayList<String>();
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.unQualifiedBillService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9f\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/invalidByIds"})
    @ResponseBody
    public ResponseResult<String> invalidByIds(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5355\u636e!");
        }
        ArrayList<UnQualifiedBill> billarray = new ArrayList<UnQualifiedBill>();
        for (String id : list) {
            UnQualifiedBill entity = (UnQualifiedBill)this.unQualifiedBillService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_INVALID.getValue()) || entity.getBillStatus().equals(UnBillStatusEnum.STATUS_APPROVE.getValue()) || entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                throw new CommonException("\u6240\u9009\u8bb0\u5f55\u5305\u542b\u672a\u53d1\u9001\u6216\u91c7\u8d2d\u786e\u8ba4\u6216\u4f5c\u5e9f\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4f5c\u5e9f!");
            }
            entity.setBillStatus(UnBillStatusEnum.STATUS_INVALID.getValue());
            entity.setIsEnable(Constant.NO_INT);
            billarray.add(entity);
        }
        this.unQualifiedBillService.modifyList(billarray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5230\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pushedToSuppler"})
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u5355\u636e");
        }
        this.logger.info("--pushedToSuppler");
        User user = SpringSecurityUtils.getLoginUser();
        this.logger.info("--\u5f00\u59cb\u5faa\u73af\u5904\u7406");
        for (UnQualifiedBill item : list) {
            this.logger.info("--\u72b6\u6001\u5224\u65ad");
            if (Constant.YES_INT.equals(item.getSendStatus())) {
                throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u5df2\u7ecf\u53d1\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u9001!");
            }
            this.logger.info("--\u6574\u6539\u65b9\u5f0f\u5224\u65ad");
            if (StringUtils.isEmpty((String)item.getRectificationType())) {
                throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u5904\u7406\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u5e03!");
            }
            if (null == item.getRequestResponseTime()) {
                throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u8981\u6c42\u4f9b\u65b9\u56de\u590d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u5e03!");
            }
            this.logger.info("--\u8bbe\u7f6e\u4fee\u6539\u4fe1\u606f");
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_PUBLIC.getValue());
            item.setSendStatus(Constant.YES_INT);
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 UnQualifiedBill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupBillByPage"})
    @ResponseBody
    public ResponseResult<PageView<UnQualifiedBill>> findSupBillByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        UnQualifiedBillExample example = new UnQualifiedBillExample();
        example.setPageView((PageView<UnQualifiedBill>)new PageView(pageNo, pageSize));
        UnQualifiedBillExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        criteria.andBillStatusNotEqualTo(UnApplyStatusEnum.STATUS_NEW.getValue());
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.unQualifiedBillService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u4e0d\u5408\u683c\u4ea7\u54c1\u5904\u7f6e\u5355\u8d85\u671f\u672a\u56de\u590d\u9884\u8b66")
    @RequestMapping(value={"service/outTimeReply"})
    @ResponseBody
    public ResponseResult<String> outTimeReply() {
        this.unQualifiedBillService.outTimeReply();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355")
    @RequestMapping(value={"service/supplierAcceptBill"})
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u786e\u8ba4\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            if (StringUtils.isEmpty((String)item.getCauseAnalysis())) {
                throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u539f\u56e0\u5206\u6790\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            if (StringUtils.isEmpty((String)item.getCorrectiveAnalysis())) {
                throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u7ea0\u6b63\u63aa\u65bd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            Assert.isNotNull((Object)item.getCompletionDate(), (String)("\u5355\u636e\uff1a" + item.getBillNo() + "\u5b8c\u6210\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!"));
            item.setSupplierResponseTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/acceptToSuppler"})
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u5355\u636e");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_APPROVE.getValue());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62d2\u7edd\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/refuseToSuppler"})
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u5355\u636e");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            if (StringUtils.isEmpty((String)item.getPurchasingReply())) {
                // empty if block
            }
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_REFUSED.getValue());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u8d77\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/initiateConcession"})
    @ResponseBody
    public ResponseResult<String> initiateConcession(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u9700\u8981\u53d1\u8d77\u8ba9\u6b65\u63a5\u6536\u7684\u5355\u636e\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            if (item.getBillStatus().equals(UnBillStatusEnum.STATUS_PUBLIC.getValue()) || item.getBillStatus().equals(UnBillStatusEnum.STATUS_REFUSED.getValue())) {
                item.setUpdateTime(new Date());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setSendTime(new Date());
                item.setBillStatus(UnBillStatusEnum.STATUS_APPLYFOR.getValue());
                continue;
            }
            throw new CommonException("\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\uff1a" + item.getBillNo() + "\u975e\u53d1\u5e03\u3001\u91c7\u8d2d\u62d2\u7edd\u72b6\u6001\uff0c\u65e0\u6cd5\u53d1\u8d77\u8ba9\u6b65\u7533\u8bf7!");
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody UnQualifiedBill bill) {
        if (StringUtils.isBlank((String)bill.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)bill.getAttachment())) {
            throw new CommonException("\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.unQualifiedBillService.addAttachment((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), bill);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadReportExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(@ApiParam(value="\u4e0d\u826f\u54c1\u5904\u7f6e\u5355id", defaultValue="") @RequestParam(defaultValue="") String idArray, HttpServletResponse response) {
        try {
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u53c2\u6570" + idArray);
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            if (StringUtils.isNotBlank((String)idArray)) {
                example.createCriteria().andIdIn((List)Arrays.asList(idArray.split(",")));
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List unQualifiedBillArray = this.unQualifiedBillService.queryAllObjByExample((IExample)example);
            block10: for (UnQualifiedBill unQualifiedBill : unQualifiedBillArray) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1: {
                        unQualifiedBill.setAttribute1("\u65b0\u589e");
                        continue block10;
                    }
                    case 2: {
                        unQualifiedBill.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block10;
                    }
                    case 3: {
                        unQualifiedBill.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block10;
                    }
                    case 4: {
                        unQualifiedBill.setAttribute1("\u8ba9\u6b65\u7533\u8bf7");
                        continue block10;
                    }
                    case 5: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u540c\u610f");
                        continue block10;
                    }
                    case 6: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block10;
                    }
                }
                unQualifiedBill.setAttribute1("\u4f5c\u5e9f");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u4e0d\u826f\u54c1\u5904\u7f6e\u5355" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355Excel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u53f7", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u68c0\u6279\u6b21\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u90e8\u95e8", (String)"responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ddf\u8e2a\u4eba", (String)"trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)unQualifiedBillArray, (String)"\u4e0d\u826f\u54c1\u5904\u7f6e\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillArray = null;
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u91c7\u8d2d\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/purdownloadReportExcel"})
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            example.setOrderByClause(" UPDATE_TIME DESC");
            UnQualifiedBillExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            ArrayList<String> companyCodeArray = new ArrayList<String>();
            List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
            if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                for (Company company : companyList) {
                    companyCodeArray.add(company.getCompanySapCode());
                }
                criteria.andSupCompanySapCodeIn(companyCodeArray);
            }
            List unQualifiedBillList = this.unQualifiedBillService.queryAllObjByExample((IExample)example);
            block11: for (UnQualifiedBill unQualifiedBill : unQualifiedBillList) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1: {
                        unQualifiedBill.setAttribute1("\u65b0\u589e");
                        continue block11;
                    }
                    case 2: {
                        unQualifiedBill.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block11;
                    }
                    case 3: {
                        unQualifiedBill.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block11;
                    }
                    case 4: {
                        unQualifiedBill.setAttribute1("\u8ba9\u6b65\u7533\u8bf7");
                        continue block11;
                    }
                    case 5: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u540c\u610f");
                        continue block11;
                    }
                    case 6: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block11;
                    }
                }
                unQualifiedBill.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + unQualifiedBillList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355Excel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u53f7", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u68c0\u6279\u6b21\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u90e8\u95e8", (String)"responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ddf\u8e2a\u4eba", (String)"trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355Excel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)unQualifiedBillList, (String)"\u4e0d\u826f\u54c1\u5904\u7f6e\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillList = null;
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/supdownloadReportExcel"})
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            UnQualifiedBillExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            criteria.andSendStatusEqualTo(Constant.YES_INT);
            criteria.andBillStatusNotEqualTo(UnApplyStatusEnum.STATUS_NEW.getValue());
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
            example.setOrderByClause(" UPDATE_TIME DESC");
            List unQualifiedBillList = this.unQualifiedBillService.queryAllObjByExample((IExample)example);
            block10: for (UnQualifiedBill unQualifiedBill : unQualifiedBillList) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1: {
                        unQualifiedBill.setAttribute1("\u65b0\u589e");
                        continue block10;
                    }
                    case 2: {
                        unQualifiedBill.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block10;
                    }
                    case 3: {
                        unQualifiedBill.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block10;
                    }
                    case 4: {
                        unQualifiedBill.setAttribute1("\u8ba9\u6b65\u7533\u8bf7");
                        continue block10;
                    }
                    case 5: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u540c\u610f");
                        continue block10;
                    }
                    case 6: {
                        unQualifiedBill.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block10;
                    }
                }
                unQualifiedBill.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + unQualifiedBillList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355Excel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u53f7", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u68c0\u6279\u6b21\u53f7", (String)"sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u90e8\u95e8", (String)"responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ddf\u8e2a\u4eba", (String)"trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355Excel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)unQualifiedBillList, (String)"\u4e0d\u826f\u54c1\u5904\u7f6e\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillList = null;
            this.logger.info("\u4e0d\u826f\u54c1\u5904\u7f6e\u5355\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

