/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.claims.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.quality.appealform.service.AppealFormService;
import com.els.base.quality.claims.dao.ClaimsMapper;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.entity.ClaimsExample;
import com.els.base.quality.claims.service.ClaimsService;
import com.els.base.quality.claims.utils.ClaimsStatusEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultClaimsService")
public class ClaimsServiceImpl
implements ClaimsService {
    @Resource
    protected ClaimsMapper claimsMapper;
    @Resource
    protected AppealFormService appealFormService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected MaterialService materialService;

    @CacheEvict(value={"claims"}, allEntries=true)
    public void addObj(Claims t) {
        this.claimsMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"claims"}, allEntries=true)
    public void addAll(List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.claimsMapper.insertBatch(list);
    }

    @CacheEvict(value={"claims"}, allEntries=true)
    public void deleteObjById(String id) {
        this.claimsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"claims"}, allEntries=true)
    public void deleteByExample(ClaimsExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.claimsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"claims"}, allEntries=true)
    public void modifyObj(Claims t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.claimsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"claims"}, keyGenerator="redisKeyGenerator")
    public Claims queryObjById(String id) {
        return this.claimsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"claims"}, keyGenerator="redisKeyGenerator")
    public List<Claims> queryAllObjByExample(ClaimsExample example) {
        return this.claimsMapper.selectByExample(example);
    }

    @Cacheable(value={"claims"}, keyGenerator="redisKeyGenerator")
    public PageView<Claims> queryObjByPage(ClaimsExample example) {
        PageView<Claims> pageView = example.getPageView();
        pageView.setQueryResult(this.claimsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void importClaims(String projectId, String companyId, User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims claimsItem : list) {
            try {
                GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
                String billNo = generateCodeService.getNextCode("CLAIMS_FORM_NO");
                claimsItem.setClaimsNo(billNo);
                claimsItem.setProjectId(projectId);
                claimsItem.setCompanyId(companyId);
                claimsItem.setCreateUserId(user.getId());
                claimsItem.setUpdateUserId(user.getId());
                claimsItem.setCreateUserName(user.getNickName());
                claimsItem.setUpdateUserName(user.getNickName());
                claimsItem.setCreateTime(now);
                claimsItem.setUpdateTime(now);
                if (StringUtils.isEmpty((String)claimsItem.getSupCompanySapCode())) {
                    String name = claimsItem.getSupCompanyName();
                    CompanyExample example = new CompanyExample();
                    CompanyExample.Criteria criteria = example.createCriteria();
                    criteria.andCompanyNameEqualTo(name);
                    List companyList = this.companyService.queryAllObjByExample((IExample)example);
                    if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                        Company company = (Company)companyList.get(0);
                        claimsItem.setSupCompanySapCode(company.getCompanyCode());
                    }
                }
                if (StringUtils.isEmpty((String)claimsItem.getMaterialCode())) {
                    String mapNo = claimsItem.getMapNo();
                    String materialName = claimsItem.getMaterialName();
                    MaterialExample materialExample = new MaterialExample();
                    MaterialExample.Criteria criteria = materialExample.createCriteria();
                    criteria.andMaterialNameEqualTo(materialName);
                    criteria.andFigureTypeEqualTo(mapNo);
                    List materialList = this.materialService.queryAllObjByExample((IExample)materialExample);
                    if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                        Material material = (Material)materialList.get(0);
                        claimsItem.setMaterialCode(material.getMaterialCode());
                    }
                }
                this.addObj(claimsItem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void addClaims(String projectId, String companyId, User user, Claims claims) {
        Date now = new Date();
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("CLAIMS_FORM_NO");
        claims.setClaimsNo(billNo);
        claims.setProjectId(projectId);
        claims.setCompanyId(companyId);
        claims.setCreateUserId(user.getId());
        claims.setUpdateUserId(user.getId());
        claims.setCreateUserName(user.getNickName());
        claims.setUpdateUserName(user.getNickName());
        claims.setCreateTime(now);
        claims.setUpdateTime(now);
        if (StringUtils.isEmpty((String)claims.getSupCompanySapCode())) {
            String name = claims.getSupCompanyName();
            CompanyExample example = new CompanyExample();
            CompanyExample.Criteria criteria = example.createCriteria();
            criteria.andCompanyNameEqualTo(name);
            List companyList = this.companyService.queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                Company company = (Company)companyList.get(0);
                claims.setSupCompanySapCode(company.getCompanyCode());
            }
        }
        if (StringUtils.isEmpty((String)claims.getMaterialCode())) {
            String mapNo = claims.getMapNo();
            String materialName = claims.getMaterialName();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andMaterialNameEqualTo(materialName);
            criteria.andFigureTypeEqualTo(mapNo);
            List materialList = this.materialService.queryAllObjByExample((IExample)materialExample);
            if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                Material material = (Material)materialList.get(0);
                claims.setMaterialCode(material.getMaterialCode());
            }
        }
        this.addObj(claims);
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void pushToSupplier(User loginUser, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims claims : list) {
            try {
                Claims claimsUpdate = this.queryObjById(claims.getId());
                if (Constant.YES_INT.equals(claimsUpdate.getSendStatus())) {
                    throw new CommonException("\u7d22\u8d54\u5355" + claimsUpdate.getClaimsNo() + " \u5df2\u7ecf\u53d1\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u9001");
                }
                if (claims != null) {
                    claims.setSendStatus(Constant.YES_INT);
                    claims.setBillStatus(ClaimsStatusEnum.STATUS_PUBLIC.getValue());
                    claims.setUpdateUserId(loginUser.getId());
                    claims.setUpdateUserName(loginUser.getNickName());
                    claims.setUpdateTime(now);
                }
                this.modifyObj(claims);
            }
            catch (CommonException ee) {
                throw new CommonException("\u53d1\u9001\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void pushToSuppliers(User user, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Date now = new Date();
        for (String id : ids) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (Constant.YES_INT.equals(claimsUpdate.getSendStatus())) {
                    throw new CommonException("\u7d22\u8d54\u5355" + claimsUpdate.getClaimsNo() + " \u5df2\u7ecf\u53d1\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u9001");
                }
                if (claimsUpdate != null) {
                    claimsUpdate.setSendStatus(Constant.YES_INT);
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_PUBLIC.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u53d1\u9001\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void pushToEngineering(User user, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Date now = new Date();
        for (String id : ids) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue().equals(claimsUpdate.getBillStatus())) {
                    throw new CommonException("\u7d22\u8d54\u5355" + claimsUpdate.getClaimsNo() + "\u5df2\u7ecf\u53d1\u9001\u8fc7\u8d28\u91cf\u90e8");
                }
                if (claimsUpdate != null) {
                    claimsUpdate.setIsSendEngineering(Constant.YES_INT);
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u53d1\u9001\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void engineeringConfirm(User loginUser, Claims claims) {
        Date now = new Date();
        if (StringUtils.isEmpty((String)claims.getEngineeringOpinion())) {
            throw new CommonException("\u8d28\u91cf\u90e8\u56de\u590d\u7d22\u8d54\u5355" + claims.getEngineeringOpinion() + "\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (claims != null) {
            claims.setUpdateUserId(loginUser.getId());
            claims.setUpdateUserName(loginUser.getNickName());
            claims.setUpdateTime(now);
            claims.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue());
        }
        this.modifyObj(claims);
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void engineeringRefused(User loginUser, Claims claims) {
        Date now = new Date();
        if (StringUtils.isEmpty((String)claims.getEngineeringOpinion())) {
            throw new CommonException("\u8d28\u91cf\u90e8\u56de\u590d\u7d22\u8d54\u5355" + claims.getClaimsNo() + "\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (claims != null) {
            claims.setUpdateUserId(loginUser.getId());
            claims.setUpdateUserName(loginUser.getNickName());
            claims.setUpdateTime(now);
            claims.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING_REJECT.getValue());
        }
        this.modifyObj(claims);
    }

    @Override
    public int countByExample(ClaimsExample example) {
        return this.claimsMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void sendToSign(User user, List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (String id : list) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (claimsUpdate != null) {
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u9001\u7b7e\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void supplerAcceptClaims(User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty((String)claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_ACCEPT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u540c\u610f\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public String supplierAppealClaims(String projectid, Company company, User user, List<Claims> list) {
        String appealId = "";
        if (CollectionUtils.isEmpty(list)) {
            return appealId;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty((String)claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_REJECT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
                appealId = this.appealFormService.createAppeal(list.get(0), projectid, company, user);
            }
            catch (CommonException ee) {
                throw new CommonException("\u7533\u8bc9\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
        return appealId;
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void addAttachment(User user, Claims claims) {
        Date now = new Date();
        claims.setUpdateUserId(user.getId());
        claims.setUpdateUserName(user.getNickName());
        claims.setUpdateTime(now);
        this.modifyObj(claims);
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void acceptSupplierAppealClaims(User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty((String)claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u540c\u610f\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"claims"}, allEntries=true)
    public void refuseSupplierAppealClaims(User user, List<Claims> list) {
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty((String)claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setPurchasingReply(item.getPurchasingReply());
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING_REJECT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            }
            catch (CommonException ee) {
                throw new CommonException("\u62d2\u7edd\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }
}

