/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.claims.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.appealform.service.AppealFormService;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.entity.ClaimsExample;
import com.els.base.quality.claims.service.ClaimsService;
import com.els.base.quality.claims.utils.ClaimsStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7d22\u8d54\u5355")
@Controller
@RequestMapping(value={"claims"})
public class ClaimsController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected ClaimsService claimsService;
    @Resource
    protected AppealFormService appealFormService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Claims claims) {
        this.claimsService.addObj(claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/add"})
    @ResponseBody
    public ResponseResult<String> add(@RequestBody Claims claims) {
        Assert.isNotBlank((String)claims.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)claims.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)claims.getAmount(), (String)"\u7d22\u8d54\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        this.claimsService.addClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Claims claims) {
        Assert.isNotBlank((String)claims.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.claimsService.modifyObj(claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.claimsService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5355\u636e!");
        }
        for (String id : list) {
            Claims entity = (Claims)this.claimsService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_NEW.getValue())) {
                this.claimsService.deleteObjById(id);
                continue;
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7d22\u8d54\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Claims", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Claims>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView((PageView<Claims>)new PageView(pageNo, pageSize));
        ClaimsExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.claimsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9f\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/invalidByIdArray"})
    @ResponseBody
    public ResponseResult<String> invalidByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            Claims entity = (Claims)this.claimsService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_NEW.getValue()) || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_INVALID.getValue()) || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_SUPPLIED_ACCEPT.getValue()) || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue())) {
                throw new CommonException("\u6240\u9009\u8bb0\u5f55\u5305\u542b\u672a\u53d1\u9001\u6216\u4f9b\u65b9\u786e\u8ba4\u6216\u4f5c\u5e9f\u6216\u540c\u610f\u4f9b\u65b9\u7533\u8bc9\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4f5c\u5e9f!!");
            }
            entity.setBillStatus(ClaimsStatusEnum.STATUS_INVALID.getValue());
            entity.setIsEnable(Constant.NO_INT);
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.claimsService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7d22\u8d54\u5355\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pushToSuppliers"})
    @ResponseBody
    public ResponseResult<String> pushToSuppliers(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.claimsService.pushToSupplier(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7d22\u8d54\u5355\u53d1\u5e03\u8d28\u91cf\u90e8")
    @RequestMapping(value={"service/pushToEngineering"})
    @ResponseBody
    public ResponseResult<String> pushToEngineering(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u7684\u6570\u636e!");
        }
        this.claimsService.pushToEngineering(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u90e8\u786e\u8ba4")
    @RequestMapping(value={"service/engineeringConfirm"})
    @ResponseBody
    public ResponseResult<String> engineeringConfirm(@RequestBody Claims claims) {
        Assert.isNotBlank((String)claims.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.claimsService.engineeringConfirm(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u90e8\u62d2\u7edd")
    @RequestMapping(value={"service/engineeringRefused"})
    @ResponseBody
    public ResponseResult<String> engineeringRefused(@RequestBody Claims claims) {
        Assert.isNotBlank((String)claims.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.claimsService.engineeringRefused(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7d22\u8d54\u5355 \u4f9b\u5e94\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Claims", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerClaimsByPage"})
    @ResponseBody
    public ResponseResult<PageView<Claims>> findSupplerClaimsByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView((PageView<Claims>)new PageView(pageNo, pageSize));
        ClaimsExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusEqualTo(ClaimsStatusEnum.STATUS_NEW.getValue());
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.claimsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7d22\u8d54\u5355 \u8d28\u91cf\u90e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Claims", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/engineeringFindSupplerClaimsByPage"})
    @ResponseBody
    public ResponseResult<PageView<Claims>> engineeringFindSupplerClaimsByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView((PageView<Claims>)new PageView(pageNo, pageSize));
        ClaimsExample.Criteria criteria = example.createCriteria();
        criteria.andBillStatusEqualTo(ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.claimsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u540c\u610f\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/supplierAcceptClaims"})
    @ResponseBody
    public ResponseResult<String> supplierAcceptClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u540c\u610f\u7684\u6570\u636e!");
        }
        this.claimsService.supplerAcceptClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u7533\u8bc9\u7d22\u8d54\u5355")
    @RequestMapping(value={"service/supplierAppealClaims"})
    @ResponseBody
    public ResponseResult<String> supplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u7533\u8bc9\u7684\u5355\u636e!");
        }
        if (list.size() != 1) {
            throw new CommonException("\u53ea\u80fd\u64cd\u4f5c\u4e00\u7b14\u7d22\u8d54\u5355!");
        }
        Claims claims = list.get(0);
        if (StringUtils.isEmpty((String)claims.getSupplierReply())) {
            throw new CommonException("\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String appealFromId = this.claimsService.supplierAppealClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success((Object)appealFromId);
    }

    @ApiOperation(httpMethod="POST", value="\u540c\u610f\u7533\u8bc9")
    @RequestMapping(value={"service/acceptSupplierAppealClaims"})
    @ResponseBody
    public ResponseResult<String> acceptSupplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u7684\u6570\u636e!");
        }
        this.claimsService.acceptSupplierAppealClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62d2\u7edd\u7533\u8bc9")
    @RequestMapping(value={"service/refuseSupplierAppealClaims"})
    @ResponseBody
    public ResponseResult<String> refuseSupplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u7684\u6570\u636e!");
        }
        this.claimsService.refuseSupplierAppealClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody Claims claims) {
        if (StringUtils.isBlank((String)claims.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.claimsService.addAttachment(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7d22\u8d54\u5355\u9001\u7b7e")
    @RequestMapping(value={"service/sendToSign"})
    @ResponseBody
    public ResponseResult<String> sendToSign(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u7684\u6570\u636e!");
        }
        this.claimsService.pushToSuppliers(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7d22\u8d54\u5355 Excel", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importClaimsFromExcel"})
    public ResponseResult<String> importClaimsFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            this.logger.info("\u5bfc\u5165\u7d22\u8d54\u5355----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            this.logger.info("\u5bfc\u5165\u7d22\u8d54\u5355\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        this.logger.info("\u5bfc\u5165\u7d22\u8d54\u5355titleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<Claims> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Claims.class);
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.claimsService.importClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7d22\u8d54\u5355 Txt", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importClaimsFromTxt"})
    public ResponseResult<String> importClaimsFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"attribute2", "attribute1", "supCompanySapCode", "supCompanyName", "materialCode", "materialName", "mapNo", "quantity", "inspectionType", "description", "orderNo", "orderAmount", "amount", "processMode", "requestResponseTime", "memo"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", Claims.class, (String[])keys);
            List list = importTxt.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.claimsService.importClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="\u7d22\u8d54\u5355\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7d22\u8d54\u5355\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"FRCASE", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u63d0\u51fa\u4eba", (String)"attribute2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u91cf\u7d22\u8d54\u5355\u53f7", (String)"attribute1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546sap\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u4ee3\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u7c7b\u522b", (String)"inspectionType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u60c5\u51b5\u7efc\u8ff0", (String)"description"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\u53f7(\u8ba2\u5355\u53f7)", (String)"orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c(\u8ba2\u5355)\u91d1\u989d", (String)"orderAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7d22\u8d54\u91d1\u989d", (String)"amount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"processMode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8981\u6c42\u4f9b\u5e94\u5546\u56de\u590d\u65f6\u95f4", (String)"requestResponseTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadReportExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(@ApiParam(value="\u7d22\u8d54\u5355\u636eid", defaultValue="") @RequestParam(defaultValue="") String idArray, HttpServletResponse response) {
        try {
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u53c2\u6570" + idArray);
            ClaimsExample example = new ClaimsExample();
            if (StringUtils.isNotBlank((String)idArray)) {
                example.createCriteria().andIdIn((List)Arrays.asList(idArray.split(",")));
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List claimsList = this.claimsService.queryAllObjByExample((IExample)example);
            block12: for (Claims claims : claimsList) {
                switch (claims.getBillStatus()) {
                    case 1: {
                        claims.setAttribute1("\u65b0\u589e");
                        continue block12;
                    }
                    case 2: {
                        claims.setAttribute1("\u5ba1\u6838\u4e2d");
                        continue block12;
                    }
                    case 3: {
                        claims.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block12;
                    }
                    case 4: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u540c\u610f");
                        continue block12;
                    }
                    case 5: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 6: {
                        claims.setAttribute1("\u540c\u610f\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 7: {
                        claims.setAttribute1("\u62d2\u7edd\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 8: {
                        claims.setAttribute1("\u53d1\u9001\u7ed9\u8d28\u91cf\u90e8");
                        continue block12;
                    }
                }
                claims.setAttribute1("\u4f5c\u5e9f");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u7d22\u8d54\u5355\u636e" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u7d22\u8d54\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bc9\u539f\u56e0", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u7c7b\u522b", (String)"inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u60c5\u51b5\u7efc\u8ff0", (String)"description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\u53f7\uff08\u8ba2\u5355\u53f7\uff09", (String)"orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\uff08\u8ba2\u5355\uff09\u91d1\u989d", (String)"orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7d22\u8d54\u91d1\u989d", (String)"amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u4eba", (String)"createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)claimsList, (String)"\u7d22\u8d54\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u91c7\u8d2d\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/purdownloadReportExcel"})
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        this.logger.info("queryParams={}", (Object)queryParams);
        try {
            ClaimsExample example = new ClaimsExample();
            ClaimsExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List claimsList = this.claimsService.queryAllObjByExample((IExample)example);
            block12: for (Claims claims : claimsList) {
                switch (claims.getBillStatus()) {
                    case 1: {
                        claims.setAttribute1("\u65b0\u589e");
                        continue block12;
                    }
                    case 2: {
                        claims.setAttribute1("\u5ba1\u6838\u4e2d");
                        continue block12;
                    }
                    case 3: {
                        claims.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block12;
                    }
                    case 4: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u540c\u610f");
                        continue block12;
                    }
                    case 5: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 6: {
                        claims.setAttribute1("\u540c\u610f\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 7: {
                        claims.setAttribute1("\u62d2\u7edd\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 8: {
                        claims.setAttribute1("\u53d1\u9001\u7ed9\u8d28\u91cf\u90e8");
                        continue block12;
                    }
                }
                claims.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + claimsList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u7d22\u8d54\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u7d22\u8d54\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bc9\u539f\u56e0", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u7c7b\u522b", (String)"inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u60c5\u51b5\u7efc\u8ff0", (String)"description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\u53f7\uff08\u8ba2\u5355\u53f7\uff09", (String)"orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\uff08\u8ba2\u5355\uff09\u91d1\u989d", (String)"orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7d22\u8d54\u91d1\u989d", (String)"amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u4eba", (String)"createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u7d22\u8d54\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)claimsList, (String)"\u7d22\u8d54\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/supdownloadReportExcel"})
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            ClaimsExample example = new ClaimsExample();
            ClaimsExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            criteria.andSendStatusEqualTo(ClaimsStatusEnum.STATUS_NEW.getValue());
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
            example.setOrderByClause(" UPDATE_TIME DESC");
            List claimsList = this.claimsService.queryAllObjByExample((IExample)example);
            block12: for (Claims claims : claimsList) {
                switch (claims.getBillStatus()) {
                    case 1: {
                        claims.setAttribute1("\u65b0\u589e");
                        continue block12;
                    }
                    case 2: {
                        claims.setAttribute1("\u5ba1\u6838\u4e2d");
                        continue block12;
                    }
                    case 3: {
                        claims.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block12;
                    }
                    case 4: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u540c\u610f");
                        continue block12;
                    }
                    case 5: {
                        claims.setAttribute1("\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 6: {
                        claims.setAttribute1("\u540c\u610f\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 7: {
                        claims.setAttribute1("\u62d2\u7edd\u4f9b\u5e94\u5546\u7533\u8bc9");
                        continue block12;
                    }
                    case 8: {
                        claims.setAttribute1("\u53d1\u9001\u7ed9\u8d28\u91cf\u90e8");
                        continue block12;
                    }
                }
                claims.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + claimsList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u7d22\u8d54\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("\u7d22\u8d54\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bc9\u539f\u56e0", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u7c7b\u522b", (String)"inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u60c5\u51b5\u7efc\u8ff0", (String)"description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\u53f7\uff08\u8ba2\u5355\u53f7\uff09", (String)"orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u540c\uff08\u8ba2\u5355\uff09\u91d1\u989d", (String)"orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7d22\u8d54\u91d1\u989d", (String)"amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u4eba", (String)"createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("\u7d22\u8d54\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)claimsList, (String)"\u7d22\u8d54\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
            this.logger.info("\u7d22\u8d54\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

