/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.concession.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.concession.dao.ConcessionApplyMapper;
import com.els.base.quality.concession.entity.ConcessionApply;
import com.els.base.quality.concession.entity.ConcessionApplyExample;
import com.els.base.quality.concession.service.ConcessionApplyService;
import com.els.base.quality.concession.utils.UnApplyStatusEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultConcessionApplyService")
public class ConcessionApplyServiceImpl
implements ConcessionApplyService,
ITaskListener {
    @Resource
    protected ConcessionApplyMapper concessionApplyMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected WorkFlowService workFlowService;

    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void addObj(ConcessionApply t) {
        this.concessionApplyMapper.insertSelective(t);
    }

    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void deleteObjById(String id) {
        this.concessionApplyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void modifyObj(ConcessionApply t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.concessionApplyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"concessionApply"}, keyGenerator="redisKeyGenerator")
    public ConcessionApply queryObjById(String id) {
        return this.concessionApplyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"concessionApply"}, keyGenerator="redisKeyGenerator")
    public List<ConcessionApply> queryAllObjByExample(ConcessionApplyExample example) {
        return this.concessionApplyMapper.selectByExample(example);
    }

    @Cacheable(value={"concessionApply"}, keyGenerator="redisKeyGenerator")
    public PageView<ConcessionApply> queryObjByPage(ConcessionApplyExample example) {
        PageView<ConcessionApply> pageView = example.getPageView();
        pageView.setQueryResult(this.concessionApplyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void initiateConcession(List<UnQualifiedBill> list) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        ConcessionApply applyEntity = new ConcessionApply();
        for (UnQualifiedBill entity : list) {
            GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
            String billNo = generateCodeService.getNextCode("CONCESSION_APPLY_NO");
            applyEntity.setProjectId(projectId);
            applyEntity.setCompanyId(companyId);
            applyEntity.setIsEnable(Constant.YES_INT);
            applyEntity.setBillNo(billNo);
            applyEntity.setBillStatus(UnApplyStatusEnum.STATUS_NEW.getValue());
            applyEntity.setMaterialCode(entity.getMaterialCode());
            applyEntity.setMaterialName(entity.getMaterialName());
            applyEntity.setMaterialSpecification(entity.getMaterialSpecification());
            applyEntity.setSupCompanyCode(entity.getSupCompanyCode());
            applyEntity.setSupCompanyName(entity.getSupCompanyName());
            applyEntity.setSupCompanySapCode(entity.getSupCompanySapCode());
            applyEntity.setMapNo(entity.getMapNo());
            applyEntity.setBillDate(new Date());
            applyEntity.setQuantity(entity.getQuantity());
            applyEntity.setConcessionReason(entity.getDisqualification());
            applyEntity.setConcessionProcess("\u8fdb\u8d27");
            applyEntity.setQuantity(entity.getQuantity());
            applyEntity.setUnqualifiedBillId(entity.getId());
            applyEntity.setUnqualifiedBillNo(entity.getBillNo());
            Date nowDate = new Date();
            applyEntity.setUpdateTime(nowDate);
            applyEntity.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            applyEntity.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            applyEntity.setCreateTime(nowDate);
            applyEntity.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            applyEntity.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            this.addObj(applyEntity);
        }
    }

    @Override
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void pushToBuyer(List<ConcessionApply> list) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        for (ConcessionApply item : list) {
            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(item.getId()).andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId);
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            ConcessionApply concessionApply = ConcessionApplyArray.get(0);
            concessionApply.setBillStatus(UnApplyStatusEnum.STATUS_PUBLIC.getValue());
            Date nowDate = new Date();
            concessionApply.setUpdateTime(nowDate);
            concessionApply.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            concessionApply.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(concessionApply);
        }
    }

    @Override
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void sendToSign(List<ConcessionApply> list) {
        for (ConcessionApply applyBill : list) {
            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            ConcessionApply applyBillSign = ConcessionApplyArray.get(0);
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"hjd", (String)applyBillSign.getBillNo(), (String)applyBillSign.getId(), (String)("pricing?id=" + applyBillSign.getId()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVING.getValue());
            this.concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
        }
    }

    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        ConcessionApply bill = this.concessionApplyMapper.selectByPrimaryKey(businessId);
        String assignee = StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        if (event.isFinished() && event.isPass()) {
            bill.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_SUCCESS.getValue());
            bill.setApproveComments(result);
            this.concessionApplyMapper.updateByPrimaryKeySelective(bill);
        } else if (event.isFinished() && !event.isPass()) {
            bill.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_REFUSED.getValue());
            bill.setApproveComments(result);
            this.concessionApplyMapper.updateByPrimaryKeySelective(bill);
        }
    }

    @Override
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void acceptToSuppler(List<ConcessionApply> list) {
        for (ConcessionApply applyBill : list) {
            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            ConcessionApply applyBillSign = ConcessionApplyArray.get(0);
            applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_SUCCESS.getValue());
            this.concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
        }
    }

    @Override
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void refuseToSuppler(List<ConcessionApply> list) {
        for (ConcessionApply applyBill : list) {
            ConcessionApplyExample example = new ConcessionApplyExample();
            ConcessionApplyExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(applyBill.getId());
            List<ConcessionApply> ConcessionApplyArray = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(ConcessionApplyArray)) {
                throw new CommonException("\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            ConcessionApply applyBillSign = ConcessionApplyArray.get(0);
            applyBillSign.setBillStatus(UnApplyStatusEnum.STATUS_APPROVE_REFUSED.getValue());
            this.concessionApplyMapper.updateByPrimaryKeySelective(applyBillSign);
        }
    }

    @Transactional
    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void addAll(List<ConcessionApply> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.concessionApplyMapper.insertSelective((ConcessionApply)item);
        });
    }

    @CacheEvict(value={"concessionApply"}, allEntries=true)
    public void deleteByExample(ConcessionApplyExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.concessionApplyMapper.deleteByExample(arg0);
    }
}

