/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.concession.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.concession.entity.ConcessionApply;
import com.els.base.quality.concession.entity.ConcessionApplyExample;
import com.els.base.quality.concession.service.ConcessionApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
@Controller
@RequestMapping(value={"concessionApply"})
public class ConcessionApplyController {
    @Resource
    protected ConcessionApplyService concessionApplyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ConcessionApply concessionApply) {
        this.concessionApplyService.addObj(concessionApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ConcessionApply concessionApply) {
        Assert.isNotBlank((String)concessionApply.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.concessionApplyService.modifyObj(concessionApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.concessionApplyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ConcessionApply", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ConcessionApply>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ConcessionApplyExample example = new ConcessionApplyExample();
        example.setPageView((PageView<ConcessionApply>)new PageView(pageNo, pageSize));
        ConcessionApplyExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.concessionApplyService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355--\u4f9b\u5e94\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ConcessionApply", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerByPage"})
    @ResponseBody
    public ResponseResult<PageView<ConcessionApply>> findSupplerByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ConcessionApplyExample example = new ConcessionApplyExample();
        example.setPageView((PageView<ConcessionApply>)new PageView(pageNo, pageSize));
        ConcessionApplyExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.concessionApplyService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u63a8\u9001\u8ba9\u6b65\u7533\u8bf7\u63a5\u6536\u5355\u7ed9\u91c7\u8d2d\u5458")
    @RequestMapping(value={"service/pushToBuyer"})
    @ResponseBody
    public ResponseResult<String> pushToBuyer(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u7684\u6570\u636e!");
        }
        this.concessionApplyService.pushToBuyer(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\u9001\u7b7e")
    @RequestMapping(value={"service/sendToSign"})
    @ResponseBody
    public ResponseResult<String> sendToSign(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u9001\u7b7e\u7684\u6570\u636e!");
        }
        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/acceptToSuppler"})
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u9001\u7b7e\u7684\u6570\u636e!");
        }
        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62d2\u7edd\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/refuseToSuppler"})
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<ConcessionApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u9001\u7b7e\u7684\u6570\u636e!");
        }
        for (ConcessionApply item : list) {
            if (!StringUtils.isEmpty((String)item.getPurchasingReply())) continue;
            throw new CommonException("\u8ba9\u6b65\u63a5\u6536\u7533\u8bf7\u5355\uff1a" + item.getBillNo() + "\u56de\u590d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u62d2\u7edd!");
        }
        this.concessionApplyService.sendToSign(list);
        return ResponseResult.success();
    }
}

