/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.fracas.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.quality.fracas.dao.FraCasMapper;
import com.els.base.quality.fracas.entity.FraCas;
import com.els.base.quality.fracas.entity.FraCasExample;
import com.els.base.quality.fracas.service.FraCasService;
import com.els.base.quality.fracas.utils.FraCasStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFraCasService")
public class FraCasServiceImpl
implements FraCasService {
    @Resource
    protected FraCasMapper fraCasMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void addObj(FraCas t) {
        this.fraCasMapper.insertSelective(t);
    }

    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void deleteObjById(String id) {
        this.fraCasMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void modifyObj(FraCas t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.fraCasMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"fraCas"}, keyGenerator="redisKeyGenerator")
    public FraCas queryObjById(String id) {
        return this.fraCasMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"fraCas"}, keyGenerator="redisKeyGenerator")
    public List<FraCas> queryAllObjByExample(FraCasExample example) {
        return this.fraCasMapper.selectByExample(example);
    }

    @Cacheable(value={"fraCas"}, keyGenerator="redisKeyGenerator")
    public PageView<FraCas> queryObjByPage(FraCasExample example) {
        PageView<FraCas> pageView = example.getPageView();
        pageView.setQueryResult(this.fraCasMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void importFraCas(String projectId, String companyId, User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                item.setStatus(FraCasStatusEnum.STATUS_IMPORT.getValue());
                item.setProjectId(projectId);
                item.setCompanyId(companyId);
                item.setCreateUserId(user.getId());
                item.setUpdateUserId(user.getId());
                item.setCreateUserName(user.getNickName());
                item.setUpdateUserName(user.getNickName());
                item.setCreateTime(now);
                item.setUpdateTime(now);
                this.addObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void addFraCas(String projectId, String companyId, com.els.base.auth.entity.User user, FraCas fraCas) {
        Date now = new Date();
        fraCas.setStatus(FraCasStatusEnum.STATUS_NEW.getValue());
        fraCas.setProjectId(projectId);
        fraCas.setCompanyId(companyId);
        fraCas.setCreateUserId(user.getId());
        fraCas.setUpdateUserId(user.getId());
        fraCas.setCreateUserName(user.getNickName());
        fraCas.setUpdateUserName(user.getNickName());
        fraCas.setCreateTime(now);
        fraCas.setUpdateTime(now);
        this.addObj(fraCas);
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void pushedToBuyer(String projectId, String companyId, User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                if (StringUtils.isEmpty((String)item.getSupCompanySapCode())) {
                    throw new CommonException("\u5c1a\u672a\u8bbe\u7f6eFRACAS\u5355\u636e\u8d23\u4efb\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u5206\u914d\u7ed9\u5bf9\u5e94\u7684\u91c7\u8d2d");
                }
                FraCas fracas = this.queryObjById(item.getId());
                if (!FraCasStatusEnum.STATUS_IMPORT.getValue().equals(fracas.getStatus())) {
                    throw new CommonException("\u53ea\u6709\u5bfc\u5165\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u53d1\u9001\u91c7\u8d2d\u5458\uff01");
                }
                Company supCompany = null;
                CompanyExample supompanyExample = new CompanyExample();
                supompanyExample.createCriteria().andCompanySapCodeEqualTo(item.getSupCompanySapCode());
                List supCompanyList = this.companyService.queryAllObjByExample((IExample)supompanyExample);
                if (CollectionUtils.isNotEmpty((Collection)supCompanyList)) {
                    supCompany = (Company)supCompanyList.get(0);
                }
                CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
                CompanyPurRefExample.Criteria companyPurRefCriteria = companyPurRefExample.createCriteria();
                companyPurRefCriteria.andProjectIdEqualTo(projectId);
                companyPurRefCriteria.andSupCompanyIdEqualTo(supCompany.getId());
                companyPurRefCriteria.andPurCompanyIdEqualTo(companyId);
                List Clist = this.companyPurRefService.queryAllObjByExample((IExample)companyPurRefExample);
                if (Clist.isEmpty()) {
                    throw new CommonException("\u4f9b\u5e94\u5546" + supCompany.getCompanyName() + "\u5c1a\u672a\u7ef4\u62a4\u5bf9\u5e94\u7684\u91c7\u8d2d\u5458\uff0c\u65e0\u6cd5\u5206\u914d\u7ed9\u5bf9\u5e94\u7684\u91c7\u8d2d\u5458!");
                }
                item.setStatus(FraCasStatusEnum.STATUS_NEW.getValue());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setUpdateTime(now);
                this.modifyObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void pushedToSuppler(String projectId, String companyId, User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                item.setSendStatus(Constant.YES_INT);
                item.setStatus(FraCasStatusEnum.STATUS_PUBLIC.getValue());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setUpdateTime(now);
                this.modifyObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void supplerResponse(User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                item.setStatus(FraCasStatusEnum.STATUS_CONFIRM.getValue());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setUpdateTime(now);
                this.modifyObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void acceptToSuppler(String projectId, String companyId, User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                item.setStatus(FraCasStatusEnum.STATUS_APPROVE.getValue());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setUpdateTime(now);
                this.modifyObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void refuseToSuppler(String projectId, String companyId, User user, List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (FraCas item : list) {
            try {
                item.setStatus(FraCasStatusEnum.STATUS_REFUSED.getValue());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setUpdateTime(now);
                this.modifyObj(item);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void addAttachment(User user, FraCas fraCas) {
        Date now = new Date();
        fraCas.setUpdateUserId(user.getId());
        fraCas.setUpdateUserName(user.getNickName());
        fraCas.setUpdateTime(now);
        this.fraCasMapper.updateByPrimaryKey(fraCas);
    }

    @Override
    @Cacheable(value={"fraCas"}, keyGenerator="redisKeyGenerator")
    public int countByExample(FraCasExample fraCasExample) {
        int countByExample = this.fraCasMapper.countByExample(fraCasExample);
        return countByExample;
    }

    @Transactional
    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void addAll(List<FraCas> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.fraCasMapper.insertSelective((FraCas)item);
        });
    }

    @CacheEvict(value={"fraCas"}, allEntries=true)
    public void deleteByExample(FraCasExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.fraCasMapper.deleteByExample(arg0);
    }
}

