/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.fracas.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.fracas.entity.FraCas;
import com.els.base.quality.fracas.entity.FraCasExample;
import com.els.base.quality.fracas.service.FraCasService;
import com.els.base.quality.fracas.utils.FraCasStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="FRACAS \u8868\u5355\u6570\u636e")
@Controller
@RequestMapping(value={"fraCas"})
public class FraCasController {
    private static Logger logger = LoggerFactory.getLogger(FraCasController.class);
    @Resource
    protected FraCasService fraCasService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaFRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody FraCas fraCas) {
        this.fraCasService.addObj(fraCas);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u589efracas")
    @RequestMapping(value={"service/add"})
    @ResponseBody
    public ResponseResult<String> add(@RequestBody FraCas fraCas) {
        Assert.isNotBlank((String)fraCas.getFaultNumber(), (String)"\u6545\u969c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)fraCas.getDiscoveredDate(), (String)"\u53d1\u73b0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getProject(), (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getProductNo(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getParts(), (String)"\u96f6\u90e8\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getPartsNo(), (String)"\u96f6\u90e8\u4ef6\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getFailureMode(), (String)"\u6545\u969c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getFailureDescription(), (String)"\u6545\u969c\u73b0\u8c61(\u63cf\u8ff0)\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getFailureTiming(), (String)"\u53d1\u751f\u65f6\u673a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getFailureDeal(), (String)"\u6545\u969c\u5904\u7406\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getFailureStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getCurrentHandler(), (String)"\u5f53\u524d\u5904\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)fraCas.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0");
        this.fraCasService.addFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), fraCas);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91FRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody FraCas fraCas) {
        Assert.isNotBlank((String)fraCas.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.fraCasService.modifyObj(fraCas);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664FRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.fraCasService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664FRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5355\u636e!");
        }
        for (String id : list) {
            FraCas entity = (FraCas)this.fraCasService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue()) || entity.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue())) {
                this.fraCasService.deleteObjById(id);
                continue;
            }
            throw new CommonException("\u53ea\u6709\u672a\u53d1\u9001\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91FRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/setBillSuppler"})
    @ResponseBody
    public ResponseResult<String> setBillSuppler(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u4fdd\u5b58\u7684\u6570\u636e");
        }
        for (FraCas item : list) {
            if (!item.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue())) {
                throw new CommonException("\u53ea\u6709\u5bfc\u5165\u72b6\u6001\u624d\u53ef\u4ee5\u8bbe\u7f6e\u4f9b\u5e94\u5546");
            }
            if (StringUtils.isEmpty((String)item.getSupCompanySapCode())) {
                throw new CommonException("\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546");
            }
            this.fraCasService.modifyObj(item);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6FRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/viewById"})
    @ResponseBody
    public ResponseResult<FraCas> viewById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        FraCas fracas = (FraCas)this.fraCasService.queryObjById(id);
        return ResponseResult.success((Object)fracas);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2FRACAS \u8868\u5355\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FraCas", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView((PageView<FraCas>)new PageView(pageNo, pageSize));
        FraCasExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.fraCasService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u89e3\u5230\u91c7\u8d2d\u4e1a\u52a1")
    @RequestMapping(value={"service/pushedToBuyer"})
    @ResponseBody
    public ResponseResult<String> pushedToBuyer(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.fraCasService.pushedToBuyer(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2FRACAS \u8868\u5355\u6570\u636e,\u91c7\u8d2d\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FraCas", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findBuyerDataByPage"})
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findBuyerDataByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView((PageView<FraCas>)new PageView(pageNo, pageSize));
        FraCasExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
        ArrayList<String> companyCodeArray = new ArrayList<String>();
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.fraCasService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pushedToSuppler"})
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        for (FraCas item : list) {
            if (StringUtils.isEmpty((String)item.getRectificationType())) {
                throw new CommonException("\u5355\u636e\uff1a" + item.getFaultNumber() + "\u5904\u7406\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u5e03!");
            }
            FraCas entity = (FraCas)this.fraCasService.queryObjById(item.getId());
            if (entity == null) continue;
            if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue())) {
                if (!Constant.YES_INT.equals(item.getSendStatus())) continue;
                throw new CommonException("\u5355\u636e\uff1a" + item.getFaultNumber() + "\u5df2\u7ecf\u53d1\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u9001!");
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u53d1\u9001!");
        }
        this.fraCasService.pushedToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9fFRACAS \u8868\u5355\u6570\u636e")
    @RequestMapping(value={"service/invalidByIdArray"})
    @ResponseBody
    public ResponseResult<String> invalidByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            FraCas entity = (FraCas)this.fraCasService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getStatus().equals(FraCasStatusEnum.STATUS_NEW.getValue()) || entity.getStatus().equals(FraCasStatusEnum.STATUS_INVALID.getValue()) || entity.getStatus().equals(FraCasStatusEnum.STATUS_IMPORT.getValue()) || entity.getStatus().equals(FraCasStatusEnum.STATUS_APPROVE.getValue())) {
                throw new CommonException("\u6240\u9009\u8bb0\u5f55\u5305\u542b\u672a\u53d1\u9001\u6216\u91c7\u8d2d\u786e\u8ba4\u6216\u4f5c\u5e9f\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4f5c\u5e9f!!");
            }
            entity.setStatus(FraCasStatusEnum.STATUS_INVALID.getValue());
            entity.setIsEnable(Constant.NO_INT);
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.fraCasService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2FRACAS \u8868\u5355\u6570\u636e,\u4f9b\u5e94\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FraCas", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerDataByPage"})
    @ResponseBody
    public ResponseResult<PageView<FraCas>> findSupplerDataByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FraCasExample example = new FraCasExample();
        example.setPageView((PageView<FraCas>)new PageView(pageNo, pageSize));
        FraCasExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
        criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_NEW.getValue());
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.fraCasService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/supplerResponse"})
    @ResponseBody
    public ResponseResult<String> supplerResponse(@RequestBody List<FraCas> fraCasArray) {
        this.fraCasService.supplerResponse((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4NCR\u5355\u636e")
    @RequestMapping(value={"service/supplierAcceptBill"})
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<FraCas> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u786e\u8ba4\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (FraCas item : list) {
            if (StringUtils.isEmpty((String)item.getCauseAnalysis())) {
                throw new CommonException("\u5355\u636e\uff1a" + item.getFaultNumber() + "\u539f\u56e0\u5206\u6790\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            if (StringUtils.isEmpty((String)item.getCorrectiveAnalysis())) {
                throw new CommonException("\u5355\u636e\uff1a" + item.getFaultNumber() + "\u7ea0\u6b63\u63aa\u65bd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            Assert.isNotNull((Object)item.getCompletionDate(), (String)("\u5355\u636e\uff1a" + item.getFaultNumber() + "\u5b8c\u6210\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!"));
            item.setSupplierResponseTime(new Date());
            item.setStatus(FraCasStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
        }
        this.fraCasService.supplerResponse((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody FraCas fraCas) {
        if (StringUtils.isBlank((String)fraCas.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.fraCasService.addAttachment((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), fraCas);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u540c\u610f\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/acceptToSuppler"})
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.fraCasService.acceptToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u62d2\u7edd\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/refuseToSuppler"})
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<FraCas> fraCasArray) {
        if (CollectionUtils.isEmpty(fraCasArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.fraCasService.refuseToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), fraCasArray);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165FRACAS\u5355\u636e Excel", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importFarcasFromExcel"})
    public ResponseResult<String> importFarcasFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            logger.info("\u5bfc\u5165FRCASE\u5355\u636e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            logger.info("\u5bfc\u5165FRCASE\u5355\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        logger.info("\u5bfc\u5165FRCASE\u5355\u636etitleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<FraCas> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, FraCas.class);
        }
        catch (Exception e) {
            logger.info("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.fraCasService.importFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165FRCASE\u5355\u636e Txt", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importFarcasFromTxt"})
    public ResponseResult<String> importFarcasFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"faultNumber", "discoveredDate", "project", "productNo", "productName", "parts", "partsNo", "failureMode", "failureDescription", "failureTiming", "failureDeal", "failureReason", "correctiveAction", "failureStatus", "currentHandler", "supCompanySapCode", "getSupCompanyName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", FraCas.class, (String[])keys);
            List list = importTxt.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.fraCasService.importFraCas(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="FRCASE\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("FRACAS\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"FRCASE", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u7f16\u53f7", (String)"faultNumber", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u73b0\u65e5\u671f", (String)"discoveredDate", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u7f16\u7801", (String)"productNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u540d\u79f0", (String)"productName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6\u540d\u79f0", (String)"parts", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6\u5e8f\u5217\u53f7", (String)"partsNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u6a21\u5f0f", (String)"failureMode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u73b0\u8c61(\u63cf\u8ff0)", (String)"failureDescription", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65f6\u673a", (String)"failureTiming", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u5904\u7406", (String)"failureDeal", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6839\u672c\u539f\u56e0", (String)"failureReason", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ea0\u6b63\u63aa\u65bd", (String)"correctiveAction", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001", (String)"failureStatus", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"currentHandler", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546sap\u7f16\u7801", (String)"supCompanySapCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(value="FRACAS\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadReportExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(@ApiParam(value="FRACAS\u5355\u636eid", defaultValue="") @RequestParam(defaultValue="") String idArray, HttpServletResponse response) {
        try {
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u53c2\u6570" + idArray);
            FraCasExample example = new FraCasExample();
            if (StringUtils.isNotBlank((String)idArray)) {
                example.createCriteria().andIdIn((List)Arrays.asList(idArray.split(",")));
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List fraCasList = this.fraCasService.queryAllObjByExample((IExample)example);
            block9: for (FraCas fraCas : fraCasList) {
                switch (fraCas.getStatus()) {
                    case 1: {
                        fraCas.setAttribute1("\u65b0\u589e");
                        continue block9;
                    }
                    case 2: {
                        fraCas.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block9;
                    }
                    case 3: {
                        fraCas.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block9;
                    }
                    case 4: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block9;
                    }
                    case 5: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block9;
                    }
                }
                fraCas.setAttribute1("\u4f5c\u5e9f");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "FRACAS\u5355\u636e" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("FRACAS\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"faultNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u53f7", (String)"productNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u540d\u79f0", (String)"productName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65e5\u671f", (String)"discoveredDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6", (String)"parts"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6\u5e8f\u53f7", (String)"partsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u6a21\u5f0f", (String)"failureMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u73b0\u8c61", (String)"failureDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65f6\u673a", (String)"failureTiming"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u5904\u7406", (String)"failureDeal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ea0\u6b63\u63aa\u65bd", (String)"correctiveAction"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001", (String)"failureStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"currentHandler"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)fraCasList, (String)"FRACAS\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            fraCasList = null;
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u91c7\u8d2dFRACAS\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/purdownloadReportExcel"})
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            FraCasExample example = new FraCasExample();
            example.setOrderByClause(" UPDATE_TIME DESC");
            FraCasExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
            ArrayList<String> companyCodeArray = new ArrayList<String>();
            List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
            if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                for (Company company : companyList) {
                    companyCodeArray.add(company.getCompanySapCode());
                }
                criteria.andSupCompanySapCodeIn(companyCodeArray);
            }
            List fraCasList = this.fraCasService.queryAllObjByExample((IExample)example);
            block10: for (FraCas fraCas : fraCasList) {
                switch (fraCas.getStatus()) {
                    case 1: {
                        fraCas.setAttribute1("\u65b0\u589e");
                        continue block10;
                    }
                    case 2: {
                        fraCas.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block10;
                    }
                    case 3: {
                        fraCas.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block10;
                    }
                    case 4: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block10;
                    }
                    case 5: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block10;
                    }
                }
                fraCas.setAttribute1("\u4f5c\u5e9f");
            }
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + fraCasList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "FRACAS\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("FRACAS\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"faultNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u53f7", (String)"productNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u540d\u79f0", (String)"productName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65e5\u671f", (String)"discoveredDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6", (String)"parts"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6\u5e8f\u53f7", (String)"partsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u6a21\u5f0f", (String)"failureMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u73b0\u8c61", (String)"failureDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65f6\u673a", (String)"failureTiming"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u5904\u7406", (String)"failureDeal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ea0\u6b63\u63aa\u65bd", (String)"correctiveAction"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001", (String)"failureStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"currentHandler"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            logger.info("FRACAS\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)fraCasList, (String)"FRACAS\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            fraCasList = null;
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546FRACAS\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/supdownloadReportExcel"})
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            FraCasExample example = new FraCasExample();
            FraCasExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_IMPORT.getValue());
            criteria.andStatusNotEqualTo(FraCasStatusEnum.STATUS_NEW.getValue());
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
            example.setOrderByClause(" UPDATE_TIME DESC");
            List fraCasList = this.fraCasService.queryAllObjByExample((IExample)example);
            block9: for (FraCas fraCas : fraCasList) {
                switch (fraCas.getStatus()) {
                    case 1: {
                        fraCas.setAttribute1("\u65b0\u589e");
                        continue block9;
                    }
                    case 2: {
                        fraCas.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block9;
                    }
                    case 3: {
                        fraCas.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block9;
                    }
                    case 4: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block9;
                    }
                    case 5: {
                        fraCas.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block9;
                    }
                }
                fraCas.setAttribute1("\u4f5c\u5e9f");
            }
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + fraCasList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "FRACAS\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("FRACAS\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"faultNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u53f7", (String)"productNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u540d\u79f0", (String)"productName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65e5\u671f", (String)"discoveredDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6", (String)"parts"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u90e8\u4ef6\u5e8f\u53f7", (String)"partsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u6a21\u5f0f", (String)"failureMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u73b0\u8c61", (String)"failureDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u65f6\u673a", (String)"failureTiming"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6545\u969c\u5904\u7406", (String)"failureDeal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ea0\u6b63\u63aa\u65bd", (String)"correctiveAction"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001", (String)"failureStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"currentHandler"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            logger.info("FRACAS\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)fraCasList, (String)"FRACAS\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            fraCasList = null;
            logger.info("FRACAS\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

