/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.quality.harms.common.AbstractHarmsCommand;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateHarmsCmd
extends AbstractHarmsCommand<String> {
    private QualityHarmMaterialsVO vo;

    public CreateHarmsCmd(QualityHarmMaterialsVO vo) {
        this.vo = vo;
    }

    @Override
    public String execute(HarmsInvorker harmsInvorker) {
        this.verification(this.vo);
        this.dealVoData(this.vo, harmsInvorker);
        harmsInvorker.getQualityHarmMaterialsService().addObj(this.vo);
        for (QualityHarmMaterialsItem item : this.vo.getItemList()) {
            harmsInvorker.getQualityHarmMaterialsItemService().addObj(item);
        }
        return null;
    }

    private void dealVoData(QualityHarmMaterialsVO vo, HarmsInvorker harmsInvorker) {
        String id = UUIDGenerator.generateUUID();
        vo.setId(id);
        vo.setProjectId(ProjectUtils.getProjectId());
        vo.setPurUserId(SpringSecurityUtils.getLoginUserId());
        Company purCompany = this.getPurCompany();
        vo.setPurCompanyId(purCompany.getId());
        vo.setPurCompanySrmCode(purCompany.getCompanyCode());
        vo.setPurCompanyFullName(purCompany.getCompanyFullName());
        vo.setPurCompanyName(purCompany.getCompanyName());
        String billNo = harmsInvorker.getGenerateCodeService().getNextCode("Q_HARM_BILL_NO");
        vo.setHarmBillNo(billNo);
        vo.setSendStatus(Constant.NO_INT);
        vo.setReportCheckStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatusDesc());
        vo.setIsEnable(Constant.YES_INT);
        vo.setBillStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        vo.setCreateTime(new Date());
        for (QualityHarmMaterialsItem item : vo.getItemList()) {
            item.setProjectId(vo.getProjectId());
            item.setHarmMaterialId(id);
            item.setHarmBillNo(billNo);
            item.setCreateTime(new Date());
        }
    }

    private void verification(QualityHarmMaterialsVO vo) {
        Assert.isNotNull((Object)vo, (String)"\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanyFullName(), (String)"\u4f9b\u5e94\u5546\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getNecessaryFilling(), (String)"\u9009\u62e9\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        List<QualityHarmMaterialsItem> list = vo.getItemList();
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5355\u636e\u7684\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

