/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.command;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.quality.harms.common.AbstractHarmsCommand;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmFormsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyHarmsCmd
extends AbstractHarmsCommand<String> {
    private QualityHarmMaterialsVO vo;

    public ModifyHarmsCmd(QualityHarmMaterialsVO vo) {
        this.vo = vo;
    }

    @Override
    public String execute(HarmsInvorker harmsInvorker) {
        this.verification(this.vo);
        QualityHarmMaterials materials = (QualityHarmMaterials)harmsInvorker.getQualityHarmMaterialsService().queryObjById(this.vo.getId());
        if (materials.getSendStatus().equals(Constant.YES_INT)) {
            this.vo.setUpdateTime(new Date());
            QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
            example.createCriteria().andHarmMaterialIdEqualTo(this.vo.getId());
            List list = harmsInvorker.getQualityHarmMaterialsItemService().queryAllObjByExample((IExample)example);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u4fee\u6539\u7684\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (int i = 0; i < list.size(); ++i) {
                QualityHarmMaterialsItem item = (QualityHarmMaterialsItem)list.get(i);
                item.setOtherReportCode(this.vo.getItemList().get(i).getOtherReportCode());
                harmsInvorker.getQualityHarmMaterialsItemService().modifyObj(item);
                if (!this.vo.getBillStatus().equals(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus())) continue;
                QualityHarmFormsExample formsExample = new QualityHarmFormsExample();
                formsExample.createCriteria().andHarmMaterialItemIdEqualTo(item.getId());
                List harmForms = harmsInvorker.getQualityHarmFormsService().queryAllObjByExample((IExample)formsExample);
                for (QualityHarmForms qualityHarmForms : harmForms) {
                    QualityHarmForms forms = new QualityHarmForms();
                    forms.setId(qualityHarmForms.getId());
                    forms.setOtherReportCode(item.getOtherReportCode());
                    harmsInvorker.getQualityHarmFormsService().modifyObj(forms);
                }
            }
        }
        this.vo.setUpdateTime(new Date());
        harmsInvorker.getQualityHarmMaterialsService().modifyObj(this.vo);
        harmsInvorker.getQualityHarmMaterialsItemService().deleteByDetailId(this.vo.getId());
        for (QualityHarmMaterialsItem item : this.vo.getItemList()) {
            item.setCreateTime(new Date());
            item.setHarmMaterialId(this.vo.getId());
            item.setHarmBillNo(this.vo.getHarmBillNo());
            item.setProjectId(this.vo.getProjectId());
            harmsInvorker.getQualityHarmMaterialsItemService().addObj(item);
        }
        return null;
    }

    private void verification(QualityHarmMaterialsVO vo) {
        Assert.isNotNull((Object)vo, (String)"\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank((String)vo.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getSupCompanyFullName(), (String)"\u4f9b\u5e94\u5546\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)vo.getNecessaryFilling(), (String)"\u9009\u62e9\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        List<QualityHarmMaterialsItem> list = vo.getItemList();
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5355\u636e\u7684\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

